/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game.lottery;

import com.loohp.lotterysix.game.lottery.CompletedLotterySixGameIndex;
import com.loohp.lotterysix.game.lottery.LazyCompletedLotterySixGameList;
import com.loohp.lotterysix.game.objects.PrizeTier;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.Month;
import java.time.Year;
import java.time.ZonedDateTime;
import java.util.TimeZone;
import java.util.function.Predicate;

public class CompletedLotteryGamesQuery {
    private final boolean onlyWithSpecialName;
    private final Year year;
    private final Month month;
    private final DayOfWeek dayOfWeek;
    private final long firstTierPrizeAtLeast;

    public CompletedLotteryGamesQuery(boolean onlyWithSpecialName, Year year, Month month, DayOfWeek dayOfWeek, long firstTierPrizeAtLeast) {
        this.onlyWithSpecialName = onlyWithSpecialName;
        this.year = year;
        this.month = month;
        this.dayOfWeek = dayOfWeek;
        this.firstTierPrizeAtLeast = firstTierPrizeAtLeast;
    }

    public Predicate<CompletedLotterySixGameIndex> getQueryPredicate(LazyCompletedLotterySixGameList games, TimeZone timezone) {
        return index -> {
            if (this.onlyWithSpecialName && !index.hasSpecialName()) {
                return false;
            }
            ZonedDateTime time = ZonedDateTime.ofInstant(Instant.ofEpochMilli(index.getDatetime()), timezone.toZoneId());
            if (this.year != null && !Year.of(time.getYear()).equals(this.year)) {
                return false;
            }
            if (this.month != null && !time.getMonth().equals(this.month)) {
                return false;
            }
            if (this.dayOfWeek != null && !time.getDayOfWeek().equals(this.dayOfWeek)) {
                return false;
            }
            return this.firstTierPrizeAtLeast <= 0L || games.get((CompletedLotterySixGameIndex)index).getPrizeForTier(PrizeTier.FIRST) < this.firstTierPrizeAtLeast;
        };
    }

    public Builder toBuilder() {
        return Builder.builder().onlyWithSpecialName(this.onlyWithSpecialName).inYear(this.year).inMonth(this.month).inDayOfWeek(this.dayOfWeek).onlyIfFirstTierPrizeAtLeast(this.firstTierPrizeAtLeast);
    }

    public static class Builder {
        private boolean onlyWithSpecialName = false;
        private Year year = null;
        private Month month = null;
        private DayOfWeek dayOfWeek = null;
        private long firstTierPrizeAtLeast = 0L;

        public static Builder builder() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder onlyWithSpecialName(boolean onlyWithSpecialName) {
            this.onlyWithSpecialName = onlyWithSpecialName;
            return this;
        }

        public Builder inYear(Year year) {
            this.year = year;
            return this;
        }

        public Builder inMonth(Month month) {
            this.month = month;
            return this;
        }

        public Builder inDayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        public Builder onlyIfFirstTierPrizeAtLeast(long firstTierPrizeAtLeast) {
            this.firstTierPrizeAtLeast = firstTierPrizeAtLeast;
            return this;
        }

        public CompletedLotteryGamesQuery build() {
            return new CompletedLotteryGamesQuery(this.onlyWithSpecialName, this.year, this.month, this.dayOfWeek, this.firstTierPrizeAtLeast);
        }
    }
}

