/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game.lottery;

import com.loohp.lotterysix.libs.com.google.gson.TypeAdapter;
import com.loohp.lotterysix.libs.com.google.gson.annotations.JsonAdapter;
import com.loohp.lotterysix.libs.com.google.gson.stream.JsonReader;
import com.loohp.lotterysix.libs.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Objects;

public class GameNumber
implements Comparable<GameNumber> {
    public static final DateTimeFormatter YEAR_FORMAT = DateTimeFormatter.ofPattern("yy");
    public static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("000");
    public static final Comparator<GameNumber> COMPARATOR = Comparator.comparing(GameNumber::getYear).thenComparing(GameNumber::getNumber);
    public static final GameNumber UNKNOWN = new GameNumber(Year.of(1970), 0);
    @JsonAdapter(value=YearJsonAdapter.class)
    private final Year year;
    private final int number;

    public static GameNumber fromString(String input) {
        String[] sections = input.split("/");
        if (sections.length != 2) {
            throw new IllegalArgumentException("\"" + input + "\" is not a valid game number format");
        }
        return new GameNumber(Year.from(YEAR_FORMAT.parse(sections[0])), Integer.parseInt(sections[1]));
    }

    public GameNumber(Year year, int number) {
        this.year = year;
        this.number = number;
    }

    public Year getYear() {
        return this.year;
    }

    public int getNumber() {
        return this.number;
    }

    public String toString() {
        return YEAR_FORMAT.format(this.year) + "/" + NUMBER_FORMAT.format(this.number);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GameNumber that = (GameNumber)o;
        return this.number == that.number && Objects.equals(this.year, that.year);
    }

    public int hashCode() {
        return Objects.hash(this.year, this.number);
    }

    @Override
    public int compareTo(GameNumber o) {
        return COMPARATOR.compare(this, o);
    }

    public static class YearJsonAdapter
    extends TypeAdapter<Year> {
        @Override
        public void write(JsonWriter out, Year year) throws IOException {
            out.value(year.getValue());
        }

        @Override
        public Year read(JsonReader in) throws IOException {
            return Year.of((int)in.nextLong());
        }
    }
}

