/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game.objects;

import com.loohp.lotterysix.game.LotterySix;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public enum PlayerPreferenceKey {
    HIDE_TITLES(Boolean.TYPE, (i, p) -> false, () -> Arrays.asList("true", "false"), s -> Boolean.parseBoolean(s), false),
    HIDE_PERIODIC_ANNOUNCEMENTS(Boolean.TYPE, (i, p) -> false, () -> Arrays.asList("true", "false"), s -> Boolean.parseBoolean(s), false),
    REOPEN_MENU_ON_PURCHASE(Boolean.TYPE, (i, p) -> true, () -> Arrays.asList("true", "false"), s -> Boolean.parseBoolean(s), false),
    BET_LIMIT_PER_ROUND(Long.TYPE, (i, p) -> i == null || p == null ? Long.MAX_VALUE : i.getPlayerBetLimit((UUID)p), () -> Arrays.asList("0", "100", "1000", "100000", "10000000"), s -> Long.parseLong(s), true),
    SUSPEND_ACCOUNT_UNTIL(Long.TYPE, (i, p) -> 0L, () -> Arrays.asList("0", Long.toString(System.currentTimeMillis() + 604800000L)), s -> Long.parseLong(s), false);

    private final Class<?> valueTypeClass;
    private final BiFunction<LotterySix, UUID, ?> defaultValue;
    private final Supplier<List<String>> suggestedValues;
    private final Function<String, ?> reader;
    private final boolean isMonetaryValue;

    private <T> PlayerPreferenceKey(Class<T> valueTypeClass, BiFunction<LotterySix, UUID, T> defaultValue, Supplier<List<String>> suggestedValues, Function<String, T> reader, boolean isMonetaryValue) {
        this.valueTypeClass = valueTypeClass;
        this.defaultValue = defaultValue;
        this.suggestedValues = suggestedValues;
        this.reader = reader;
        this.isMonetaryValue = isMonetaryValue;
    }

    public static PlayerPreferenceKey fromKey(String key) {
        for (PlayerPreferenceKey preferenceKey : PlayerPreferenceKey.values()) {
            if (!key.equalsIgnoreCase(preferenceKey.name())) continue;
            return preferenceKey;
        }
        return null;
    }

    public Class<?> getValueTypeClass() {
        return this.valueTypeClass;
    }

    public Object getDefaultValue(LotterySix instance, UUID player) {
        return this.defaultValue.apply(instance, player);
    }

    public List<String> getSuggestedValues() {
        return this.suggestedValues.get();
    }

    public Object getReader(String input) {
        return this.reader.apply(input);
    }

    public boolean isMonetaryValue() {
        return this.isMonetaryValue;
    }
}

