/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game.objects;

import com.loohp.lotterysix.game.objects.PrizeTier;

public enum PlayerStatsKey {
    TOTAL_BETS_PLACED(Long.TYPE, 0L, true),
    TOTAL_ROUNDS_PARTICIPATED(Long.TYPE, 0L, false),
    TOTAL_WINNINGS(Long.TYPE, 0L, true),
    HIGHEST_WON_TIER(PrizeTier.class, null, false),
    PENDING_TRANSACTION(Long.TYPE, 0L, true),
    NOTIFY_BALANCE_CHANGE(Long.TYPE, 0L, false),
    ACCOUNT_BALANCE(Long.TYPE, 0L, true);

    private final Class<?> valueTypeClass;
    private final Object defaultValue;
    private final boolean isMonetaryValue;

    private <T> PlayerStatsKey(Class<T> valueTypeClass, T defaultValue, boolean isMonetaryValue) {
        this.valueTypeClass = valueTypeClass;
        this.defaultValue = defaultValue;
        this.isMonetaryValue = isMonetaryValue;
    }

    public static PlayerStatsKey fromKey(String key) {
        for (PlayerStatsKey statsKey : PlayerStatsKey.values()) {
            if (!key.equalsIgnoreCase(statsKey.name())) continue;
            return statsKey;
        }
        return null;
    }

    public Class<?> getValueTypeClass() {
        return this.valueTypeClass;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isMonetaryValue() {
        return this.isMonetaryValue;
    }
}

