/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game.objects;

import com.loohp.lotterysix.game.objects.FormattedString;
import com.loohp.lotterysix.game.objects.Pair;
import com.loohp.lotterysix.game.objects.PrizeTier;
import com.loohp.lotterysix.game.objects.WinningCombination;
import com.loohp.lotterysix.game.objects.betnumbers.BetNumbers;
import com.loohp.lotterysix.utils.ChatColorUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class WinningNumbers
implements FormattedString {
    private final List<Integer> numbers;
    private final int specialNumber;

    public static Pattern buildStringPattern() {
        StringBuilder sb = new StringBuilder("^");
        for (int i = 0; i < 6; ++i) {
            sb.append("([0-9]+) ");
        }
        return Pattern.compile(sb.append("\\+ ([0-9]+)$").toString());
    }

    public static WinningNumbers fromString(String input) {
        Matcher matcher = WinningNumbers.buildStringPattern().matcher(input);
        if (!matcher.find()) {
            return null;
        }
        LinkedHashSet<Integer> numbers = new LinkedHashSet<Integer>();
        for (int i = 1; i <= 6; ++i) {
            try {
                if (numbers.add(Integer.parseInt(matcher.group(i)))) continue;
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        try {
            int specialNumber = Integer.parseInt(matcher.group(7));
            if (numbers.contains(specialNumber)) {
                return null;
            }
            return new WinningNumbers(numbers, specialNumber);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public WinningNumbers(Collection<Integer> numbers, int specialNumber) {
        this.numbers = Collections.unmodifiableList(new ArrayList<Integer>(numbers));
        this.specialNumber = specialNumber;
    }

    public List<Integer> getNumbers() {
        return this.numbers;
    }

    public List<Integer> getNumbersOrdered() {
        return Collections.unmodifiableList(this.numbers.stream().sorted().collect(Collectors.toList()));
    }

    public boolean containsAnywhere(int number) {
        return this.numbers.contains(number) || this.specialNumber == number;
    }

    public int getNumber(int index) {
        return index < this.numbers.size() ? this.numbers.get(index) : -1;
    }

    public int getNumberOrdered(int index) {
        List<Integer> ordered = this.getNumbersOrdered();
        return index < ordered.size() ? ordered.get(index) : -1;
    }

    public int getSpecialNumber() {
        return this.specialNumber;
    }

    public Stream<Pair<PrizeTier, WinningCombination>> checkWinning(BetNumbers betNumbers) {
        PrizeTier[] prizeTiers = PrizeTier.values();
        return betNumbers.combinations().map(numbers -> {
            int matches = (int)numbers.stream().filter(i -> this.numbers.contains(i)).limit(6L).count();
            boolean matchSpecial = numbers.contains(this.specialNumber);
            for (PrizeTier prizeTier : prizeTiers) {
                if (!prizeTier.getWinningCriteria().satisfies(matches, matchSpecial)) continue;
                return Pair.of(prizeTier, new WinningCombination((Collection<Integer>)numbers));
            }
            return null;
        }).filter(each -> each != null);
    }

    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private final Iterator<Integer> itr;
            {
                this.itr = WinningNumbers.this.numbers.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public Integer next() {
                return this.itr.next();
            }
        };
    }

    public IntStream stream() {
        return this.numbers.stream().mapToInt(i -> i);
    }

    public Iterator<Integer> orderedIterator() {
        return new Iterator<Integer>(){
            private final Iterator<Integer> itr;
            {
                this.itr = WinningNumbers.this.getNumbersOrdered().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public Integer next() {
                return this.itr.next();
            }
        };
    }

    public String toString() {
        return this.numbers.stream().sorted().map(each -> each.toString()).collect(Collectors.joining(" ")) + " + " + this.specialNumber;
    }

    @Override
    public String toFormattedString() {
        String numbersString = this.numbers.stream().sorted().map(each -> ChatColorUtils.getNumberColor(each) + each.toString()).collect(Collectors.joining(" "));
        return numbersString + " \u00a76+ " + ChatColorUtils.getNumberColor(this.specialNumber) + this.specialNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WinningNumbers integers = (WinningNumbers)o;
        return this.specialNumber == integers.specialNumber && this.numbers.equals(integers.numbers);
    }

    public int hashCode() {
        return Objects.hash(this.numbers, this.specialNumber);
    }
}

