/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game.objects.betnumbers;

import com.loohp.lotterysix.game.objects.FormattedString;
import com.loohp.lotterysix.game.objects.betnumbers.BetNumbersType;
import com.loohp.lotterysix.libs.org.paukov.combinatorics3.Generator;
import com.loohp.lotterysix.utils.ChatColorUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BetNumbers
implements FormattedString {
    private final Set<Integer> bankers;
    private final Set<Integer> numbers;
    private final List<Set<Integer>> additionalSets;
    private final BetNumbersType type;

    BetNumbers(Collection<Integer> numbers, BetNumbersType type) {
        if (type.isBanker()) {
            throw new IllegalArgumentException("type cannot be banker");
        }
        this.bankers = null;
        this.numbers = Collections.unmodifiableSet(new TreeSet<Integer>(numbers));
        this.additionalSets = null;
        this.type = type;
    }

    BetNumbers(Collection<Integer> bankers, Collection<Integer> numbers, BetNumbersType type) {
        if (!type.isBanker()) {
            throw new IllegalArgumentException("type must be banker");
        }
        this.bankers = Collections.unmodifiableSet(new TreeSet<Integer>(bankers));
        this.numbers = Collections.unmodifiableSet(new TreeSet<Integer>(numbers));
        this.additionalSets = null;
        this.type = type;
    }

    BetNumbers(List<Collection<Integer>> numbers, BetNumbersType type) {
        if (type.isMultipleCombination()) {
            throw new IllegalArgumentException("type must not be multiple combinations");
        }
        if (numbers.isEmpty()) {
            throw new IllegalArgumentException("numbers cannot be empty");
        }
        this.bankers = null;
        this.numbers = Collections.unmodifiableSet(new TreeSet<Integer>(numbers.get(0)));
        this.additionalSets = numbers.size() == 1 ? null : Collections.unmodifiableList(numbers.stream().skip(1L).map(each -> Collections.unmodifiableSet(new TreeSet(each))).collect(Collectors.toList()));
        this.type = type;
    }

    public Iterator<Integer> iterator() {
        return this.numbers.stream().iterator();
    }

    public Stream<List<Integer>> combinations() {
        Stream<List<Integer>> stream = this.hasNoBankers() ? Generator.combination(this.numbers).simple(6).stream() : Generator.combination(this.numbers).simple(6 - this.bankers.size()).stream().peek(list -> list.addAll(this.bankers));
        if (this.hasNoAdditionalSets()) {
            return stream;
        }
        return Stream.concat(stream, this.additionalSets.stream().map(each -> new ArrayList(each)));
    }

    public Set<Integer> getNumbers() {
        return this.numbers;
    }

    public int getNumber(int index) {
        Iterator<Integer> itr = this.iterator();
        int value = itr.next();
        for (int i = 0; i < index; ++i) {
            value = itr.next();
        }
        return value;
    }

    public boolean hasBankers() {
        return !this.hasNoBankers();
    }

    public boolean hasNoBankers() {
        return this.bankers == null || this.bankers.isEmpty();
    }

    public Iterator<Integer> bankersIterator() {
        if (this.hasNoBankers()) {
            return Collections.emptyIterator();
        }
        return this.bankers.stream().iterator();
    }

    public Set<Integer> getBankersNumbers() {
        return this.hasNoBankers() ? Collections.emptySet() : this.bankers;
    }

    public int getBankerNumber(int index) {
        Iterator<Integer> itr = this.bankersIterator();
        int value = itr.next();
        for (int i = 0; i < index; ++i) {
            value = itr.next();
        }
        return value;
    }

    public boolean hasAdditionalSets() {
        return this.additionalSets != null && !this.additionalSets.isEmpty();
    }

    public boolean hasNoAdditionalSets() {
        return this.additionalSets == null || this.additionalSets.isEmpty();
    }

    public Iterator<Set<Integer>> additionalSetsIterator() {
        if (this.hasNoAdditionalSets()) {
            return Collections.emptyIterator();
        }
        return this.additionalSets.stream().map(each -> Collections.unmodifiableSet(each)).iterator();
    }

    public List<Set<Integer>> getAdditionalSets() {
        if (this.hasNoAdditionalSets()) {
            return Collections.emptyList();
        }
        return this.additionalSets.stream().map(each -> Collections.unmodifiableSet(each)).collect(Collectors.toList());
    }

    public int getSetsSize() {
        if (this.hasNoAdditionalSets()) {
            return 1;
        }
        return this.additionalSets.size() + 1;
    }

    public List<Integer> getAllNumbers() {
        ArrayList<Integer> combined = new ArrayList<Integer>(this.numbers);
        if (this.hasBankers()) {
            combined.addAll(this.bankers);
        }
        if (this.hasAdditionalSets()) {
            for (Set<Integer> additional : this.additionalSets) {
                combined.addAll(additional);
            }
        }
        return combined;
    }

    public int setsIndexOf(Set<Integer> numberSet) {
        if (this.numbers.equals(numberSet)) {
            return 0;
        }
        if (this.hasNoAdditionalSets()) {
            return -1;
        }
        return this.additionalSets.indexOf(numberSet);
    }

    public Set<Integer> getSet(int index) {
        if (index == 0) {
            return this.numbers;
        }
        if (this.hasNoAdditionalSets()) {
            return null;
        }
        return this.additionalSets.get(index - 1);
    }

    public BetNumbersType getType() {
        return this.type;
    }

    public boolean isCombination() {
        return this.type.isMultipleCombination();
    }

    public boolean isBulk() {
        return this.getSetsSize() > 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BetNumbers that = (BetNumbers)o;
        return Objects.equals(this.bankers, that.bankers) && this.numbers.equals(that.numbers) && Objects.equals(this.additionalSets, that.additionalSets) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bankers, this.numbers, this.additionalSets, this.type});
    }

    public String toString() {
        String numbersString = this.numbers.stream().map(each -> each.toString()).collect(Collectors.joining(" "));
        if (this.hasBankers()) {
            numbersString = this.bankers.stream().map(each -> each.toString()).collect(Collectors.joining(" ")) + " > " + numbersString;
        }
        if (this.hasNoAdditionalSets()) {
            return numbersString;
        }
        return numbersString + " / " + this.additionalSets.stream().map(each -> each.stream().map(e -> e.toString()).collect(Collectors.joining(" "))).collect(Collectors.joining(" / "));
    }

    @Override
    public String toFormattedString() {
        String numbersString = this.numbers.stream().map(each -> ChatColorUtils.getNumberColor(each) + each.toString()).collect(Collectors.joining(" "));
        if (this.hasBankers()) {
            numbersString = this.bankers.stream().map(each -> ChatColorUtils.getNumberColor(each) + each.toString()).collect(Collectors.joining(" ")) + " \u00a75> " + numbersString;
        }
        if (this.hasNoAdditionalSets()) {
            return numbersString;
        }
        return numbersString + " \u00a75/ " + this.additionalSets.stream().map(each -> each.stream().map(e -> ChatColorUtils.getNumberColor(e) + e.toString()).collect(Collectors.joining(" "))).collect(Collectors.joining(" \u00a75/ "));
    }
}

