/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.game.player;

import com.loohp.lotterysix.game.objects.PlayerBets;
import com.loohp.lotterysix.game.objects.PlayerPreferenceKey;
import com.loohp.lotterysix.game.objects.PlayerStatsKey;
import com.loohp.lotterysix.game.player.LotteryPlayerManager;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class LotteryPlayer {
    private transient LotteryPlayerManager manager;
    private final UUID player;
    private final ConcurrentHashMap<PlayerPreferenceKey, Object> preferences;
    private final ConcurrentHashMap<PlayerStatsKey, Object> stats;
    private final CopyOnWriteArrayList<PlayerBets> multipleDrawPlayerBets;

    public LotteryPlayer(LotteryPlayerManager manager, UUID player) {
        this.manager = manager;
        this.player = player;
        this.preferences = new ConcurrentHashMap();
        this.stats = new ConcurrentHashMap();
        this.multipleDrawPlayerBets = new CopyOnWriteArrayList();
    }

    public LotteryPlayer(LotteryPlayerManager manager, UUID player, Map<PlayerPreferenceKey, Object> preferences, Map<PlayerStatsKey, Object> stats, List<PlayerBets> multipleDrawPlayerBets) {
        this.manager = manager;
        this.player = player;
        this.preferences = new ConcurrentHashMap<PlayerPreferenceKey, Object>(preferences);
        this.stats = new ConcurrentHashMap<PlayerStatsKey, Object>(stats);
        this.multipleDrawPlayerBets = new CopyOnWriteArrayList<PlayerBets>(multipleDrawPlayerBets);
    }

    public LotteryPlayerManager getManager() {
        return this.manager;
    }

    public void setManager(LotteryPlayerManager manager) {
        this.manager = manager;
    }

    public void save() {
        if (!this.manager.getInstance().backendBungeecordMode) {
            this.manager.getInstance().getLotteryPlayerUpdateListener().accept(this);
        }
        new Thread(() -> this.manager.saveLotteryPlayer(this.player), "LotteryPlayer Save Thread - " + this.player).start();
    }

    public UUID getPlayer() {
        return this.player;
    }

    public void bulkSet(Map<PlayerPreferenceKey, Object> preferences, Map<PlayerStatsKey, Object> stats, List<PlayerBets> multipleDrawPlayerBets) {
        for (PlayerPreferenceKey playerPreferenceKey : PlayerPreferenceKey.values()) {
            this.preferences.compute(playerPreferenceKey, (k, v) -> preferences.get((Object)playerPreferenceKey));
        }
        for (Enum enum_ : PlayerStatsKey.values()) {
            this.stats.compute((PlayerStatsKey)enum_, (arg_0, arg_1) -> LotteryPlayer.lambda$bulkSet$2(stats, (PlayerStatsKey)enum_, arg_0, arg_1));
        }
        this.multipleDrawPlayerBets.clear();
        this.multipleDrawPlayerBets.addAll(multipleDrawPlayerBets);
        this.save();
    }

    public Object getPreference(PlayerPreferenceKey key) {
        return this.preferences.getOrDefault((Object)key, key.getDefaultValue(this.manager.getInstance(), this.player));
    }

    public <T> T getPreference(PlayerPreferenceKey key, Class<T> type) {
        return (T)this.getPreference(key);
    }

    public void setPreference(PlayerPreferenceKey key, Object value) {
        this.preferences.put(key, value);
        this.save();
    }

    public boolean isPreferenceSet(PlayerPreferenceKey key) {
        return this.preferences.containsKey((Object)key);
    }

    public void resetPreference(PlayerPreferenceKey key) {
        this.preferences.remove((Object)key);
        this.save();
    }

    public Object getStats(PlayerStatsKey key) {
        return this.stats.getOrDefault((Object)key, key.getDefaultValue());
    }

    public <T> T getStats(PlayerStatsKey key, Class<T> type) {
        return (T)this.getStats(key);
    }

    public void setStats(PlayerStatsKey key, Object value) {
        this.stats.put(key, value);
        this.save();
    }

    public <T> T updateStats(PlayerStatsKey key, Class<T> type, Predicate<T> predicate, T newValue) {
        return this.updateStats(key, type, t -> predicate.test(t) ? newValue : t);
    }

    public <T> T updateStats(PlayerStatsKey key, Class<T> type, Predicate<T> predicate, T newValue, boolean save) {
        return this.updateStats(key, type, t -> predicate.test(t) ? newValue : t, save);
    }

    public <T> T updateStats(PlayerStatsKey key, Class<T> type, UnaryOperator<T> updateFunction) {
        return this.updateStats(key, type, updateFunction, true);
    }

    public <T> T updateStats(PlayerStatsKey key, Class<T> type, UnaryOperator<T> updateFunction, boolean save) {
        Object t;
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        Object defaultValue = key.getDefaultValue();
        this.stats.compute(key, (k, v) -> {
            Object t = v;
            ref.set(t);
            return updateFunction.apply(v == null ? defaultValue : t);
        });
        if (save) {
            this.save();
        }
        return (T)((t = ref.get()) == null ? defaultValue : t);
    }

    public List<PlayerBets> getMultipleDrawPlayerBets() {
        return this.multipleDrawPlayerBets;
    }

    public void setMultipleDrawPlayerBets(List<PlayerBets> bets) {
        this.setMultipleDrawPlayerBets(bets, true);
    }

    public void setMultipleDrawPlayerBets(List<PlayerBets> bets, boolean save) {
        this.multipleDrawPlayerBets.clear();
        this.multipleDrawPlayerBets.addAll(bets);
        if (save) {
            this.save();
        }
    }

    private static /* synthetic */ Object lambda$bulkSet$2(Map stats, PlayerStatsKey key, PlayerStatsKey k, Object v) {
        return stats.get((Object)key);
    }
}

