/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.libs.com.cryptomorin.xseries;

import com.google.common.base.Enums;
import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import com.loohp.lotterysix.libs.com.cryptomorin.xseries.XAttribute;
import com.loohp.lotterysix.libs.com.cryptomorin.xseries.XEnchantment;
import com.loohp.lotterysix.libs.com.cryptomorin.xseries.XItemFlag;
import com.loohp.lotterysix.libs.com.cryptomorin.xseries.XMaterial;
import com.loohp.lotterysix.libs.com.cryptomorin.xseries.XPatternType;
import com.loohp.lotterysix.libs.com.cryptomorin.xseries.XPotion;
import com.loohp.lotterysix.libs.com.cryptomorin.xseries.XTag;
import com.loohp.lotterysix.libs.com.cryptomorin.xseries.profiles.builder.XSkull;
import com.loohp.lotterysix.libs.com.cryptomorin.xseries.profiles.objects.Profileable;
import com.loohp.lotterysix.libs.com.cryptomorin.xseries.reflection.XReflection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.AxolotlBucketMeta;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.SpawnEggMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.map.MapView;
import org.bukkit.material.MaterialData;
import org.bukkit.material.SpawnEgg;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class XItemStack {
    private static final XMaterial DEFAULT_MATERIAL = XMaterial.BARRIER;
    private static final boolean SUPPORTS_UNBREAKABLE;
    private static final boolean SUPPORTS_POTION_COLOR;
    private static final boolean SUPPORTS_Inventory_getStorageContents;
    private static final boolean SUPPORTS_CUSTOM_MODEL_DATA;
    private static final boolean SUPPORTS_ADVANCED_CUSTOM_MODEL_DATA;
    private static final boolean SUPPORTS_ITEM_MODEL;
    private static final Map<Class<? extends ItemMeta>, Optional<Function<Deserializer, MetaHandler<ItemMeta>>>> DESERIALIZE_META_HANDLERS;
    private static final Map<Class<? extends ItemMeta>, Optional<Function<Serializer, MetaHandler<ItemMeta>>>> SERIALIZE_META_HANDLERS;

    private static <M extends ItemMeta> void meta(Class<? extends M> clazz, Function<Deserializer, MetaHandler<M>> deserialize, Function<Serializer, MetaHandler<M>> serialize) {
        DESERIALIZE_META_HANDLERS.put(clazz, Optional.of((Function)XItemStack.cast(deserialize)));
        SERIALIZE_META_HANDLERS.put(clazz, Optional.of((Function)XItemStack.cast(serialize)));
    }

    private static void onlyIf(String className, Runnable runnable) {
        try {
            Class.forName("org.bukkit.inventory.meta." + className);
            runnable.run();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static <T extends SerialObject> void recursiveMetaHandle(T serialObject, Class<?> metaClass, ItemMeta meta, Map<Class<? extends ItemMeta>, Optional<Function<T, MetaHandler<ItemMeta>>>> map, List<Function<T, MetaHandler<ItemMeta>>> collectedHandlers) {
        Optional<Function<T, MetaHandler<ItemMeta>>> handler = map.get(metaClass);
        if (handler != null) {
            if (handler.isPresent()) {
                if (collectedHandlers != null) {
                    collectedHandlers.add(handler.get());
                }
                handler.get().apply(serialObject).handle(meta);
            }
            return;
        }
        ArrayList subCollectedHandlers = new ArrayList();
        Class<?> superclass = metaClass.getSuperclass();
        if (superclass != null) {
            XItemStack.recursiveMetaHandle(serialObject, superclass, meta, map, subCollectedHandlers);
        }
        for (Class<?> anInterface : metaClass.getInterfaces()) {
            XItemStack.recursiveMetaHandle(serialObject, anInterface, meta, map, subCollectedHandlers);
        }
        if (subCollectedHandlers.isEmpty()) {
            map.put(metaClass, Optional.empty());
        } else {
            map.put(metaClass, Optional.of(inst -> subMeta -> {
                SerialObject castedInst = (SerialObject)XItemStack.cast(inst);
                for (Function subCollectedHandler : subCollectedHandlers) {
                    ((MetaHandler)subCollectedHandler.apply(castedInst)).handle(subMeta);
                }
            }));
            if (collectedHandlers != null) {
                collectedHandlers.addAll(subCollectedHandlers);
            }
        }
    }

    private static <T> T cast(Object something) {
        return (T)something;
    }

    private XItemStack() {
    }

    private static BlockState safeBlockState(BlockStateMeta meta) {
        try {
            return meta.getBlockState();
        }
        catch (IllegalStateException ex) {
            if (ex.getMessage().toLowerCase(Locale.ENGLISH).contains("missing blockstate")) {
                return null;
            }
            throw ex;
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    public static void serialize(@NotNull ItemStack item, @NotNull ConfigurationSection config) {
        XItemStack.serialize(item, config, Function.identity());
    }

    public static void serialize(@NotNull ItemStack item, @NotNull ConfigurationSection config, @NotNull Function<String, String> translator) {
        new Serializer(item, config, translator).handle();
    }

    public static Map<String, Object> serialize(@NotNull ItemStack item) {
        Objects.requireNonNull(item, "Cannot serialize a null item");
        MemoryConfiguration config = new MemoryConfiguration();
        XItemStack.serialize(item, (ConfigurationSection)config);
        return XItemStack.configSectionToMap((ConfigurationSection)config);
    }

    @NotNull
    public static ItemStack deserialize(@NotNull ConfigurationSection config) {
        return XItemStack.edit(DEFAULT_MATERIAL.parseItem(), config, Function.identity(), null);
    }

    @NotNull
    public static ItemStack deserialize(@NotNull Map<String, Object> serializedItem) {
        Objects.requireNonNull(serializedItem, "serializedItem cannot be null.");
        return XItemStack.deserialize(XItemStack.mapToConfigSection(serializedItem));
    }

    @NotNull
    public static ItemStack deserialize(@NotNull ConfigurationSection config, @NotNull Function<String, String> translator) {
        return XItemStack.deserialize(config, translator, null);
    }

    @NotNull
    public static ItemStack deserialize(@NotNull ConfigurationSection config, @NotNull Function<String, String> translator, @Nullable Consumer<Exception> restart) {
        return XItemStack.edit(DEFAULT_MATERIAL.parseItem(), config, translator, restart);
    }

    @NotNull
    public static ItemStack deserialize(@NotNull Map<String, Object> serializedItem, @NotNull Function<String, String> translator) {
        Objects.requireNonNull(serializedItem, "serializedItem cannot be null.");
        Objects.requireNonNull(translator, "translator cannot be null.");
        return XItemStack.deserialize(XItemStack.mapToConfigSection(serializedItem), translator);
    }

    private static int toInt(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    private static List<String> split(@NotNull String str, char separatorChar) {
        ArrayList<String> list = new ArrayList<String>(5);
        boolean match = false;
        boolean lastMatch = false;
        int len = str.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = i + 1;
                continue;
            }
            lastMatch = false;
            match = true;
        }
        if (match || lastMatch) {
            list.add(str.substring(start, len));
        }
        return list;
    }

    private static List<String> splitNewLine(String str) {
        int len = str.length();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str.charAt(i) == '\n') {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || lastMatch) {
            list.add(str.substring(start, i));
        }
        return list;
    }

    @NotNull
    public static ItemStack edit(@NotNull ItemStack item, @NotNull ConfigurationSection config, @NotNull Function<String, String> translator, @Nullable Consumer<Exception> restart) {
        return new Deserializer(item, config, translator, restart).parse();
    }

    @NotNull
    private static ConfigurationSection mapToConfigSection(@NotNull Map<?, ?> map) {
        MemoryConfiguration config = new MemoryConfiguration();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Map) {
                value = XItemStack.mapToConfigSection((Map)value);
            }
            config.set(key, value);
        }
        return config;
    }

    @NotNull
    private static Map<String, Object> configSectionToMap(@NotNull ConfigurationSection config) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String key : config.getKeys(false)) {
            Map<String, Object> value = config.get(key);
            if (value == null) continue;
            if (value instanceof ConfigurationSection) {
                value = XItemStack.configSectionToMap((ConfigurationSection)value);
            }
            map.put(key, value);
        }
        return map;
    }

    @NotNull
    @ApiStatus.Internal
    public static Optional<Color> parseColor(@Nullable String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return Optional.empty();
        }
        List<String> rgb = XItemStack.split(str.replace(" ", ""), ',');
        if (rgb.size() == 3) {
            return Optional.of(Color.fromRGB((int)XItemStack.toInt(rgb.get(0), 0), (int)XItemStack.toInt(rgb.get(1), 0), (int)XItemStack.toInt(rgb.get(2), 0)));
        }
        try {
            return Optional.of(Color.fromRGB((int)Integer.parseInt(str)));
        }
        catch (NumberFormatException numberFormatException) {
            if (str.startsWith("#")) {
                str = str.substring(1);
            }
            try {
                return Optional.of(Color.fromRGB((int)Integer.parseInt(str, 16)));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
    }

    private static <T> List<T> parseRawOrList(String singular, String plural, ConfigurationSection section, Function<String, T> convert) {
        List list = section.getStringList(plural);
        if (!list.isEmpty()) {
            return list.stream().map(convert).collect(Collectors.toList());
        }
        list = section.getStringList(singular);
        if (!list.isEmpty()) {
            return list.stream().map(convert).collect(Collectors.toList());
        }
        String single = section.getString(singular);
        if (single != null && !single.isEmpty()) {
            return Collections.singletonList(convert.apply(single));
        }
        single = section.getString(plural);
        if (single != null && !single.isEmpty()) {
            return Collections.singletonList(convert.apply(single));
        }
        return Collections.emptyList();
    }

    private static <T> T tryNumber(String str, Function<String, T> convert) {
        try {
            return convert.apply(str);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @NotNull
    @Contract(mutates="param1")
    public static List<ItemStack> giveOrDrop(@NotNull Player player, ItemStack ... items) {
        return XItemStack.giveOrDrop(player, true, items);
    }

    @NotNull
    @Contract(mutates="param1")
    public static List<ItemStack> giveOrDrop(@NotNull Player player, boolean split, ItemStack ... items) {
        if (items == null || items.length == 0) {
            return new ArrayList<ItemStack>();
        }
        List<ItemStack> leftOvers = XItemStack.addItems((Inventory)player.getInventory(), split, items);
        World world = player.getWorld();
        Location location = player.getLocation();
        for (ItemStack drop : leftOvers) {
            world.dropItemNaturally(location, drop);
        }
        return leftOvers;
    }

    @Contract(mutates="param1")
    public static List<ItemStack> addItems(@NotNull Inventory inventory, boolean split, ItemStack ... items) {
        return XItemStack.addItems(inventory, split, null, items);
    }

    @NotNull
    @Contract(mutates="param1")
    public static List<ItemStack> addItems(@NotNull Inventory inventory, boolean split, @Nullable Predicate<Integer> modifiableSlots, ItemStack ... items) {
        Objects.requireNonNull(inventory, "Cannot add items to null inventory");
        Objects.requireNonNull(items, "Cannot add null items to inventory");
        ArrayList<ItemStack> leftOvers = new ArrayList<ItemStack>(items.length);
        int invSize = XItemStack.getStorageContents(inventory).length;
        int lastEmpty = 0;
        block0: for (ItemStack item : items) {
            int lastPartial = 0;
            int maxAmount = split ? item.getMaxStackSize() : inventory.getMaxStackSize();
            while (true) {
                int firstPartial;
                int n = firstPartial = lastPartial >= invSize ? -1 : XItemStack.firstPartial(inventory, item, lastPartial, modifiableSlots);
                if (firstPartial == -1) {
                    if (lastEmpty != -1) {
                        lastEmpty = XItemStack.firstEmpty(inventory, lastEmpty, modifiableSlots);
                    }
                    if (lastEmpty == -1) {
                        leftOvers.add(item);
                        continue block0;
                    }
                    lastPartial = Integer.MAX_VALUE;
                    int amount = item.getAmount();
                    if (amount <= maxAmount) {
                        inventory.setItem(lastEmpty, item);
                        continue block0;
                    }
                    ItemStack copy = item.clone();
                    copy.setAmount(maxAmount);
                    inventory.setItem(lastEmpty, copy);
                    item.setAmount(amount - maxAmount);
                    if (++lastEmpty != invSize) continue;
                    lastEmpty = -1;
                    continue;
                }
                ItemStack partialItem = inventory.getItem(firstPartial);
                int sum = item.getAmount() + partialItem.getAmount();
                if (sum <= maxAmount) {
                    partialItem.setAmount(sum);
                    inventory.setItem(firstPartial, partialItem);
                    continue block0;
                }
                partialItem.setAmount(maxAmount);
                inventory.setItem(firstPartial, partialItem);
                item.setAmount(sum - maxAmount);
                lastPartial = firstPartial + 1;
            }
        }
        return leftOvers;
    }

    @NotNull
    @Contract(pure=true)
    public static @Range(from=-1L, to=0x7FFFFFFFL) int firstPartial(@NotNull Inventory inventory, @Nullable ItemStack item, int beginIndex) {
        return XItemStack.firstPartial(inventory, item, beginIndex, null);
    }

    @NotNull
    @Contract(pure=true)
    public static @Range(from=-1L, to=0x7FFFFFFFL) int firstPartial(@NotNull Inventory inventory, @Nullable ItemStack item, int beginIndex, @Nullable Predicate<Integer> modifiableSlots) {
        if (item != null) {
            ItemStack[] items = XItemStack.getStorageContents(inventory);
            int invSize = items.length;
            if (beginIndex < 0 || beginIndex >= invSize) {
                throw new IndexOutOfBoundsException("Begin Index: " + beginIndex + ", Inventory storage content size: " + invSize);
            }
            while (beginIndex < invSize) {
                ItemStack cItem;
                if ((modifiableSlots == null || modifiableSlots.test(beginIndex)) && (cItem = items[beginIndex]) != null && cItem.getAmount() < cItem.getMaxStackSize() && cItem.isSimilar(item)) {
                    return beginIndex;
                }
                ++beginIndex;
            }
        }
        return -1;
    }

    @NotNull
    @Contract(pure=true)
    public static List<ItemStack> stack(@NotNull Collection<ItemStack> items) {
        return XItemStack.stack(items, ItemStack::isSimilar);
    }

    @NotNull
    @Contract(pure=true)
    public static List<ItemStack> stack(@NotNull Collection<ItemStack> items, @NotNull BiPredicate<ItemStack, ItemStack> similarity) {
        Objects.requireNonNull(items, "Cannot stack null items");
        Objects.requireNonNull(similarity, "Similarity check cannot be null");
        ArrayList<ItemStack> stacked = new ArrayList<ItemStack>(items.size());
        for (ItemStack item : items) {
            if (item == null || item.getType() == Material.AIR) continue;
            boolean add = true;
            for (ItemStack stack : stacked) {
                if (!similarity.test(item, stack)) continue;
                stack.setAmount(stack.getAmount() + item.getAmount());
                add = false;
                break;
            }
            if (!add) continue;
            stacked.add(item.clone());
        }
        return stacked;
    }

    @Contract(pure=true)
    public static @Range(from=-1L, to=0x7FFFFFFFL) int firstEmpty(@NotNull Inventory inventory, int beginIndex) {
        return XItemStack.firstEmpty(inventory, beginIndex, null);
    }

    @Contract(pure=true)
    public static @Range(from=-1L, to=0x7FFFFFFFL) int firstEmpty(@NotNull Inventory inventory, int beginIndex, @Nullable Predicate<Integer> modifiableSlots) {
        ItemStack[] items = XItemStack.getStorageContents(inventory);
        int invSize = items.length;
        if (beginIndex < 0 || beginIndex >= invSize) {
            throw new IndexOutOfBoundsException("Begin Index: " + beginIndex + ", Inventory storage content size: " + invSize);
        }
        while (beginIndex < invSize) {
            if ((modifiableSlots == null || modifiableSlots.test(beginIndex)) && items[beginIndex] == null) {
                return beginIndex;
            }
            ++beginIndex;
        }
        return -1;
    }

    @Contract(pure=true)
    public static @Range(from=-1L, to=0x7FFFFFFFL) int firstPartialOrEmpty(@NotNull Inventory inventory, @Nullable ItemStack item, int beginIndex) {
        if (item != null) {
            ItemStack[] items = XItemStack.getStorageContents(inventory);
            int len = items.length;
            if (beginIndex < 0 || beginIndex >= len) {
                throw new IndexOutOfBoundsException("Begin Index: " + beginIndex + ", Size: " + len);
            }
            while (beginIndex < len) {
                ItemStack cItem = items[beginIndex];
                if (cItem == null || cItem.getAmount() < cItem.getMaxStackSize() && cItem.isSimilar(item)) {
                    return beginIndex;
                }
                ++beginIndex;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    public static ItemStack[] getStorageContents(Inventory inventory) {
        if (SUPPORTS_Inventory_getStorageContents) {
            return inventory.getStorageContents();
        }
        return Arrays.copyOfRange(inventory.getContents(), 0, 36);
    }

    @Contract(pure=true)
    public static boolean notEmpty(@Nullable ItemStack item) {
        return !XItemStack.isEmpty(item);
    }

    @Contract(pure=true)
    public static boolean isEmpty(@Nullable ItemStack item) {
        return item == null || item.getType() == Material.AIR;
    }

    static {
        boolean supportsPotionColor = false;
        boolean supportsUnbreakable = false;
        boolean supportsGetStorageContents = false;
        boolean supportSCustomModelData = false;
        boolean supportsAdvancedCustomModelData = false;
        boolean supportsItemModel = false;
        try {
            ItemMeta.class.getDeclaredMethod("setUnbreakable", Boolean.TYPE);
            supportsUnbreakable = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            ItemMeta.class.getDeclaredMethod("hasCustomModelData", new Class[0]);
            supportSCustomModelData = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            Class.forName("org.bukkit.inventory.meta.components.CustomModelDataComponent");
            supportsAdvancedCustomModelData = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            ItemMeta.class.getDeclaredMethod("getItemModel", new Class[0]);
            supportsItemModel = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            Class.forName("org.bukkit.inventory.meta.PotionMeta").getMethod("setColor", Color.class);
            supportsPotionColor = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Inventory.class.getDeclaredMethod("getStorageContents", new Class[0]);
            supportsGetStorageContents = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        SUPPORTS_POTION_COLOR = supportsPotionColor;
        SUPPORTS_UNBREAKABLE = supportsUnbreakable;
        SUPPORTS_Inventory_getStorageContents = supportsGetStorageContents;
        SUPPORTS_CUSTOM_MODEL_DATA = supportSCustomModelData;
        SUPPORTS_ADVANCED_CUSTOM_MODEL_DATA = supportsAdvancedCustomModelData;
        SUPPORTS_ITEM_MODEL = supportsItemModel;
        DESERIALIZE_META_HANDLERS = new IdentityHashMap<Class<? extends ItemMeta>, Optional<Function<Deserializer, MetaHandler<ItemMeta>>>>();
        SERIALIZE_META_HANDLERS = new IdentityHashMap<Class<? extends ItemMeta>, Optional<Function<Serializer, MetaHandler<ItemMeta>>>>();
        XItemStack.meta(SkullMeta.class, x -> x$0 -> ((Deserializer)x).handleSkullMeta(x$0), x -> x$0 -> ((Serializer)x).handleSkullMeta(x$0));
        XItemStack.meta(LeatherArmorMeta.class, x -> x$0 -> ((Deserializer)x).handleLeatherArmorMeta(x$0), x -> x$0 -> ((Serializer)x).handleLeatherArmorMeta(x$0));
        XItemStack.meta(PotionMeta.class, x -> x$0 -> ((Deserializer)x).handlePotionMeta(x$0), x -> x$0 -> ((Serializer)x).handlePotionMeta(x$0));
        XItemStack.meta(BlockStateMeta.class, x -> x$0 -> ((Deserializer)x).handleBlockStateMeta(x$0), x -> x$0 -> ((Serializer)x).handleBlockStateMeta(x$0));
        XItemStack.meta(FireworkMeta.class, x -> x$0 -> ((Deserializer)x).handleFireworkMeta(x$0), x -> x$0 -> ((Serializer)x).handleFireworkMeta(x$0));
        XItemStack.meta(BookMeta.class, x -> x$0 -> ((Deserializer)x).handleBookMeta(x$0), x -> x$0 -> ((Serializer)x).handleBookMeta(x$0));
        XItemStack.meta(BannerMeta.class, x -> x$0 -> ((Deserializer)x).handleBannerMeta(x$0), x -> x$0 -> ((Serializer)x).handleBannerMeta(x$0));
        XItemStack.meta(MapMeta.class, x -> x$0 -> ((Deserializer)x).handleMapMeta(x$0), x -> x$0 -> ((Serializer)x).handleMapMeta(x$0));
        XItemStack.meta(EnchantmentStorageMeta.class, x -> x$0 -> ((Deserializer)x).handleEnchantmentStorageMeta(x$0), x -> x$0 -> ((Serializer)x).handleEnchantmentStorageMeta(x$0));
        XItemStack.onlyIf("SpawnEggMeta", () -> XItemStack.meta(SpawnEggMeta.class, x -> x$0 -> ((Deserializer)x).handleSpawnEggMeta(x$0), x -> x$0 -> ((Serializer)x).handleSpawnEggMeta(x$0)));
        XItemStack.onlyIf("ArmorMeta", () -> XItemStack.meta(ArmorMeta.class, x -> x$0 -> ((Deserializer)x).handleArmorMeta(x$0), x -> x$0 -> ((Serializer)x).handleArmorMeta(x$0)));
        XItemStack.onlyIf("AxolotlBucketMeta", () -> XItemStack.meta(AxolotlBucketMeta.class, x -> x$0 -> ((Deserializer)x).handleAxolotlBucketMeta(x$0), x -> x$0 -> ((Serializer)x).handleAxolotlBucketMeta(x$0)));
        XItemStack.onlyIf("CompassMeta", () -> XItemStack.meta(CompassMeta.class, x -> x$0 -> ((Deserializer)x).handleCompassMeta(x$0), x -> x$0 -> ((Serializer)x).handleCompassMeta(x$0)));
        XItemStack.onlyIf("SuspiciousStewMeta", () -> XItemStack.meta(SuspiciousStewMeta.class, x -> x$0 -> ((Deserializer)x).handleSuspiciousStewMeta(x$0), x -> x$0 -> ((Serializer)x).handleSuspiciousStewMeta(x$0)));
        XItemStack.onlyIf("CrossbowMeta", () -> XItemStack.meta(CrossbowMeta.class, x -> x$0 -> ((Deserializer)x).handleCrossbowMeta(x$0), x -> x$0 -> ((Serializer)x).handleCrossbowMeta(x$0)));
        XItemStack.onlyIf("TropicalFishBucketMeta", () -> XItemStack.meta(TropicalFishBucketMeta.class, x -> x$0 -> ((Deserializer)x).handleTropicalFishBucketMeta(x$0), x -> x$0 -> ((Serializer)x).handleTropicalFishBucketMeta(x$0)));
    }

    private static abstract class SerialObject {
        @NotNull
        protected final ItemStack item;
        @NotNull
        protected final ConfigurationSection config;
        @NotNull
        protected final Function<String, String> translator;
        protected ItemMeta meta;

        private SerialObject(ItemStack item, @NotNull ConfigurationSection config, @NotNull Function<String, String> translator) {
            this.item = Objects.requireNonNull(item, "Cannot operate on null ItemStack, considering using an AIR ItemStack instead");
            this.config = Objects.requireNonNull(config, "Cannot deserialize item to a null configuration section.");
            this.translator = Objects.requireNonNull(translator, "Translator function cannot be null");
        }
    }

    private static interface MetaHandler<M extends ItemMeta> {
        public void handle(M var1);
    }

    private static final class Serializer
    extends SerialObject {
        private Serializer(ItemStack item, @NotNull ConfigurationSection config, @NotNull Function<String, String> translator) {
            super(item, config, translator);
        }

        public void handle() {
            this.config.set("material", (Object)XMaterial.matchXMaterial(this.item).name());
            if (this.item.getAmount() > 1) {
                this.config.set("amount", (Object)this.item.getAmount());
            }
            if (!this.item.hasItemMeta()) {
                return;
            }
            this.meta = this.item.getItemMeta();
            if (this.meta == null) {
                return;
            }
            this.handleDurability(this.meta);
            if (this.meta.hasDisplayName()) {
                this.config.set("name", this.translator.apply(this.meta.getDisplayName()));
            }
            if (this.meta.hasLore()) {
                this.config.set("lore", this.meta.getLore().stream().map(this.translator).collect(Collectors.toList()));
            }
            this.customModelData();
            if (SUPPORTS_UNBREAKABLE && this.meta.isUnbreakable()) {
                this.config.set("unbreakable", (Object)true);
            }
            this.handleEnchants();
            this.handleItemFlags(this.meta);
            this.handleAttributes(this.meta);
            this.legacySpawnEgg();
            XItemStack.recursiveMetaHandle(this, this.meta.getClass(), this.meta, SERIALIZE_META_HANDLERS, null);
        }

        private void customModelData() {
            String itemModel;
            if (SUPPORTS_ITEM_MODEL && (itemModel = this.config.getString("item-model")) != null && !itemModel.isEmpty()) {
                this.meta.setItemModel(NamespacedKey.fromString((String)itemModel));
            }
            if (SUPPORTS_CUSTOM_MODEL_DATA) {
                if (SUPPORTS_ADVANCED_CUSTOM_MODEL_DATA && this.meta.hasCustomModelDataComponent()) {
                    List colors;
                    List flags;
                    List floats;
                    CustomModelDataComponent customModelData = this.meta.getCustomModelDataComponent();
                    List strings = customModelData.getStrings();
                    int idCount = (int)Stream.of(strings, floats = customModelData.getFloats(), flags = customModelData.getFlags(), colors = customModelData.getColors()).filter(x -> !x.isEmpty()).count();
                    if (idCount == 0) {
                        return;
                    }
                    if (idCount == 1) {
                        if (!strings.isEmpty()) {
                            this.config.set("custom-model-data", Serializer.singleOrList(strings));
                        }
                        if (!floats.isEmpty()) {
                            this.config.set("custom-model-data", Serializer.singleOrList(floats));
                        }
                        if (!flags.isEmpty()) {
                            this.config.set("custom-model-data", Serializer.singleOrList(flags));
                        }
                        if (!colors.isEmpty()) {
                            this.config.set("custom-model-data", Serializer.singleOrList(colors.stream().map(Serializer::colorString).collect(Collectors.toList())));
                        }
                    } else {
                        ConfigurationSection cfgCustomModelData = this.config.createSection("custom-model-data");
                        if (!strings.isEmpty()) {
                            cfgCustomModelData.set("strings", (Object)strings);
                        }
                        if (!floats.isEmpty()) {
                            cfgCustomModelData.set("floats", (Object)floats);
                        }
                        if (!flags.isEmpty()) {
                            cfgCustomModelData.set("flags", (Object)flags);
                        }
                        if (!colors.isEmpty()) {
                            cfgCustomModelData.set("colors", colors.stream().map(Serializer::colorString).collect(Collectors.toList()));
                        }
                    }
                } else if (this.meta.hasCustomModelData()) {
                    this.config.set("custom-model-data", (Object)this.meta.getCustomModelData());
                }
            }
        }

        private static <T> Object singleOrList(List<T> list) {
            return list.size() == 1 ? list.get(0) : list;
        }

        private void legacySpawnEgg() {
            MaterialData data;
            if (!XMaterial.supports(11) && (data = this.item.getData()) instanceof SpawnEgg) {
                SpawnEgg spawnEgg = (SpawnEgg)data;
                this.config.set("creature", (Object)spawnEgg.getSpawnedType().getName());
            }
        }

        private void handleSpawnEggMeta(SpawnEggMeta spawnEgg) {
            this.config.set("creature", (Object)spawnEgg.getSpawnedType().getName());
        }

        private void handleSuspiciousStewMeta(SuspiciousStewMeta stew) {
            List customEffects = stew.getCustomEffects();
            ArrayList<String> effects = new ArrayList<String>(customEffects.size());
            for (PotionEffect effect : customEffects) {
                effects.add(XPotion.of(effect.getType()).name() + ", " + effect.getDuration() + ", " + effect.getAmplifier());
            }
            this.config.set("effects", effects);
        }

        private void handleTropicalFishBucketMeta(TropicalFishBucketMeta tropical) {
            this.config.set("pattern", (Object)tropical.getPattern().name());
            this.config.set("color", (Object)tropical.getBodyColor().name());
            this.config.set("pattern-color", (Object)tropical.getPatternColor().name());
        }

        private void handleCrossbowMeta(CrossbowMeta crossbow) {
            int i = 0;
            for (ItemStack projectiles : crossbow.getChargedProjectiles()) {
                XItemStack.serialize(projectiles, this.config.getConfigurationSection("projectiles." + i), this.translator);
                ++i;
            }
        }

        private void handleCompassMeta(CompassMeta compass) {
            ConfigurationSection subSection = this.config.createSection("lodestone");
            subSection.set("tracked", (Object)compass.isLodestoneTracked());
            if (compass.hasLodestone()) {
                Location location = compass.getLodestone();
                subSection.set("location.world", (Object)location.getWorld().getName());
                subSection.set("location.x", (Object)location.getX());
                subSection.set("location.y", (Object)location.getY());
                subSection.set("location.z", (Object)location.getZ());
            }
        }

        private void handleAxolotlBucketMeta(AxolotlBucketMeta bucket) {
            if (bucket.hasVariant()) {
                this.config.set("color", (Object)bucket.getVariant().toString());
            }
        }

        private void handleArmorMeta(ArmorMeta armorMeta) {
            if (armorMeta.hasTrim()) {
                ArmorTrim trim = armorMeta.getTrim();
                ConfigurationSection trimConfig = this.config.createSection("trim");
                trimConfig.set("material", (Object)(trim.getMaterial().getKey().getNamespace() + ':' + trim.getMaterial().getKey().getKey()));
                trimConfig.set("pattern", (Object)(trim.getPattern().getKey().getNamespace() + ':' + trim.getPattern().getKey().getKey()));
            }
        }

        private void handleMapMeta(MapMeta map) {
            ConfigurationSection mapSection = this.config.createSection("map");
            mapSection.set("scaling", (Object)map.isScaling());
            if (XMaterial.supports(11)) {
                if (map.hasLocationName()) {
                    mapSection.set("location", (Object)map.getLocationName());
                }
                if (map.hasColor()) {
                    Color color = map.getColor();
                    mapSection.set("color", (Object)Serializer.colorString(color));
                }
            }
            if (XMaterial.supports(14) && map.hasMapView()) {
                MapView mapView = map.getMapView();
                ConfigurationSection view = mapSection.createSection("view");
                view.set("scale", (Object)mapView.getScale().toString());
                view.set("world", (Object)mapView.getWorld().getName());
                ConfigurationSection centerSection = view.createSection("center");
                centerSection.set("x", (Object)mapView.getCenterX());
                centerSection.set("z", (Object)mapView.getCenterZ());
                view.set("locked", (Object)mapView.isLocked());
                view.set("tracking-position", (Object)mapView.isTrackingPosition());
                view.set("unlimited-tracking", (Object)mapView.isUnlimitedTracking());
            }
        }

        private void handleBookMeta(BookMeta book) {
            if (book.getTitle() != null || book.getAuthor() != null || book.getGeneration() != null || !book.getPages().isEmpty()) {
                BookMeta.Generation generation;
                ConfigurationSection bookInfo = this.config.createSection("book");
                if (book.getTitle() != null) {
                    bookInfo.set("title", (Object)book.getTitle());
                }
                if (book.getAuthor() != null) {
                    bookInfo.set("author", (Object)book.getAuthor());
                }
                if (XMaterial.supports(9) && (generation = book.getGeneration()) != null) {
                    bookInfo.set("generation", (Object)book.getGeneration().toString());
                }
                if (!book.getPages().isEmpty()) {
                    bookInfo.set("pages", (Object)book.getPages());
                }
            }
        }

        private void handleFireworkMeta(FireworkMeta firework) {
            this.config.set("power", (Object)firework.getPower());
            int i = 0;
            for (FireworkEffect fw : firework.getEffects()) {
                this.config.set("firework." + i + ".type", (Object)fw.getType().name());
                ConfigurationSection fwc = this.config.getConfigurationSection("firework." + i);
                fwc.set("flicker", (Object)fw.hasFlicker());
                fwc.set("trail", (Object)fw.hasTrail());
                List fwBaseColors = fw.getColors();
                List fwFadeColors = fw.getFadeColors();
                ArrayList<String> baseColors = new ArrayList<String>(fwBaseColors.size());
                ArrayList<String> fadeColors = new ArrayList<String>(fwFadeColors.size());
                ConfigurationSection colors = fwc.createSection("colors");
                for (Color color : fwBaseColors) {
                    baseColors.add(Serializer.colorString(color));
                }
                colors.set("base", baseColors);
                for (Color color : fwFadeColors) {
                    fadeColors.add(Serializer.colorString(color));
                }
                colors.set("fade", fadeColors);
                ++i;
            }
        }

        @NotNull
        private static String colorString(Color color) {
            return color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
        }

        private void handlePotionMeta(PotionMeta meta) {
            if (XMaterial.supports(9)) {
                List customEffects = meta.getCustomEffects();
                ArrayList<String> effects = new ArrayList<String>(customEffects.size());
                for (PotionEffect effect : customEffects) {
                    effects.add(effect.getType().getName() + ", " + effect.getDuration() + ", " + effect.getAmplifier());
                }
                if (!effects.isEmpty()) {
                    this.config.set("effects", effects);
                }
                PotionType basePotionType = meta.getBasePotionType();
                this.config.set("base-type", (Object)basePotionType.name());
                this.config.set("effects", meta.getCustomEffects().stream().map(x -> {
                    NamespacedKey type = x.getType().getKey();
                    String typeStr = type.getNamespace() + ':' + type.getKey();
                    return typeStr + ", " + x.getDuration() + ", " + x.getAmplifier();
                }).collect(Collectors.toList()));
                if (SUPPORTS_POTION_COLOR && meta.hasColor()) {
                    this.config.set("color", (Object)meta.getColor().asRGB());
                }
            }
        }

        private void handleLeatherArmorMeta(LeatherArmorMeta meta) {
            Color color = meta.getColor();
            this.config.set("color", (Object)Serializer.colorString(color));
        }

        private void handleBannerMeta(BannerMeta meta) {
            ConfigurationSection patterns = this.config.createSection("patterns");
            for (Pattern pattern : meta.getPatterns()) {
                patterns.set(XPatternType.of(pattern.getPattern()).name(), (Object)pattern.getColor().name());
            }
        }

        private void handleSkullMeta(ItemMeta meta) {
            String skull = XSkull.of(meta).getProfileValue();
            if (skull != null) {
                this.config.set("skull", (Object)skull);
            }
        }

        private void handleEnchantmentStorageMeta(EnchantmentStorageMeta meta) {
            for (Map.Entry enchant : meta.getStoredEnchants().entrySet()) {
                String entry = "stored-enchants." + XEnchantment.of((Enchantment)enchant.getKey()).name();
                this.config.set(entry, enchant.getValue());
            }
        }

        private void handleBlockStateMeta(BlockStateMeta meta) {
            CreatureSpawner cs;
            BlockState state = XItemStack.safeBlockState(meta);
            if (XMaterial.supports(11) && state instanceof ShulkerBox) {
                ShulkerBox box = (ShulkerBox)state;
                ConfigurationSection shulker = this.config.createSection("contents");
                int i = 0;
                for (ItemStack itemInBox : box.getInventory().getContents()) {
                    if (itemInBox != null) {
                        XItemStack.serialize(itemInBox, shulker.createSection(Integer.toString(i)), this.translator);
                    }
                    ++i;
                }
            } else if (state instanceof CreatureSpawner && (cs = (CreatureSpawner)state).getSpawnedType() != null) {
                this.config.set("spawner", (Object)cs.getSpawnedType().name());
            }
        }

        private void handleAttributes(ItemMeta meta) {
            Multimap attributes;
            if (XMaterial.supports(13) && (attributes = meta.getAttributeModifiers()) != null) {
                for (Map.Entry attribute : attributes.entries()) {
                    String path = "attributes." + XAttribute.of((Attribute)attribute.getKey()).name() + '.';
                    AttributeModifier modifier = (AttributeModifier)attribute.getValue();
                    this.config.set(path + "name", (Object)modifier.getName());
                    this.config.set(path + "amount", (Object)modifier.getAmount());
                    this.config.set(path + "operation", (Object)modifier.getOperation().name());
                    if (modifier.getSlot() == null) continue;
                    this.config.set(path + "slot", (Object)modifier.getSlot().name());
                }
            }
        }

        private void handleItemFlags(ItemMeta meta) {
            if (!meta.getItemFlags().isEmpty()) {
                Set flags = meta.getItemFlags();
                ArrayList<String> flagNames = new ArrayList<String>(flags.size());
                for (ItemFlag flag : flags) {
                    flagNames.add(flag.name());
                }
                this.config.set("flags", flagNames);
            }
        }

        private void handleEnchants() {
            for (Map.Entry enchant : this.meta.getEnchants().entrySet()) {
                String entry = "enchants." + XEnchantment.of((Enchantment)enchant.getKey()).name();
                this.config.set(entry, enchant.getValue());
            }
        }

        private void handleDurability(ItemMeta meta) {
            if (XMaterial.supports(13)) {
                Damageable damageable;
                if (meta instanceof Damageable && (damageable = (Damageable)meta).hasDamage()) {
                    this.config.set("damage", (Object)damageable.getDamage());
                }
            } else {
                this.config.set("damage", (Object)this.item.getDurability());
            }
        }
    }

    private static final class Deserializer
    extends SerialObject {
        @Nullable
        private final Consumer<Exception> restart;
        private static final boolean SPACE_EMPTY_LORE_LINES = true;

        private Deserializer(ItemStack item, @NotNull ConfigurationSection config, @NotNull Function<String, String> translator, @Nullable Consumer<Exception> restart) {
            super(item, config, translator);
            this.restart = restart;
        }

        public ItemStack parse() {
            this.handleMaterial();
            this.handleDamage();
            this.getOrCreateMeta();
            this.handleDurability();
            this.displayName();
            this.unbreakable();
            this.customModelData();
            this.lore();
            this.enchants();
            this.itemFlags();
            this.attributes();
            this.legacySpawnEgg();
            XItemStack.recursiveMetaHandle(this, this.meta.getClass(), this.meta, DESERIALIZE_META_HANDLERS, null);
            this.item.setItemMeta(this.meta);
            return this.item;
        }

        private void attributes() {
            if (!XMaterial.supports(13)) {
                return;
            }
            ConfigurationSection attributes = this.config.getConfigurationSection("attributes");
            if (attributes != null) {
                for (String attribute : attributes.getKeys(false)) {
                    ConfigurationSection section;
                    Optional<XAttribute> attributeInst = XAttribute.of(attribute);
                    if (!attributeInst.isPresent() || !attributeInst.get().isSupported() || (section = attributes.getConfigurationSection(attribute)) == null) continue;
                    EquipmentSlot slot = section.getString("slot") != null ? (EquipmentSlot)Enums.getIfPresent(EquipmentSlot.class, (String)section.getString("slot")).or((Object)EquipmentSlot.HAND) : null;
                    String attrName = section.getString("name");
                    if (attrName == null) {
                        attrName = UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH);
                    }
                    AttributeModifier modifier = XAttribute.createModifier(attrName, section.getDouble("amount"), (AttributeModifier.Operation)Enums.getIfPresent(AttributeModifier.Operation.class, (String)section.getString("operation")).or((Object)AttributeModifier.Operation.ADD_NUMBER), slot);
                    this.meta.addAttributeModifier((Attribute)attributeInst.get().get(), modifier);
                }
            }
            if (!this.meta.getItemFlags().isEmpty() && XReflection.supports(1, 20, 6) && !this.meta.hasAttributeModifiers()) {
                this.meta.addAttributeModifier((Attribute)XAttribute.ATTACK_DAMAGE.get(), XAttribute.createModifier("xseries:itemflagdummy", 0.0, AttributeModifier.Operation.MULTIPLY_SCALAR_1, null));
            }
        }

        private void legacySpawnEgg() {
            String creatureName;
            MaterialData data;
            if (!XMaterial.supports(11) && (data = this.item.getData()) instanceof SpawnEgg && !Strings.isNullOrEmpty((String)(creatureName = this.config.getString("creature")))) {
                SpawnEgg spawnEgg = (SpawnEgg)data;
                com.google.common.base.Optional creature = Enums.getIfPresent(EntityType.class, (String)creatureName.toUpperCase(Locale.ENGLISH));
                if (creature.isPresent()) {
                    spawnEgg.setSpawnedType((EntityType)creature.get());
                }
                this.item.setData(data);
            }
        }

        private void unbreakable() {
            if (SUPPORTS_UNBREAKABLE && this.config.isSet("unbreakable")) {
                this.meta.setUnbreakable(this.config.getBoolean("unbreakable"));
            }
        }

        private void customModelData() {
            Integer intId;
            String modelData;
            if (SUPPORTS_ITEM_MODEL && this.meta.hasItemModel()) {
                this.config.set("item-model", (Object)this.meta.getItemModel().toString());
            }
            if (SUPPORTS_ADVANCED_CUSTOM_MODEL_DATA) {
                CustomModelDataComponent customModelData = this.meta.getCustomModelDataComponent();
                ConfigurationSection detailed = this.config.getConfigurationSection("custom-model-data");
                if (detailed != null) {
                    customModelData.setStrings(XItemStack.parseRawOrList("string", "strings", detailed, x -> x));
                    customModelData.setFlags(XItemStack.parseRawOrList("flag", "flags", detailed, Boolean::parseBoolean));
                    customModelData.setFloats(XItemStack.parseRawOrList("float", "floats", detailed, Float::parseFloat));
                    customModelData.setColors(XItemStack.parseRawOrList("color", "colors", detailed, x -> XItemStack.parseColor(x).orElseThrow(() -> new IllegalArgumentException("Unknown color for custom model data: " + x))));
                } else {
                    List listed = this.config.getStringList("custom-model-data");
                    if (!listed.isEmpty()) {
                        String modelData2 = (String)listed.get(0);
                        if (modelData2 != null && !modelData2.isEmpty()) {
                            if (XItemStack.tryNumber(modelData2, Float::parseFloat) != null) {
                                customModelData.setFloats(listed.stream().map(Float::parseFloat).collect(Collectors.toList()));
                            } else {
                                Optional<Color> color = XItemStack.parseColor(modelData2);
                                if (color.isPresent()) {
                                    customModelData.setColors(listed.stream().map(XItemStack::parseColor).map(x -> (Color)x.orElseThrow(() -> new IllegalArgumentException("Unknown color for custom model data: " + x))).collect(Collectors.toList()));
                                } else {
                                    customModelData.setStrings(listed);
                                }
                            }
                        }
                    } else {
                        String modelData3 = this.config.getString("custom-model-data");
                        if (modelData3 != null && !modelData3.isEmpty()) {
                            Float floatId = (Float)XItemStack.tryNumber(modelData3, Float::parseFloat);
                            if (floatId != null) {
                                customModelData.setFloats(Collections.singletonList(floatId));
                            } else {
                                Optional<Color> color = XItemStack.parseColor(modelData3);
                                if (color.isPresent()) {
                                    customModelData.setColors(Collections.singletonList(color.get()));
                                } else {
                                    customModelData.setStrings(Collections.singletonList(modelData3));
                                }
                            }
                        }
                    }
                }
                if (!(customModelData.getColors().isEmpty() && customModelData.getStrings().isEmpty() && customModelData.getFlags().isEmpty() && customModelData.getFloats().isEmpty())) {
                    this.meta.setCustomModelDataComponent(customModelData);
                }
            } else if (SUPPORTS_CUSTOM_MODEL_DATA && (modelData = this.config.getString("custom-model-data")) != null && !modelData.isEmpty() && (intId = (Integer)XItemStack.tryNumber(modelData, Integer::parseInt)) != null) {
                this.meta.setCustomModelData(intId);
            }
        }

        private void displayName() {
            String name = this.config.getString("name");
            if (!Strings.isNullOrEmpty((String)name)) {
                String translated = (String)this.translator.apply(name);
                this.meta.setDisplayName(translated);
            } else if (name != null && name.isEmpty()) {
                this.meta.setDisplayName(" ");
            }
        }

        private void itemFlags() {
            List flags = this.config.getStringList("flags");
            if (!flags.isEmpty()) {
                for (String flag : flags) {
                    if ((flag = flag.toUpperCase(Locale.ENGLISH)).equals("ALL")) {
                        XItemFlag.decorationOnly(this.meta);
                        break;
                    }
                    XItemFlag.of(flag).ifPresent(itemFlag -> itemFlag.set(this.meta));
                }
            } else {
                String allFlags = this.config.getString("flags");
                if (!Strings.isNullOrEmpty((String)allFlags) && allFlags.equalsIgnoreCase("ALL")) {
                    XItemFlag.decorationOnly(this.meta);
                }
            }
        }

        private void handleEnchantmentStorageMeta(EnchantmentStorageMeta meta) {
            ConfigurationSection enchantment = this.config.getConfigurationSection("stored-enchants");
            if (enchantment != null) {
                for (String ench : enchantment.getKeys(false)) {
                    Optional<XEnchantment> enchant = XEnchantment.of(ench);
                    enchant.ifPresent(xEnchantment -> meta.addStoredEnchant((Enchantment)xEnchantment.get(), enchantment.getInt(ench), true));
                }
            }
        }

        private void enchants() {
            ConfigurationSection enchants = this.config.getConfigurationSection("enchants");
            if (enchants != null) {
                for (String ench : enchants.getKeys(false)) {
                    Optional<XEnchantment> enchant = XEnchantment.of(ench);
                    enchant.ifPresent(xEnchantment -> this.meta.addEnchant((Enchantment)xEnchantment.get(), enchants.getInt(ench), true));
                }
            } else if (this.config.getBoolean("glow")) {
                this.meta.addEnchant((Enchantment)XEnchantment.UNBREAKING.get(), 1, false);
                XItemFlag.HIDE_ENCHANTS.set(this.meta);
            }
        }

        private void lore() {
            ArrayList<String> translatedLore;
            if (!this.config.isSet("lore")) {
                return;
            }
            List lores = this.config.getStringList("lore");
            if (!lores.isEmpty()) {
                translatedLore = new ArrayList<String>(lores.size());
                for (String lore : lores) {
                    if (lore.isEmpty()) {
                        translatedLore.add(" ");
                        continue;
                    }
                    for (String singleLore : XItemStack.splitNewLine(lore)) {
                        if (singleLore.isEmpty()) {
                            translatedLore.add(" ");
                            continue;
                        }
                        translatedLore.add((String)this.translator.apply(singleLore));
                    }
                }
            } else {
                String lore = this.config.getString("lore");
                translatedLore = new ArrayList(10);
                if (!Strings.isNullOrEmpty((String)lore)) {
                    for (String singleLore : XItemStack.splitNewLine(lore)) {
                        if (singleLore.isEmpty()) {
                            translatedLore.add(" ");
                            continue;
                        }
                        translatedLore.add((String)this.translator.apply(singleLore));
                    }
                }
            }
            this.meta.setLore(translatedLore);
        }

        private void handleSpawnEggMeta(SpawnEggMeta spawnEgg) {
            com.google.common.base.Optional creature;
            String creatureName = this.config.getString("creature");
            if (!Strings.isNullOrEmpty((String)creatureName) && (creature = Enums.getIfPresent(EntityType.class, (String)creatureName.toUpperCase(Locale.ENGLISH))).isPresent()) {
                spawnEgg.setSpawnedType((EntityType)creature.get());
            }
        }

        private void handleTropicalFishBucketMeta(TropicalFishBucketMeta tropical) {
            DyeColor color = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)this.config.getString("color")).or((Object)DyeColor.WHITE);
            DyeColor patternColor = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)this.config.getString("pattern-color")).or((Object)DyeColor.WHITE);
            TropicalFish.Pattern pattern = (TropicalFish.Pattern)Enums.getIfPresent(TropicalFish.Pattern.class, (String)this.config.getString("pattern")).or((Object)TropicalFish.Pattern.BETTY);
            tropical.setBodyColor(color);
            tropical.setPatternColor(patternColor);
            tropical.setPattern(pattern);
        }

        private void handleCrossbowMeta(CrossbowMeta crossbow) {
            ConfigurationSection projectiles = this.config.getConfigurationSection("projectiles");
            if (projectiles != null) {
                for (String projectile : projectiles.getKeys(false)) {
                    ItemStack projectileItem = XItemStack.deserialize(this.config.getConfigurationSection("projectiles." + projectile));
                    crossbow.addChargedProjectile(projectileItem);
                }
            }
        }

        private void handleSuspiciousStewMeta(SuspiciousStewMeta stew) {
            for (String effects : this.config.getStringList("effects")) {
                XPotion.Effect effect = XPotion.parseEffect(effects);
                if (!effect.hasChance()) continue;
                stew.addCustomEffect(effect.getEffect(), true);
            }
        }

        private void handleCompassMeta(CompassMeta compass) {
            compass.setLodestoneTracked(this.config.getBoolean("tracked"));
            ConfigurationSection lodestone = this.config.getConfigurationSection("lodestone");
            if (lodestone != null) {
                World world = Bukkit.getWorld((String)lodestone.getString("world"));
                double x = lodestone.getDouble("x");
                double y = lodestone.getDouble("y");
                double z = lodestone.getDouble("z");
                compass.setLodestone(new Location(world, x, y, z));
            }
        }

        private void handleAxolotlBucketMeta(AxolotlBucketMeta bucket) {
            String variantStr = this.config.getString("color");
            if (variantStr != null) {
                Axolotl.Variant variant = (Axolotl.Variant)Enums.getIfPresent(Axolotl.Variant.class, (String)variantStr.toUpperCase(Locale.ENGLISH)).or((Object)Axolotl.Variant.BLUE);
                bucket.setVariant(variant);
            }
        }

        private void handleArmorMeta(ArmorMeta armor) {
            ConfigurationSection trim = this.config.getConfigurationSection("trim");
            if (trim != null) {
                TrimMaterial trimMaterial = (TrimMaterial)Registry.TRIM_MATERIAL.get(NamespacedKey.fromString((String)trim.getString("material")));
                TrimPattern trimPattern = (TrimPattern)Registry.TRIM_PATTERN.get(NamespacedKey.fromString((String)trim.getString("pattern")));
                armor.setTrim(new ArmorTrim(trimMaterial, trimPattern));
            }
        }

        private void handleMapMeta(MapMeta map) {
            World world;
            ConfigurationSection view;
            ConfigurationSection mapSection = this.config.getConfigurationSection("map");
            if (mapSection == null) {
                return;
            }
            map.setScaling(mapSection.getBoolean("scaling"));
            if (XMaterial.supports(11)) {
                if (mapSection.isSet("location")) {
                    map.setLocationName(mapSection.getString("location"));
                }
                if (mapSection.isSet("color")) {
                    XItemStack.parseColor(mapSection.getString("color")).ifPresent(arg_0 -> ((MapMeta)map).setColor(arg_0));
                }
            }
            if (XMaterial.supports(14) && (view = mapSection.getConfigurationSection("view")) != null && (world = Bukkit.getWorld((String)view.getString("world"))) != null) {
                MapView mapView = Bukkit.createMap((World)world);
                mapView.setWorld(world);
                mapView.setScale((MapView.Scale)Enums.getIfPresent(MapView.Scale.class, (String)view.getString("scale")).or((Object)MapView.Scale.NORMAL));
                mapView.setLocked(view.getBoolean("locked"));
                mapView.setTrackingPosition(view.getBoolean("tracking-position"));
                mapView.setUnlimitedTracking(view.getBoolean("unlimited-tracking"));
                ConfigurationSection centerSection = view.getConfigurationSection("center");
                if (centerSection != null) {
                    mapView.setCenterX(centerSection.getInt("x"));
                    mapView.setCenterZ(centerSection.getInt("z"));
                }
                map.setMapView(mapView);
            }
        }

        private void handleBookMeta(BookMeta book) {
            String generationValue;
            ConfigurationSection bookInfo = this.config.getConfigurationSection("book");
            if (bookInfo == null) {
                return;
            }
            book.setTitle(bookInfo.getString("title"));
            book.setAuthor(bookInfo.getString("author"));
            book.setPages(bookInfo.getStringList("pages"));
            if (XMaterial.supports(9) && (generationValue = bookInfo.getString("generation")) != null) {
                BookMeta.Generation generation = (BookMeta.Generation)Enums.getIfPresent(BookMeta.Generation.class, (String)generationValue).orNull();
                book.setGeneration(generation);
            }
        }

        private void handleFireworkMeta(FireworkMeta firework) {
            firework.setPower(this.config.getInt("power"));
            ConfigurationSection fireworkSection = this.config.getConfigurationSection("firework");
            if (fireworkSection == null) {
                return;
            }
            FireworkEffect.Builder builder = FireworkEffect.builder();
            for (String fws : fireworkSection.getKeys(false)) {
                ConfigurationSection fw = this.config.getConfigurationSection("firework." + fws);
                builder.flicker(fw.getBoolean("flicker"));
                builder.trail(fw.getBoolean("trail"));
                builder.with((FireworkEffect.Type)Enums.getIfPresent(FireworkEffect.Type.class, (String)fw.getString("type").toUpperCase(Locale.ENGLISH)).or((Object)FireworkEffect.Type.STAR));
                ConfigurationSection colorsSection = fw.getConfigurationSection("colors");
                if (colorsSection != null) {
                    Optional<Color> color;
                    List fwColors = colorsSection.getStringList("base");
                    ArrayList<Color> colors = new ArrayList<Color>(fwColors.size());
                    for (String colorStr : fwColors) {
                        color = XItemStack.parseColor(colorStr);
                        if (!color.isPresent()) continue;
                        colors.add(color.get());
                    }
                    builder.withColor(colors);
                    fwColors = colorsSection.getStringList("fade");
                    colors = new ArrayList(fwColors.size());
                    for (String colorStr : fwColors) {
                        color = XItemStack.parseColor(colorStr);
                        if (!color.isPresent()) continue;
                        colors.add(color.get());
                    }
                    builder.withFade(colors);
                }
                firework.addEffect(builder.build());
            }
        }

        private void handleBlockStateMeta(BlockStateMeta bsm) {
            BlockState state = XItemStack.safeBlockState(bsm);
            if (state instanceof CreatureSpawner) {
                CreatureSpawner spawner = (CreatureSpawner)state;
                String spawnerStr = this.config.getString("spawner");
                if (!Strings.isNullOrEmpty((String)spawnerStr)) {
                    spawner.setSpawnedType((EntityType)Enums.getIfPresent(EntityType.class, (String)spawnerStr.toUpperCase(Locale.ENGLISH)).orNull());
                    spawner.update(true);
                    bsm.setBlockState((BlockState)spawner);
                }
            } else if (XMaterial.supports(11) && state instanceof ShulkerBox) {
                ConfigurationSection shulkerSection = this.config.getConfigurationSection("contents");
                if (shulkerSection != null) {
                    ShulkerBox box = (ShulkerBox)state;
                    for (String key : shulkerSection.getKeys(false)) {
                        ItemStack boxItem = XItemStack.deserialize(shulkerSection.getConfigurationSection(key));
                        int slot = XItemStack.toInt(key, 0);
                        box.getInventory().setItem(slot, boxItem);
                    }
                    box.update(true);
                    bsm.setBlockState((BlockState)box);
                }
            } else if (state instanceof Banner) {
                Banner banner = (Banner)state;
                ConfigurationSection patterns = this.config.getConfigurationSection("patterns");
                if (!XMaterial.supports(14)) {
                    banner.setBaseColor(DyeColor.WHITE);
                }
                if (patterns != null) {
                    for (String pattern : patterns.getKeys(false)) {
                        Optional<XPatternType> patternType = XPatternType.of(pattern);
                        if (!patternType.isPresent() || !patternType.get().isSupported()) continue;
                        DyeColor color = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)patterns.getString(pattern).toUpperCase(Locale.ENGLISH)).or((Object)DyeColor.WHITE);
                        banner.addPattern(new Pattern(color, (PatternType)patternType.get().get()));
                    }
                    banner.update(true);
                    bsm.setBlockState((BlockState)banner);
                }
            }
        }

        private void handlePotionMeta(ItemMeta meta) {
            if (XMaterial.supports(9)) {
                PotionMeta potion = (PotionMeta)meta;
                for (String effects : this.config.getStringList("effects")) {
                    XPotion.Effect effect = XPotion.parseEffect(effects);
                    if (!effect.hasChance()) continue;
                    potion.addCustomEffect(effect.getEffect(), true);
                }
                String baseType = this.config.getString("base-type");
                if (!Strings.isNullOrEmpty((String)baseType)) {
                    PotionType potionType;
                    try {
                        potionType = PotionType.valueOf((String)baseType);
                    }
                    catch (IllegalArgumentException ex) {
                        potionType = PotionType.HEALING;
                    }
                    potion.setBasePotionType(potionType);
                }
                if (SUPPORTS_POTION_COLOR && this.config.contains("color")) {
                    potion.setColor(Color.fromRGB((int)this.config.getInt("color")));
                }
            }
        }

        private void handleLeatherArmorMeta(LeatherArmorMeta leather) {
            String colorStr = this.config.getString("color");
            if (colorStr != null) {
                XItemStack.parseColor(colorStr).ifPresent(arg_0 -> ((LeatherArmorMeta)leather).setColor(arg_0));
            }
        }

        private void handleBannerMeta(BannerMeta banner) {
            ConfigurationSection patterns = this.config.getConfigurationSection("patterns");
            if (patterns != null) {
                for (String pattern : patterns.getKeys(false)) {
                    Optional<XPatternType> patternType = XPatternType.of(pattern);
                    if (!patternType.isPresent() || !patternType.get().isSupported()) continue;
                    DyeColor color = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)patterns.getString(pattern).toUpperCase(Locale.ENGLISH)).or((Object)DyeColor.WHITE);
                    banner.addPattern(new Pattern(color, (PatternType)patternType.get().get()));
                }
            }
        }

        private void handleSkullMeta(SkullMeta meta) {
            String skull = this.config.getString("skull");
            if (skull != null) {
                if (skull.isEmpty()) {
                    XSkull.of((ItemMeta)meta).profile(Profileable.detect(skull)).removeProfile();
                } else {
                    XSkull.of((ItemMeta)meta).profile(Profileable.detect(skull)).lenient().apply();
                }
            }
        }

        private void handleDurability() {
            if (XMaterial.supports(13)) {
                int damage;
                if (this.meta instanceof Damageable && (damage = this.config.getInt("damage")) > 0) {
                    ((Damageable)this.meta).setDamage(damage);
                }
            } else {
                int damage = this.config.getInt("damage");
                if (damage > 0) {
                    this.item.setDurability((short)damage);
                }
            }
        }

        private void handleDamage() {
            int amount = this.config.getInt("amount");
            if (amount > 1) {
                this.item.setAmount(amount);
            }
        }

        private void getOrCreateMeta() {
            this.meta = this.item.getItemMeta();
            if (this.meta == null) {
                this.meta = Bukkit.getItemFactory().getItemMeta(XMaterial.STONE.get());
            }
        }

        private void handleMaterial() {
            String materialName = this.config.getString("material");
            if (!Strings.isNullOrEmpty((String)materialName)) {
                UnAcceptableMaterialCondition unsupportedMaterialCondition;
                XMaterial material;
                Optional<XMaterial> materialOpt = XMaterial.matchXMaterial(materialName);
                if (materialOpt.isPresent()) {
                    material = materialOpt.get();
                } else {
                    UnknownMaterialCondition unknownMaterialCondition = new UnknownMaterialCondition(materialName);
                    if (this.restart == null) {
                        throw unknownMaterialCondition;
                    }
                    this.restart.accept(unknownMaterialCondition);
                    if (unknownMaterialCondition.hasSolution()) {
                        material = unknownMaterialCondition.solution;
                    } else {
                        throw unknownMaterialCondition;
                    }
                }
                if (!material.isSupported()) {
                    unsupportedMaterialCondition = new UnAcceptableMaterialCondition(material, UnAcceptableMaterialCondition.Reason.UNSUPPORTED);
                    if (this.restart == null) {
                        throw unsupportedMaterialCondition;
                    }
                    this.restart.accept(unsupportedMaterialCondition);
                    if (unsupportedMaterialCondition.hasSolution()) {
                        material = unsupportedMaterialCondition.solution;
                    } else {
                        throw unsupportedMaterialCondition;
                    }
                }
                if (XTag.INVENTORY_NOT_DISPLAYABLE.isTagged(material)) {
                    unsupportedMaterialCondition = new UnAcceptableMaterialCondition(material, UnAcceptableMaterialCondition.Reason.NOT_DISPLAYABLE);
                    if (this.restart == null) {
                        throw unsupportedMaterialCondition;
                    }
                    this.restart.accept(unsupportedMaterialCondition);
                    if (unsupportedMaterialCondition.hasSolution()) {
                        material = unsupportedMaterialCondition.solution;
                    } else {
                        throw unsupportedMaterialCondition;
                    }
                }
                material.setType(this.item);
            } else {
                String skull = this.config.getString("skull");
                if (skull != null) {
                    XMaterial.PLAYER_HEAD.setType(this.item);
                }
            }
        }
    }

    public static final class UnAcceptableMaterialCondition
    extends MaterialCondition {
        private final XMaterial material;
        private final Reason reason;

        public UnAcceptableMaterialCondition(XMaterial material, Reason reason) {
            super("Unacceptable material: " + material.name() + " (" + reason.name() + ')');
            this.material = material;
            this.reason = reason;
        }

        public Reason getReason() {
            return this.reason;
        }

        public XMaterial getMaterial() {
            return this.material;
        }

        public static enum Reason {
            UNSUPPORTED,
            NOT_DISPLAYABLE;

        }
    }

    public static final class UnknownMaterialCondition
    extends MaterialCondition {
        private final String material;

        public UnknownMaterialCondition(String material) {
            super("Unknown material: " + material);
            this.material = material;
        }

        public String getMaterial() {
            return this.material;
        }
    }

    public static class MaterialCondition
    extends RuntimeException {
        protected XMaterial solution;

        public MaterialCondition(String message) {
            super(message);
        }

        public void setSolution(XMaterial solution) {
            this.solution = solution;
        }

        public boolean hasSolution() {
            return this.solution != null;
        }
    }
}

