/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.libs.com.cryptomorin.xseries.base;

import com.google.common.base.Preconditions;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;

class XNamespacedKey {
    private static final boolean SUPPORTS_NamespacedKey_fromString;

    XNamespacedKey() {
    }

    private static boolean isValidNamespaceChar(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.' || c == '_' || c == '-';
    }

    private static boolean isValidKeyChar(char c) {
        return XNamespacedKey.isValidNamespaceChar(c) || c == '/';
    }

    private static boolean isValidNamespace(String namespace) {
        int len = namespace.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (XNamespacedKey.isValidNamespaceChar(namespace.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidKey(String key) {
        int len = key.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (XNamespacedKey.isValidKeyChar(key.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected static NamespacedKey fromString(@NotNull String string) {
        String key;
        if (SUPPORTS_NamespacedKey_fromString) {
            return NamespacedKey.fromString((String)string);
        }
        Preconditions.checkArgument((string != null && !string.isEmpty() ? 1 : 0) != 0, (Object)"Input string must not be empty or null");
        String[] components = string.split(":", 3);
        if (components.length > 2) {
            return null;
        }
        String string2 = key = components.length == 2 ? components[1] : "";
        if (components.length == 1) {
            String namespace = components[0];
            if (!namespace.isEmpty() && XNamespacedKey.isValidKey(namespace)) {
                return NamespacedKey.minecraft((String)namespace);
            }
            return null;
        }
        if (components.length == 2 && !XNamespacedKey.isValidKey(key)) {
            return null;
        }
        String namespace = components[0];
        if (namespace.isEmpty()) {
            return NamespacedKey.minecraft((String)key);
        }
        return !XNamespacedKey.isValidNamespace(namespace) ? null : new NamespacedKey(namespace, key);
    }

    static {
        boolean supportsFromString;
        try {
            Class<?> NamespacedKey2 = Class.forName("org.bukkit.NamespacedKey");
            NamespacedKey2.getDeclaredMethod("fromString", String.class);
            supportsFromString = true;
        }
        catch (Throwable ex) {
            supportsFromString = false;
        }
        SUPPORTS_NamespacedKey_fromString = supportsFromString;
    }
}

