/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.libs.xyz.tozymc.reflect.util;

import com.loohp.lotterysix.libs.xyz.tozymc.reflect.util.NotFoundMessages;
import com.loohp.lotterysix.libs.xyz.tozymc.util.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class Constructors {
    private Constructors() {
    }

    public static Constructor<?> getConstructor(@NotNull Class<?> clazz, Class<?> ... paramTypes) {
        Preconditions.checkNotNull(clazz, "Clazz cannot be null");
        return Constructors.getConstructor0(clazz, paramTypes);
    }

    public static Constructor<?> getConstructor(@NotNull Object instance, Class<?> ... paramTypes) {
        Preconditions.checkNotNull(instance, "Instance cannot be null");
        return Constructors.getConstructor0(instance.getClass(), paramTypes);
    }

    @NotNull
    public static Object newInstance(@NotNull Class<?> clazz, Class<?> @NotNull [] paramTypes, Object ... params) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        Preconditions.checkNotNull(clazz, "Clazz cannot be null");
        Preconditions.checkState(paramTypes.length == params.length, "The length of parameter passed not equals parameter types");
        Constructor<?> constructor = Constructors.getConstructor0(clazz, paramTypes);
        return Preconditions.checkNotNull(constructor, NotFoundMessages.constructorNotFound(clazz, paramTypes)).newInstance(params);
    }

    @NotNull
    public static Object newInstance(@NotNull Class<?> clazz, Object ... params) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        Preconditions.checkNotNull(clazz, "Clazz cannot be null");
        Class[] paramTypes = (Class[])Arrays.stream(params).map(param -> param == null ? Object.class : param.getClass()).toArray(Class[]::new);
        Constructor<?> constructor = Constructors.getConstructor0(clazz, paramTypes);
        return Preconditions.checkNotNull(constructor, NotFoundMessages.constructorNotFound(clazz, paramTypes)).newInstance(params);
    }

    @NotNull
    public static Object newInstance(@NotNull Object instance, Object ... params) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        Preconditions.checkNotNull(instance, "Instance cannot be null");
        Class[] paramTypes = (Class[])Arrays.stream(params).map(param -> param == null ? Object.class : param.getClass()).toArray(Class[]::new);
        Class<?> clazz = instance.getClass();
        Constructor<?> constructor = Constructors.getConstructor0(clazz, paramTypes);
        return Preconditions.checkNotNull(constructor, NotFoundMessages.constructorNotFound(clazz, paramTypes)).newInstance(params);
    }

    @NotNull
    public static Object newInstance(@NotNull Object instance, Class<?> @NotNull [] paramTypes, Object ... params) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        Preconditions.checkNotNull(instance, "Instance cannot be null");
        Preconditions.checkState(paramTypes.length == params.length, "The length of parameter passed not equals parameter types");
        Class<?> clazz = instance.getClass();
        Constructor<?> constructor = Constructors.getConstructor0(clazz, paramTypes);
        return Preconditions.checkNotNull(constructor, NotFoundMessages.constructorNotFound(clazz, paramTypes)).newInstance(params);
    }

    private static Constructor<?> getConstructor0(Class<?> clazz, Class<?>[] paramTypes) {
        return Arrays.stream(clazz.getDeclaredConstructors()).filter(constructor -> Arrays.equals(constructor.getParameterTypes(), paramTypes)).findFirst().orElse(null);
    }
}

