/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.libs.xyz.tozymc.reflect.util;

import com.loohp.lotterysix.libs.xyz.tozymc.reflect.util.NotFoundMessages;
import com.loohp.lotterysix.libs.xyz.tozymc.util.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Methods {
    private Methods() {
    }

    public static Method getMethod(@NotNull Class<?> clazz, @NotNull String name, Class<?> ... paramTypes) {
        Preconditions.checkNotNull(clazz, "Clazz cannot be null");
        Preconditions.checkNotNull(name, "Name cannot be null");
        return Methods.getMethod0(clazz, name, paramTypes);
    }

    public static Method getMethod(@NotNull Object instance, @NotNull String name, Class<?> ... paramTypes) {
        Preconditions.checkNotNull(instance, "Instance cannot be null");
        Preconditions.checkNotNull(name, "Name cannot be null");
        return Methods.getMethod0(instance.getClass(), name, paramTypes);
    }

    public static Object invokeMethod(@NotNull Class<?> clazz, @Nullable Object instance, @NotNull String name, Object ... params) throws InvocationTargetException, IllegalAccessException {
        Preconditions.checkNotNull(clazz, "Clazz cannot be null");
        Preconditions.checkNotNull(name, "Name cannot be null");
        Class[] paramTypes = (Class[])Arrays.stream(params).map(param -> param == null ? Object.class : param.getClass()).toArray(Class[]::new);
        Method method = Methods.getMethod0(clazz, name, paramTypes);
        return Preconditions.checkNotNull(method, NotFoundMessages.methodNotFound(name, paramTypes)).invoke(instance, params);
    }

    public static Object invokeMethod(@NotNull Class<?> clazz, @Nullable Object instance, @NotNull String name, Class<?> @NotNull [] paramTypes, Object ... params) throws InvocationTargetException, IllegalAccessException {
        Preconditions.checkNotNull(clazz, "Clazz cannot be null");
        Preconditions.checkNotNull(name, "Name cannot be null");
        Preconditions.checkState(paramTypes.length == params.length, "The length of parameter passed not equals parameter types");
        Method method = Methods.getMethod0(clazz, name, paramTypes);
        return Preconditions.checkNotNull(method, NotFoundMessages.methodNotFound(name, paramTypes)).invoke(instance, params);
    }

    public static Object invokeMethod(@NotNull Object instance, @NotNull String name, Class<?> @NotNull [] paramTypes, Object ... params) throws InvocationTargetException, IllegalAccessException {
        Preconditions.checkNotNull(instance, "Instance cannot be null");
        Preconditions.checkNotNull(name, "Name cannot be null");
        Preconditions.checkState(paramTypes.length == params.length, "The length of parameter passed not equals parameter types");
        Method method = Methods.getMethod0(instance.getClass(), name, paramTypes);
        return Preconditions.checkNotNull(method, NotFoundMessages.methodNotFound(name, paramTypes)).invoke(instance, params);
    }

    public static Object invokeMethod(@Nullable Object instance, @NotNull String name, Object ... params) throws InvocationTargetException, IllegalAccessException {
        Preconditions.checkNotNull(instance, "Instance cannot be null");
        Preconditions.checkNotNull(name, "Name cannot be null");
        Class[] paramTypes = (Class[])Arrays.stream(params).map(param -> param == null ? Object.class : param.getClass()).toArray(Class[]::new);
        Method method = Methods.getMethod0(instance.getClass(), name, paramTypes);
        return Preconditions.checkNotNull(method, NotFoundMessages.methodNotFound(name, paramTypes)).invoke(instance, params);
    }

    private static Method getMethod0(Class<?> clazz, String name, Class<?>[] paramTypes) {
        return Arrays.stream(clazz.getDeclaredMethods()).filter(method -> method.getName().equals(name) && Arrays.equals(method.getParameterTypes(), paramTypes)).findFirst().orElse(null);
    }
}

