/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.metrics;

import com.loohp.lotterysix.LotterySixPlugin;
import com.loohp.lotterysix.game.lottery.CompletedLotterySixGame;
import com.loohp.lotterysix.game.lottery.LazyCompletedLotterySixGameList;
import com.loohp.lotterysix.game.lottery.PlayableLotterySixGame;
import com.loohp.lotterysix.game.objects.PlayerBets;
import com.loohp.lotterysix.game.objects.PrizeTier;
import com.loohp.lotterysix.metrics.Metrics;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.concurrent.Callable;

public class Charts {
    private static Optional<CompletedLotterySixGame> getLatestGame() {
        LazyCompletedLotterySixGameList games = LotterySixPlugin.getInstance().getCompletedGames();
        return games.isEmpty() ? Optional.empty() : Optional.of((CompletedLotterySixGame)games.get(0));
    }

    private static Optional<PlayableLotterySixGame> getCurrentGame() {
        return Optional.ofNullable(LotterySixPlugin.getInstance().getCurrentGame());
    }

    public static void setup(Metrics metrics) {
        metrics.addCustomChart(new Metrics.SingleLineChart("first_tier_winners", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Charts.getLatestGame().map(e -> (int)Math.ceil(e.getWinnerCountForTier(PrizeTier.FIRST))).orElse(0);
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("second_tier_winners", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Charts.getLatestGame().map(e -> (int)Math.ceil(e.getWinnerCountForTier(PrizeTier.SECOND))).orElse(0);
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("third_tier_winners", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Charts.getLatestGame().map(e -> (int)Math.ceil(e.getWinnerCountForTier(PrizeTier.THIRD))).orElse(0);
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("fourth_tier_winners", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Charts.getLatestGame().map(e -> (int)Math.ceil(e.getWinnerCountForTier(PrizeTier.FOURTH))).orElse(0);
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("fifth_tier_winners", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Charts.getLatestGame().map(e -> (int)Math.ceil(e.getWinnerCountForTier(PrizeTier.FIFTH))).orElse(0);
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("sixth_tier_winners", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Charts.getLatestGame().map(e -> (int)Math.ceil(e.getWinnerCountForTier(PrizeTier.SIXTH))).orElse(0);
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("seventh_tier_winners", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Charts.getLatestGame().map(e -> (int)Math.ceil(e.getWinnerCountForTier(PrizeTier.SEVENTH))).orElse(0);
            }
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("most_popular_number", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                if (Charts.getLatestGame().isPresent()) {
                    CompletedLotterySixGame game = (CompletedLotterySixGame)Charts.getLatestGame().get();
                    PrimitiveIterator.OfInt itr = game.getBets().stream().flatMapToInt(each -> each.getChosenNumbers().getAllNumbers().stream().mapToInt(i -> i)).iterator();
                    while (itr.hasNext()) {
                        valueMap.merge(itr.nextInt() + "", 1, (a, b) -> a + b);
                    }
                }
                return valueMap;
            }
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("most_popular_winning_number", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                if (Charts.getLatestGame().isPresent()) {
                    CompletedLotterySixGame game = (CompletedLotterySixGame)Charts.getLatestGame().get();
                    for (int i : game.getDrawResult().getNumbers()) {
                        valueMap.put(i + "", 1);
                    }
                    valueMap.put(game.getDrawResult().getSpecialNumber() + "", 1);
                }
                return valueMap;
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("lotterysix_played", new Callable<Integer>(){
            private long lastCall = System.currentTimeMillis();

            @Override
            public Integer call() throws Exception {
                int counts = (int)LotterySixPlugin.getInstance().getCompletedGames().indexStream().filter(each -> each.getDatetime() >= this.lastCall).count();
                this.lastCall = System.currentTimeMillis();
                return counts;
            }
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("most_popular_bet_entry_method", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                if (Charts.getLatestGame().isPresent()) {
                    CompletedLotterySixGame game = (CompletedLotterySixGame)Charts.getLatestGame().get();
                    for (PlayerBets playerBets : game.getBets()) {
                        valueMap.merge(playerBets.getChosenNumbers().getType().name(), 1, (a, b) -> a + b);
                    }
                }
                return valueMap;
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("on-going_lottery_six_games", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return Charts.getCurrentGame().map(each -> 1).orElse(0);
            }
        }));
        metrics.addCustomChart(new Metrics.SimplePie("number_of_choices", new Callable<String>(){

            @Override
            public String call() throws Exception {
                return LotterySixPlugin.getInstance().numberOfChoices + "";
            }
        }));
        metrics.addCustomChart(new Metrics.SimplePie("price_per_unit_bet", new Callable<String>(){

            @Override
            public String call() throws Exception {
                return LotterySixPlugin.getInstance().pricePerBet + "";
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("global_total_current_turnover", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return (int)Math.min(Charts.getCurrentGame().map(each -> each.getTotalBets()).orElse(0L), Integer.MAX_VALUE);
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("global_total_previous_winnings", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return (int)Math.min(Charts.getLatestGame().map(each -> each.getWinnings().stream().mapToLong(w -> w.getWinnings()).sum()).orElse(0L), Integer.MAX_VALUE);
            }
        }));
    }
}

