/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.pluginmessaging;

import com.google.common.reflect.TypeToken;
import com.loohp.lotterysix.LotterySixPlugin;
import com.loohp.lotterysix.events.LotterySixEvent;
import com.loohp.lotterysix.events.PlayerBetEvent;
import com.loohp.lotterysix.game.LotterySix;
import com.loohp.lotterysix.game.lottery.CompletedLotterySixGame;
import com.loohp.lotterysix.game.lottery.CompletedLotterySixGameIndex;
import com.loohp.lotterysix.game.lottery.GameNumber;
import com.loohp.lotterysix.game.lottery.ILotterySixGame;
import com.loohp.lotterysix.game.lottery.PlayableLotterySixGame;
import com.loohp.lotterysix.game.objects.AddBetResult;
import com.loohp.lotterysix.game.objects.BetUnitType;
import com.loohp.lotterysix.game.objects.LotterySixAction;
import com.loohp.lotterysix.game.objects.NumberStatistics;
import com.loohp.lotterysix.game.objects.Pair;
import com.loohp.lotterysix.game.objects.PlayerBets;
import com.loohp.lotterysix.game.objects.PlayerPreferenceKey;
import com.loohp.lotterysix.game.objects.PlayerStatsKey;
import com.loohp.lotterysix.game.objects.betnumbers.BetNumbers;
import com.loohp.lotterysix.game.objects.betnumbers.BetNumbersBuilder;
import com.loohp.lotterysix.game.objects.betnumbers.BetNumbersType;
import com.loohp.lotterysix.game.player.LotteryPlayer;
import com.loohp.lotterysix.libs.com.google.gson.Gson;
import com.loohp.lotterysix.libs.com.google.gson.JsonElement;
import com.loohp.lotterysix.libs.com.google.gson.JsonObject;
import com.loohp.lotterysix.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.lotterysix.utils.ArrayUtils;
import com.loohp.lotterysix.utils.ChatColorUtils;
import com.loohp.lotterysix.utils.DataTypeIO;
import com.loohp.lotterysix.utils.LotteryUtils;
import com.loohp.lotterysix.utils.StringUtils;
import com.loohp.lotterysix.utils.TitleUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class PluginMessageHandler
implements PluginMessageListener {
    private static final Gson GSON = new Gson();
    private final LotterySix instance;
    private final Map<Integer, ByteArrayOutputStream> incomingMessages;
    private final Random random;
    private final AtomicInteger sequenceCounter;
    private final AtomicInteger lastReceivedSequence;
    private final Executor executor;

    private static <T> Gson gsonOfInstance(T instance) {
        return GSON.newBuilder().registerTypeAdapter(instance.getClass(), type -> instance).create();
    }

    public PluginMessageHandler(LotterySix instance) {
        this.instance = instance;
        this.incomingMessages = new ConcurrentHashMap<Integer, ByteArrayOutputStream>();
        this.random = new Random();
        this.sequenceCounter = new AtomicInteger();
        this.lastReceivedSequence = new AtomicInteger();
        this.executor = Executors.newSingleThreadExecutor();
    }

    public void onPluginMessageReceived(String channel, Player p, byte[] data) {
        try {
            int nRead;
            if (!channel.equals("lotterysix:main")) {
                return;
            }
            byte[] packet = Arrays.copyOf(data, data.length);
            DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet));
            int sequenceId = inputStream.readInt();
            short packetId = inputStream.readShort();
            boolean end = inputStream.readBoolean();
            ByteArrayOutputStream buffer = this.incomingMessages.get(sequenceId);
            if (buffer == null) {
                buffer = new ByteArrayOutputStream();
                this.incomingMessages.putIfAbsent(sequenceId, buffer);
            }
            byte[] b = new byte[1024];
            while ((nRead = inputStream.read(b, 0, b.length)) != -1) {
                buffer.write(b, 0, nRead);
            }
            if (!end) {
                return;
            }
            this.incomingMessages.remove(sequenceId);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            this.executor.execute(() -> {
                try {
                    switch (packetId) {
                        case 0: {
                            if (in.readBoolean()) {
                                UUID gameId = DataTypeIO.readUUID(in);
                                long dateTime = in.readLong();
                                GameNumber gameNumber = DataTypeIO.readGameNumber(in);
                                String specialName = in.readBoolean() ? DataTypeIO.readString(in, StandardCharsets.UTF_8) : null;
                                int mapSize = in.readInt();
                                HashMap<Integer, NumberStatistics> numberStatistics = new HashMap<Integer, NumberStatistics>(mapSize);
                                for (int i2 = 0; i2 < mapSize; ++i2) {
                                    numberStatistics.put(Integer.valueOf(in.readByte()), DataTypeIO.readNumberStatistics(in));
                                }
                                long carryOverFund = in.readLong();
                                long lowestTopPlacesPrize = in.readLong();
                                boolean isValid = in.readBoolean();
                                int listSize = in.readInt();
                                HashSet<UUID> betIds = new HashSet<UUID>(listSize);
                                for (int i3 = 0; i3 < listSize; ++i3) {
                                    betIds.add(DataTypeIO.readUUID(in));
                                }
                                PlayableLotterySixGame currentGame = this.instance.getCurrentGame();
                                if (currentGame == null || !currentGame.getGameId().equals(gameId) || isValid && !currentGame.isValid()) {
                                    currentGame = PlayableLotterySixGame.createPresetGame(this.instance, gameId, gameNumber, dateTime, specialName, numberStatistics, carryOverFund, lowestTopPlacesPrize, Collections.emptyList());
                                    if (!isValid) {
                                        currentGame.markInvalid();
                                    }
                                    this.instance.setCurrentGame(currentGame);
                                } else {
                                    currentGame.setDatetime(dateTime, gameNumber);
                                    currentGame.setSpecialName(specialName);
                                    currentGame.setNumberStatistics(numberStatistics);
                                    currentGame.setCarryOverFund(carryOverFund);
                                    currentGame.setLowestTopPlacesPrize(lowestTopPlacesPrize);
                                    if (!isValid) {
                                        currentGame.markInvalid();
                                    }
                                }
                                betIds.removeAll(currentGame.getBetIds());
                                if (!betIds.isEmpty()) {
                                    this.requestCurrentGameBets(gameId, betIds);
                                }
                            } else {
                                if (this.instance.getCurrentGame() != null) {
                                    this.instance.getCurrentGame().markInvalid();
                                }
                                this.instance.setCurrentGame(null);
                            }
                            this.instance.requestSave(true);
                            break;
                        }
                        case 1: {
                            CompletedLotterySixGame lastGame = null;
                            if (!this.instance.getCompletedGames().isEmpty()) {
                                lastGame = this.instance.getCompletedGames().get(0);
                            }
                            UUID gameId = DataTypeIO.readUUID(in);
                            if (lastGame != null && lastGame.getGameId().equals(gameId)) {
                                PluginMessageHandler.gsonOfInstance(lastGame).fromJson(DataTypeIO.readString(in, StandardCharsets.UTF_8), CompletedLotterySixGame.class);
                                this.instance.getCompletedGames().setGameDirty(lastGame.getGameId());
                            } else {
                                CompletedLotterySixGame game = GSON.fromJson(DataTypeIO.readString(in, StandardCharsets.UTF_8), CompletedLotterySixGame.class);
                                this.instance.setLastGame(game);
                            }
                            this.instance.requestSave(false);
                            break;
                        }
                        case 2: {
                            ILotterySixGame game;
                            UUID gameId = in.readBoolean() ? DataTypeIO.readUUID(in) : null;
                            UUID uuid = DataTypeIO.readUUID(in);
                            Player player = Bukkit.getPlayer((UUID)uuid);
                            if (player == null) break;
                            String message = DataTypeIO.readString(in, StandardCharsets.UTF_8);
                            int fadeIn = in.readInt();
                            int stay = in.readInt();
                            int fadeOut = in.readInt();
                            ILotterySixGame iLotterySixGame = game = gameId == null ? null : this.instance.getGame(gameId);
                            if (game instanceof PlayableLotterySixGame) {
                                message = LotteryUtils.formatPlaceholders((OfflinePlayer)player, message, this.instance, (PlayableLotterySixGame)game);
                            } else if (game instanceof CompletedLotterySixGame) {
                                message = LotteryUtils.formatPlaceholders((OfflinePlayer)player, message, this.instance, (CompletedLotterySixGame)game);
                            }
                            TitleUtils.sendTitle(player, ChatColorUtils.translateAlternateColorCodes('&', PlaceholderAPI.setPlaceholders((Player)player, (String)message)), "", fadeIn, stay, fadeOut);
                            break;
                        }
                        case 3: {
                            ILotterySixGame game;
                            UUID gameId = in.readBoolean() ? DataTypeIO.readUUID(in) : null;
                            UUID uuid = DataTypeIO.readUUID(in);
                            Player player = Bukkit.getPlayer((UUID)uuid);
                            if (player == null) break;
                            String message = DataTypeIO.readString(in, StandardCharsets.UTF_8);
                            String hover = DataTypeIO.readString(in, StandardCharsets.UTF_8);
                            ILotterySixGame iLotterySixGame = game = gameId == null ? null : this.instance.getGame(gameId);
                            if (game instanceof PlayableLotterySixGame) {
                                message = LotteryUtils.formatPlaceholders((OfflinePlayer)player, message, this.instance, (PlayableLotterySixGame)game);
                                if (!hover.isEmpty()) {
                                    hover = LotteryUtils.formatPlaceholders((OfflinePlayer)player, hover, this.instance, (PlayableLotterySixGame)game);
                                }
                            } else if (game instanceof CompletedLotterySixGame) {
                                message = LotteryUtils.formatPlaceholders((OfflinePlayer)player, message, this.instance, (CompletedLotterySixGame)game);
                                if (!hover.isEmpty()) {
                                    hover = LotteryUtils.formatPlaceholders((OfflinePlayer)player, hover, this.instance, (CompletedLotterySixGame)game);
                                }
                            }
                            TextComponent textComponent = new TextComponent(ChatColorUtils.translateAlternateColorCodes('&', message));
                            if (!hover.isEmpty()) {
                                textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new BaseComponent[]{new TextComponent(ChatColorUtils.translateAlternateColorCodes('&', hover))}));
                            }
                            player.spigot().sendMessage((BaseComponent)textComponent);
                            break;
                        }
                        case 4: {
                            UUID uuid = DataTypeIO.readUUID(in);
                            long amount = in.readLong();
                            LotterySixPlugin.giveMoneyNow(uuid, amount);
                            break;
                        }
                        case 5: {
                            int id = in.readInt();
                            UUID uuid = DataTypeIO.readUUID(in);
                            long amount = in.readLong();
                            this.respondTakeMoneyRequest(id, LotterySixPlugin.takeMoneyOnline(uuid, amount));
                            break;
                        }
                        case 6: {
                            Scheduler.runTask((Plugin)LotterySixPlugin.plugin, () -> LotterySixPlugin.forceCloseAllGui());
                            break;
                        }
                        case 7: {
                            LotterySixAction action = LotterySixAction.values()[in.readInt()];
                            Bukkit.getPluginManager().callEvent((Event)new LotterySixEvent(LotterySixPlugin.getInstance(), action));
                            break;
                        }
                        case 8: {
                            UUID uuid = DataTypeIO.readUUID(in);
                            LotteryPlayer player = this.instance.getLotteryPlayerManager().getLotteryPlayer(uuid);
                            if (player == null) break;
                            long price = in.readLong();
                            AddBetResult result = AddBetResult.values()[in.readInt()];
                            BetNumbers numbers = GSON.fromJson(DataTypeIO.readString(in, StandardCharsets.UTF_8), BetNumbers.class);
                            Bukkit.getPluginManager().callEvent((Event)new PlayerBetEvent(player, numbers, price, result));
                            break;
                        }
                        case 9: {
                            boolean lock = in.readBoolean();
                            this.instance.setGameLocked(lock);
                            break;
                        }
                        case 10: {
                            this.instance.reloadConfig();
                            if (LotterySixPlugin.discordSRVHook != null) {
                                LotterySixPlugin.discordSRVHook.reload();
                            }
                            if (LotterySixPlugin.activeBossBar == null) break;
                            Scheduler.runTask((Plugin)LotterySixPlugin.plugin, () -> {
                                for (Player player : Bukkit.getOnlinePlayers()) {
                                    if (LotterySixPlugin.activeBossBar.getPlayers().contains(player)) continue;
                                    LotterySixPlugin.activeBossBar.addPlayer(player);
                                }
                            });
                            break;
                        }
                        case 11: {
                            this.respondPastGameSyncCheck();
                            break;
                        }
                        case 12: {
                            boolean shouldSave = false;
                            int size = in.readInt();
                            if (size > 0) {
                                for (int i4 = 0; i4 < size; ++i4) {
                                    UUID gameId = DataTypeIO.readUUID(in);
                                    Optional<CompletedLotterySixGameIndex> optGame = this.instance.getCompletedGames().indexStream().filter(each -> each.getGameId().equals(gameId)).findFirst();
                                    if (optGame.isPresent()) {
                                        CompletedLotterySixGame game = this.instance.getCompletedGames().get(optGame.get());
                                        PluginMessageHandler.gsonOfInstance(game).fromJson(DataTypeIO.readString(in, StandardCharsets.UTF_8), CompletedLotterySixGame.class);
                                        this.instance.getCompletedGames().setGameDirty(game.getGameId());
                                        continue;
                                    }
                                    this.instance.getCompletedGames().add(GSON.fromJson(DataTypeIO.readString(in, StandardCharsets.UTF_8), CompletedLotterySixGame.class));
                                }
                                if (this.instance.getCompletedGames().size() > 0) {
                                    this.instance.getCompletedGames().indexSort(Comparator.reverseOrder());
                                }
                                shouldSave = true;
                            }
                            if ((size = in.readInt()) > 0) {
                                HashSet<UUID> notExist = new HashSet<UUID>();
                                for (int i5 = 0; i5 < size; ++i5) {
                                    notExist.add(DataTypeIO.readUUID(in));
                                }
                                for (CompletedLotterySixGameIndex gameIndex : this.instance.getCompletedGames().indexIterable()) {
                                    if (!notExist.contains(gameIndex.getGameId())) continue;
                                    this.instance.getCompletedGames().remove(gameIndex);
                                }
                                shouldSave = true;
                            }
                            if (!shouldSave) break;
                            this.instance.requestSave(false);
                            break;
                        }
                        case 13: {
                            UUID uuid = DataTypeIO.readUUID(in);
                            int interactionId = in.readInt();
                            String input = in.readBoolean() ? DataTypeIO.readString(in, StandardCharsets.UTF_8) : null;
                            Scheduler.runTask((Plugin)LotterySixPlugin.plugin, () -> {
                                Player player = Bukkit.getPlayer((UUID)uuid);
                                if (player != null) {
                                    if (input == null) {
                                        LotterySixPlugin.getGuiProvider().getMainMenu(player).show((HumanEntity)player);
                                    } else {
                                        PlayableLotterySixGame game = this.instance.getCurrentGame();
                                        if (game != null) {
                                            Pair<Stream<? extends BetNumbersBuilder>, BetNumbersType> pair = BetNumbersBuilder.fromString(1, this.instance.numberOfChoices, input);
                                            if (pair == null) {
                                                player.sendMessage(this.instance.messageInvalidBetNumbers);
                                            } else {
                                                LotterySixPlugin.getGuiProvider().getNumberConfirm(player, game, pair.getFirst().map(e -> e.build()).collect(Collectors.toList()), pair.getSecond()).show((HumanEntity)player);
                                            }
                                        } else {
                                            player.sendMessage(LotterySixPlugin.getInstance().messageNoGameRunning);
                                        }
                                    }
                                }
                                this.inventoryOpenedResponse(interactionId);
                            }, (Entity)Bukkit.getPlayer((UUID)uuid));
                            break;
                        }
                        case 14: {
                            UUID uuid = DataTypeIO.readUUID(in);
                            AddBetResult result = AddBetResult.values()[in.readInt()];
                            long price = in.readLong();
                            Scheduler.runTask((Plugin)LotterySixPlugin.plugin, () -> {
                                Player player = Bukkit.getPlayer((UUID)uuid);
                                if (player != null) {
                                    switch (result) {
                                        case SUCCESS: {
                                            player.sendMessage(this.instance.messageBetPlaced.replace("{Price}", StringUtils.formatComma(price)));
                                            break;
                                        }
                                        case GAME_LOCKED: {
                                            player.sendMessage(this.instance.messageGameLocked.replace("{Price}", StringUtils.formatComma(price)));
                                            break;
                                        }
                                        case NOT_ENOUGH_MONEY: {
                                            player.sendMessage(this.instance.messageNotEnoughMoney.replace("{Price}", StringUtils.formatComma(price)));
                                            break;
                                        }
                                        case LIMIT_SELF: {
                                            player.sendMessage(this.instance.messageBetLimitReachedSelf.replace("{Price}", StringUtils.formatComma(price)));
                                            break;
                                        }
                                        case LIMIT_PERMISSION: {
                                            player.sendMessage(this.instance.messageBetLimitReachedPermission.replace("{Price}", StringUtils.formatComma(price)));
                                            break;
                                        }
                                        case LIMIT_CHANCE_PER_SELECTION: {
                                            player.sendMessage(this.instance.messageBetLimitMaximumChancePerSelection.replace("{Price}", StringUtils.formatComma(price)));
                                            break;
                                        }
                                        case ACCOUNT_SUSPENDED: {
                                            long time = this.instance.getLotteryPlayerManager().getLotteryPlayer(player.getUniqueId()).getPreference(PlayerPreferenceKey.SUSPEND_ACCOUNT_UNTIL, Long.TYPE);
                                            player.sendMessage(this.instance.messageBettingAccountSuspended.replace("{Date}", this.instance.dateFormat.format(new Date(time))).replace("{Price}", StringUtils.formatComma(price)));
                                            break;
                                        }
                                    }
                                    if (result.isSuccess()) {
                                        Scheduler.runTaskLater((Plugin)LotterySixPlugin.plugin, () -> LotterySixPlugin.getGuiProvider().checkReopen((HumanEntity)player), 5L);
                                    }
                                }
                            }, (Entity)Bukkit.getPlayer((UUID)uuid));
                            break;
                        }
                        case 15: {
                            UUID uuid = DataTypeIO.readUUID(in);
                            LotteryPlayer lotteryPlayer = this.instance.getLotteryPlayerManager().getLotteryPlayer(uuid);
                            JsonObject json = GSON.fromJson(DataTypeIO.readString(in, StandardCharsets.UTF_8), JsonObject.class);
                            EnumMap<PlayerPreferenceKey, Object> preferences = new EnumMap<PlayerPreferenceKey, Object>(PlayerPreferenceKey.class);
                            JsonObject preferencesJson = json.getAsJsonObject("preferences");
                            for (PlayerPreferenceKey key : PlayerPreferenceKey.values()) {
                                JsonElement element = preferencesJson.get(key.name());
                                if (element == null) continue;
                                preferences.put(key, GSON.fromJson(element, key.getValueTypeClass()));
                            }
                            JsonObject statsJson = json.getAsJsonObject("stats");
                            EnumMap<PlayerStatsKey, Object> stats = new EnumMap<PlayerStatsKey, Object>(PlayerStatsKey.class);
                            for (PlayerStatsKey key : PlayerStatsKey.values()) {
                                JsonElement element = statsJson.get(key.name());
                                if (element == null) continue;
                                stats.put(key, GSON.fromJson(element, key.getValueTypeClass()));
                            }
                            List multipleDrawPlayerBets = (List)GSON.fromJson((JsonElement)json.getAsJsonArray("multipleDrawPlayerBets"), new TypeToken<ArrayList<PlayerBets>>(){}.getType());
                            lotteryPlayer.bulkSet(preferences, stats, multipleDrawPlayerBets);
                            break;
                        }
                        case 16: {
                            UUID uuid = DataTypeIO.readUUID(in);
                            Scheduler.runTask((Plugin)LotterySixPlugin.plugin, () -> {
                                Player player = Bukkit.getPlayer((UUID)uuid);
                                if (player != null) {
                                    Bukkit.dispatchCommand((CommandSender)player, (String)"lotterysix update");
                                }
                            });
                            break;
                        }
                        case 17: {
                            if (LotterySixPlugin.activeBossBar == null) break;
                            String nullableMessage = in.readBoolean() ? DataTypeIO.readString(in, StandardCharsets.UTF_8) : null;
                            String color = DataTypeIO.readString(in, StandardCharsets.UTF_8);
                            String style = DataTypeIO.readString(in, StandardCharsets.UTF_8);
                            double progress = in.readDouble();
                            UUID gameId = in.readBoolean() ? DataTypeIO.readUUID(in) : null;
                            Scheduler.runTask((Plugin)LotterySixPlugin.plugin, () -> {
                                ILotterySixGame game;
                                String message = nullableMessage;
                                if (message == null) {
                                    LotterySixPlugin.activeBossBar.setVisible(false);
                                    return;
                                }
                                LotterySixPlugin.activeBossBar.setVisible(true);
                                LotterySixPlugin.activeBossBar.setProgress(progress);
                                LotterySixPlugin.activeBossBar.setColor(BarColor.valueOf((String)color));
                                LotterySixPlugin.activeBossBar.setStyle(BarStyle.valueOf((String)style));
                                ILotterySixGame iLotterySixGame = game = gameId == null ? null : this.instance.getGame(gameId);
                                if (game instanceof PlayableLotterySixGame) {
                                    message = LotteryUtils.formatPlaceholders(null, message, this.instance, (PlayableLotterySixGame)game);
                                } else if (game instanceof CompletedLotterySixGame) {
                                    message = LotteryUtils.formatPlaceholders(null, message, this.instance, (CompletedLotterySixGame)game);
                                }
                                LotterySixPlugin.activeBossBar.setTitle(message);
                            });
                            break;
                        }
                        case 18: {
                            UUID gameId = DataTypeIO.readUUID(in);
                            PlayableLotterySixGame game = this.instance.getCurrentGame();
                            if (game == null || !game.getGameId().equals(gameId)) break;
                            int size = in.readInt();
                            for (int i6 = 0; i6 < size; ++i6) {
                                PlayerBets bet = GSON.fromJson(DataTypeIO.readString(in, StandardCharsets.UTF_8), PlayerBets.class);
                                if (game.getBet(bet.getBetId()) != null) continue;
                                game.addBet(bet);
                            }
                            break;
                        }
                    }
                    this.lastReceivedSequence.updateAndGet(i -> Math.max(i, sequenceId));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendData(int packetId, byte[] data) {
        Scheduler.runTaskAsynchronously((Plugin)LotterySixPlugin.plugin, () -> {
            Collection players = Bukkit.getOnlinePlayers();
            if (players.isEmpty()) {
                return;
            }
            Player player = (Player)players.stream().skip(this.random.nextInt(players.size())).findAny().get();
            int sequenceId = this.sequenceCounter.getAndIncrement();
            try {
                byte[][] dataArray = ArrayUtils.divideArray(data, 32700);
                for (int i = 0; i < dataArray.length; ++i) {
                    byte[] chunk = dataArray[i];
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    DataOutputStream out = new DataOutputStream(outputStream);
                    out.writeInt(sequenceId);
                    out.writeShort(packetId);
                    out.writeBoolean(i == dataArray.length - 1);
                    out.write(chunk);
                    player.sendPluginMessage((Plugin)LotterySixPlugin.plugin, "lotterysix:main", outputStream.toByteArray());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void requestAddBet(String name, UUID player, long bet, BetUnitType unitType, BetNumbers chosenNumbers, int multipleDraw) {
        this.requestAddBet(name, player, bet, unitType, Collections.singleton(chosenNumbers), multipleDraw);
    }

    public void requestAddBet(String name, UUID player, long bet, BetUnitType unitType, Collection<BetNumbers> chosenNumbers, int multipleDraw) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            DataTypeIO.writeString(out, name, StandardCharsets.UTF_8);
            DataTypeIO.writeUUID(out, player);
            out.writeLong(bet);
            out.writeInt(unitType.ordinal());
            out.writeInt(chosenNumbers.size());
            for (BetNumbers numbers : chosenNumbers) {
                DataTypeIO.writeString(out, GSON.toJson(numbers), StandardCharsets.UTF_8);
            }
            out.writeInt(multipleDraw);
            this.sendData(0, outputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void respondTakeMoneyRequest(int id, boolean result) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            out.writeInt(id);
            out.writeBoolean(result);
            this.sendData(1, outputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void respondPastGameSyncCheck() {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            out.writeInt(this.instance.getCompletedGames().size());
            for (CompletedLotterySixGameIndex gameIndex : this.instance.getCompletedGames().indexIterable()) {
                DataTypeIO.writeUUID(out, gameIndex.getGameId());
            }
            this.sendData(2, outputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updatePlayerPreference(LotteryPlayer player, PlayerPreferenceKey key, Object value) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            DataTypeIO.writeUUID(out, player.getPlayer());
            out.writeInt(key.ordinal());
            DataTypeIO.writeString(out, value.toString(), StandardCharsets.UTF_8);
            this.sendData(3, outputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void resetPlayerPreference(LotteryPlayer player, PlayerPreferenceKey key) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            DataTypeIO.writeUUID(out, player.getPlayer());
            out.writeInt(key.ordinal());
            this.sendData(4, outputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void updatePlayerStats(LotteryPlayer player, PlayerStatsKey key, Object value) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            DataTypeIO.writeUUID(out, player.getPlayer());
            out.writeInt(key.ordinal());
            DataTypeIO.writeString(out, GSON.toJson(value, key.getValueTypeClass()), StandardCharsets.UTF_8);
            this.sendData(5, outputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void requestCurrentGameBets(UUID gameId, Set<UUID> betIds) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            DataTypeIO.writeUUID(out, gameId);
            out.writeInt(betIds.size());
            for (UUID betId : betIds) {
                DataTypeIO.writeUUID(out, betId);
            }
            this.sendData(6, outputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void inventoryOpenedResponse(int interactionId) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(outputStream);
            out.writeInt(interactionId);
            this.sendData(7, outputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

