/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.proxy.bungee;

import com.google.common.collect.Collections2;
import com.loohp.lotterysix.config.Config;
import com.loohp.lotterysix.game.LotterySix;
import com.loohp.lotterysix.game.lottery.ILotterySixGame;
import com.loohp.lotterysix.game.objects.AddBetResult;
import com.loohp.lotterysix.game.objects.BossBarInfo;
import com.loohp.lotterysix.game.objects.LotterySixAction;
import com.loohp.lotterysix.game.objects.PlayerBets;
import com.loohp.lotterysix.game.objects.PlayerStatsKey;
import com.loohp.lotterysix.game.objects.betnumbers.BetNumbers;
import com.loohp.lotterysix.game.player.LotteryPlayer;
import com.loohp.lotterysix.proxy.bungee.CommandsBungee;
import com.loohp.lotterysix.proxy.bungee.DebugBungee;
import com.loohp.lotterysix.proxy.bungee.Metrics;
import com.loohp.lotterysix.proxy.bungee.PluginMessageBungee;
import com.loohp.lotterysix.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class LotterySixBungee
extends Plugin
implements Listener {
    public static final int BSTATS_PLUGIN_ID = 17556;
    public static final String CONFIG_ID = "config";
    public static LotterySixBungee plugin;
    private static LotterySix instance;
    private static PluginMessageBungee pluginMessageBungee;
    private static volatile BossBarInfo latestBossBar;
    private static volatile ILotterySixGame latestBossBarGame;

    public void onEnable() {
        plugin = this;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        Metrics metrics = new Metrics(this, 17556);
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)this);
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new DebugBungee());
        try {
            Config.loadConfig(CONFIG_ID, new File(this.getDataFolder(), "config.yml"), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("config.yml"), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("config.yml"), true);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new CommandsBungee());
        pluginMessageBungee = new PluginMessageBungee(null);
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)pluginMessageBungee);
        this.getProxy().registerChannel("lotterysix:main");
        instance = new LotterySix(false, this.getDataFolder(), CONFIG_ID, (p, a) -> LotterySixBungee.takeMoneyOnline(p, a), (p, a) -> LotterySixBungee.giveMoneyNow(p, a), p -> LotterySixBungee.notifyOfflineBalanceChange(p), (uuid, permission) -> {
            ProxiedPlayer player = this.getProxy().getPlayer(uuid);
            if (player != null) {
                return player.hasPermission(permission);
            }
            return false;
        }, lock -> pluginMessageBungee.updateLockState((boolean)lock), () -> Collections2.transform((Collection)this.getProxy().getPlayers(), p -> p.getUniqueId()), (uuid, message, hover, game) -> {
            ProxiedPlayer player = this.getProxy().getPlayer(uuid);
            if (player != null) {
                LotterySixBungee.sendFormattedMessage(player, game, message, hover);
            }
        }, (uuid, message, hover, game) -> {
            ProxiedPlayer player = this.getProxy().getPlayer(uuid);
            if (player != null) {
                LotterySixBungee.sendFormattedTitle(player, game, message, 10, 100, 20);
            }
        }, (uuid, result, price, bets) -> {
            ProxiedPlayer player = this.getProxy().getPlayer(uuid);
            if (player != null) {
                pluginMessageBungee.addBetResult(player, result, price);
            }
            for (PlayerBets bet : bets) {
                LotterySixBungee.callPlayerBetEvent(uuid, bet.getChosenNumbers(), price, result);
            }
        }, playerBets -> pluginMessageBungee.updateCurrentGameData(), action -> {
            LotterySixBungee.callLotterySixEvent(action);
            LotterySixBungee.forceCloseAllGui();
        }, lotteryPlayer -> pluginMessageBungee.syncPlayerData((LotteryPlayer)lotteryPlayer), message -> ProxyServer.getInstance().getConsole().sendMessage(message), (bossBarInfo, game) -> {
            latestBossBar = bossBarInfo;
            latestBossBarGame = game;
            pluginMessageBungee.updateBossBar((BossBarInfo)bossBarInfo, (ILotterySixGame)game);
        });
        instance.reloadConfig();
        pluginMessageBungee.setInstance(instance);
        new Timer().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                pluginMessageBungee.updateCurrentGameData();
                pluginMessageBungee.updateLockState(instance.isGameLocked());
            }
        }, 0L, 10000L);
        this.getProxy().getConsole().sendMessage(ChatColor.GREEN + "[LotterySix] LotterySix (Bungeecord) has been Enabled!");
    }

    public void onDisable() {
        instance.close();
        this.getProxy().getConsole().sendMessage(ChatColor.RED + "[LotterySix] LotterySix (Bungeecord) has been Disabled!");
    }

    public static LotterySix getInstance() {
        return instance;
    }

    public static PluginMessageBungee getPluginMessageHandler() {
        return pluginMessageBungee;
    }

    public static void callLotterySixEvent(LotterySixAction action) {
        pluginMessageBungee.updateCurrentGameData();
        pluginMessageBungee.updateLastResultData();
        pluginMessageBungee.updateLockState(LotterySixBungee.getInstance().isGameLocked());
        pluginMessageBungee.callLotterySixEvent(action);
    }

    public static void callPlayerBetEvent(UUID uuid, BetNumbers numbers, long price, AddBetResult result) {
        pluginMessageBungee.updateCurrentGameData();
        pluginMessageBungee.callPlayerBetEvent(uuid, numbers, price, result);
    }

    public static void sendFormattedTitle(ProxiedPlayer player, ILotterySixGame game, String title, int fadeIn, int stay, int fadeOut) {
        pluginMessageBungee.sendFormattedTitle(player, game, title, fadeIn, stay, fadeOut);
    }

    public static void sendFormattedMessage(ProxiedPlayer player, ILotterySixGame game, String message, String hover) {
        pluginMessageBungee.sendFormattedMessage(player, game, message, hover);
    }

    public static boolean giveMoneyNow(UUID uuid, long amount) {
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(uuid);
        if (player == null) {
            return false;
        }
        pluginMessageBungee.giveMoney(player, amount);
        return true;
    }

    public static boolean takeMoneyOnline(UUID uuid, long amount) {
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(uuid);
        if (player == null) {
            return false;
        }
        try {
            return pluginMessageBungee.takeMoney(player, amount).get(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void forceCloseAllGui() {
        pluginMessageBungee.forceCloseAllGui();
    }

    public static void notifyOfflineBalanceChange(UUID uuid) {
        LotterySixBungee.notifyOfflineBalanceChange(instance.getLotteryPlayerManager().getLotteryPlayer(uuid));
    }

    public static void notifyOfflineBalanceChange(LotteryPlayer lotteryPlayer) {
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(lotteryPlayer.getPlayer());
        if (player != null) {
            Long money = lotteryPlayer.getStats(PlayerStatsKey.PENDING_TRANSACTION, Long.TYPE);
            boolean notifyAnyway = false;
            if (money != null && money > 0L) {
                lotteryPlayer.setStats(PlayerStatsKey.PENDING_TRANSACTION, 0L);
                lotteryPlayer.updateStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE, i -> i + money);
                notifyAnyway = true;
            }
            long changed = lotteryPlayer.getStats(PlayerStatsKey.NOTIFY_BALANCE_CHANGE, Long.TYPE);
            if (notifyAnyway || changed != 0L) {
                lotteryPlayer.setStats(PlayerStatsKey.NOTIFY_BALANCE_CHANGE, 0L);
                pluginMessageBungee.syncPlayerData(lotteryPlayer);
                player.sendMessage(LotterySixBungee.instance.messageNotifyBalanceChange.replace("{Amount}", StringUtils.formatComma(changed)));
            }
        }
    }

    @EventHandler
    public void onJoin(PostLoginEvent event) {
        ProxiedPlayer player = event.getPlayer();
        this.getProxy().getScheduler().runAsync((Plugin)this, () -> instance.getLotteryPlayerManager().loadLotteryPlayer(player.getUniqueId(), true));
    }

    @EventHandler
    public void onConnected(final ServerConnectedEvent event) {
        final ProxiedPlayer player = event.getPlayer();
        new Timer().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (player.getServer() != null) {
                    LotteryPlayer lotteryPlayer = instance.getLotteryPlayerManager().getLotteryPlayer(player.getUniqueId());
                    LotterySixBungee.notifyOfflineBalanceChange(lotteryPlayer);
                    pluginMessageBungee.updateCurrentGameData(event.getServer().getInfo());
                    pluginMessageBungee.requestPastGameSyncCheck(event.getServer().getInfo());
                    pluginMessageBungee.syncPlayerData(lotteryPlayer);
                    pluginMessageBungee.updateBossBar(latestBossBar, latestBossBarGame);
                    this.cancel();
                }
            }
        }, 0L, 200L);
    }

    @EventHandler
    public void onQuit(PlayerDisconnectEvent event) {
        this.getProxy().getScheduler().runAsync((Plugin)this, () -> instance.getLotteryPlayerManager().unloadLotteryPlayer(event.getPlayer().getUniqueId(), true));
    }

    static {
        latestBossBar = BossBarInfo.CLEAR;
        latestBossBarGame = null;
    }
}

