/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.proxy.velocity;

import com.google.common.collect.Collections2;
import com.google.inject.Inject;
import com.loohp.lotterysix.config.Config;
import com.loohp.lotterysix.game.LotterySix;
import com.loohp.lotterysix.game.lottery.ILotterySixGame;
import com.loohp.lotterysix.game.objects.AddBetResult;
import com.loohp.lotterysix.game.objects.BossBarInfo;
import com.loohp.lotterysix.game.objects.LotterySixAction;
import com.loohp.lotterysix.game.objects.PlayerBets;
import com.loohp.lotterysix.game.objects.PlayerStatsKey;
import com.loohp.lotterysix.game.objects.betnumbers.BetNumbers;
import com.loohp.lotterysix.game.player.LotteryPlayer;
import com.loohp.lotterysix.libs.com.google.gson.Gson;
import com.loohp.lotterysix.libs.com.google.gson.GsonBuilder;
import com.loohp.lotterysix.libs.com.google.gson.JsonObject;
import com.loohp.lotterysix.proxy.velocity.CommandsVelocity;
import com.loohp.lotterysix.proxy.velocity.DebugVelocity;
import com.loohp.lotterysix.proxy.velocity.LSChannelIdentifier;
import com.loohp.lotterysix.proxy.velocity.Metrics;
import com.loohp.lotterysix.proxy.velocity.PluginMessageVelocity;
import com.loohp.lotterysix.proxy.velocity.VelocityPluginDescription;
import com.loohp.lotterysix.utils.StringUtils;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.slf4j.Logger;

public class LotterySixVelocity {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final int BSTATS_PLUGIN_ID = 21787;
    public static final String CONFIG_ID = "config";
    public static ProxyServer proxyServer;
    public static LotterySixVelocity plugin;
    private static LotterySix instance;
    private static PluginMessageVelocity pluginMessageVelocity;
    private static volatile BossBarInfo latestBossBar;
    private static volatile ILotterySixGame latestBossBarGame;
    private final Logger logger;
    private final File dataFolder;
    private final Metrics.Factory metricsFactory;
    private VelocityPluginDescription description;

    @Inject
    public LotterySixVelocity(ProxyServer server, Logger logger, Metrics.Factory metricsFactory, @DataDirectory Path dataDirectory) {
        proxyServer = server;
        this.logger = logger;
        this.metricsFactory = metricsFactory;
        this.dataFolder = dataDirectory.toFile();
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        plugin = this;
        JsonObject json = GSON.fromJson((Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("velocity-plugin.json"), StandardCharsets.UTF_8), JsonObject.class);
        this.description = new VelocityPluginDescription(json);
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        Metrics metrics = this.metricsFactory.make(this, 21787);
        proxyServer.getEventManager().register((Object)this, (Object)new DebugVelocity());
        try {
            Config.loadConfig(CONFIG_ID, new File(this.getDataFolder(), "config.yml"), this.getClass().getClassLoader().getResourceAsStream("config.yml"), this.getClass().getClassLoader().getResourceAsStream("config.yml"), true);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        CommandManager commandManager = proxyServer.getCommandManager();
        CommandMeta commandMeta = commandManager.metaBuilder("lotterysix").aliases(new String[]{"ls", "lottery"}).plugin((Object)this).build();
        commandManager.register(commandMeta, (Command)new CommandsVelocity());
        pluginMessageVelocity = new PluginMessageVelocity(null);
        proxyServer.getEventManager().register((Object)this, (Object)pluginMessageVelocity);
        proxyServer.getChannelRegistrar().register(new ChannelIdentifier[]{LSChannelIdentifier.INSTANCE});
        instance = new LotterySix(false, this.getDataFolder(), CONFIG_ID, (p, a) -> LotterySixVelocity.takeMoneyOnline(p, a), (p, a) -> LotterySixVelocity.giveMoneyNow(p, a), p -> LotterySixVelocity.notifyOfflineBalanceChange(p), (uuid, permission) -> this.getServer().getPlayer(uuid).map(value -> value.hasPermission(permission)).orElse(false), lock -> pluginMessageVelocity.updateLockState((boolean)lock), () -> Collections2.transform((Collection)this.getServer().getAllPlayers(), p -> p.getUniqueId()), (uuid, message, hover, game) -> this.getServer().getPlayer(uuid).ifPresent(player -> LotterySixVelocity.sendFormattedMessage(player, game, message, hover)), (uuid, message, hover, game) -> this.getServer().getPlayer(uuid).ifPresent(value -> LotterySixVelocity.sendFormattedTitle(value, game, message, 10, 100, 20)), (uuid, result, price, bets) -> {
            this.getServer().getPlayer(uuid).ifPresent(value -> pluginMessageVelocity.addBetResult((Player)value, result, price));
            for (PlayerBets bet : bets) {
                LotterySixVelocity.callPlayerBetEvent(uuid, bet.getChosenNumbers(), price, result);
            }
        }, playerBets -> pluginMessageVelocity.updateCurrentGameData(), action -> {
            LotterySixVelocity.callLotterySixEvent(action);
            LotterySixVelocity.forceCloseAllGui();
        }, lotteryPlayer -> pluginMessageVelocity.syncPlayerData((LotteryPlayer)lotteryPlayer), message -> this.getServer().getConsoleCommandSource().sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(message)), (bossBarInfo, game) -> {
            latestBossBar = bossBarInfo;
            latestBossBarGame = game;
            pluginMessageVelocity.updateBossBar((BossBarInfo)bossBarInfo, (ILotterySixGame)game);
        });
        instance.reloadConfig();
        pluginMessageVelocity.setInstance(instance);
        new Timer().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                pluginMessageVelocity.updateCurrentGameData();
                pluginMessageVelocity.updateLockState(instance.isGameLocked());
            }
        }, 0L, 10000L);
        proxyServer.getConsoleCommandSource().sendMessage(Component.text((String)"[LotterySix] LotterySix (Velocity) has been enabled!").color((TextColor)NamedTextColor.GREEN));
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        instance.close();
        proxyServer.getConsoleCommandSource().sendMessage(Component.text((String)"[LotterySix] LotterySix (Velocity) has been disabled!").color((TextColor)NamedTextColor.RED));
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public VelocityPluginDescription getDescription() {
        return this.description;
    }

    public ProxyServer getServer() {
        return proxyServer;
    }

    public static LotterySix getInstance() {
        return instance;
    }

    public static PluginMessageVelocity getPluginMessageHandler() {
        return pluginMessageVelocity;
    }

    public static void callLotterySixEvent(LotterySixAction action) {
        pluginMessageVelocity.updateCurrentGameData();
        pluginMessageVelocity.updateLastResultData();
        pluginMessageVelocity.updateLockState(LotterySixVelocity.getInstance().isGameLocked());
        pluginMessageVelocity.callLotterySixEvent(action);
    }

    public static void callPlayerBetEvent(UUID uuid, BetNumbers numbers, long price, AddBetResult result) {
        pluginMessageVelocity.updateCurrentGameData();
        pluginMessageVelocity.callPlayerBetEvent(uuid, numbers, price, result);
    }

    public static void sendFormattedTitle(Player player, ILotterySixGame game, String title, int fadeIn, int stay, int fadeOut) {
        pluginMessageVelocity.sendFormattedTitle(player, game, title, fadeIn, stay, fadeOut);
    }

    public static void sendFormattedMessage(Player player, ILotterySixGame game, String message, String hover) {
        pluginMessageVelocity.sendFormattedMessage(player, game, message, hover);
    }

    public static boolean giveMoneyNow(UUID uuid, long amount) {
        Player player = proxyServer.getPlayer(uuid).orElse(null);
        if (player == null) {
            return false;
        }
        pluginMessageVelocity.giveMoney(player, amount);
        return true;
    }

    public static boolean takeMoneyOnline(UUID uuid, long amount) {
        Player player = proxyServer.getPlayer(uuid).orElse(null);
        if (player == null) {
            return false;
        }
        try {
            return pluginMessageVelocity.takeMoney(player, amount).get(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void forceCloseAllGui() {
        pluginMessageVelocity.forceCloseAllGui();
    }

    public static void notifyOfflineBalanceChange(UUID uuid) {
        LotterySixVelocity.notifyOfflineBalanceChange(instance.getLotteryPlayerManager().getLotteryPlayer(uuid));
    }

    public static void notifyOfflineBalanceChange(LotteryPlayer lotteryPlayer) {
        Player player = proxyServer.getPlayer(lotteryPlayer.getPlayer()).orElse(null);
        if (player != null) {
            Long money = lotteryPlayer.getStats(PlayerStatsKey.PENDING_TRANSACTION, Long.TYPE);
            boolean notifyAnyway = false;
            if (money != null && money > 0L) {
                lotteryPlayer.setStats(PlayerStatsKey.PENDING_TRANSACTION, 0L);
                lotteryPlayer.updateStats(PlayerStatsKey.ACCOUNT_BALANCE, Long.TYPE, i -> i + money);
                notifyAnyway = true;
            }
            long changed = lotteryPlayer.getStats(PlayerStatsKey.NOTIFY_BALANCE_CHANGE, Long.TYPE);
            if (notifyAnyway || changed != 0L) {
                lotteryPlayer.setStats(PlayerStatsKey.NOTIFY_BALANCE_CHANGE, 0L);
                pluginMessageVelocity.syncPlayerData(lotteryPlayer);
                player.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(LotterySixVelocity.instance.messageNotifyBalanceChange.replace("{Amount}", StringUtils.formatComma(changed))));
            }
        }
    }

    @Subscribe
    public void onJoin(PostLoginEvent event) {
        Player player = event.getPlayer();
        proxyServer.getScheduler().buildTask((Object)this, () -> instance.getLotteryPlayerManager().loadLotteryPlayer(player.getUniqueId(), true));
    }

    @Subscribe
    public void onConnected(final ServerPostConnectEvent event) {
        final Player player = event.getPlayer();
        new Timer().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Optional opt = event.getPlayer().getCurrentServer();
                if (opt.isPresent()) {
                    LotteryPlayer lotteryPlayer = instance.getLotteryPlayerManager().getLotteryPlayer(player.getUniqueId());
                    LotterySixVelocity.notifyOfflineBalanceChange(lotteryPlayer);
                    pluginMessageVelocity.updateCurrentGameData(((ServerConnection)opt.get()).getServer());
                    pluginMessageVelocity.requestPastGameSyncCheck(((ServerConnection)opt.get()).getServer());
                    pluginMessageVelocity.syncPlayerData(lotteryPlayer);
                    pluginMessageVelocity.updateBossBar(latestBossBar, latestBossBarGame);
                    this.cancel();
                }
            }
        }, 0L, 200L);
    }

    @Subscribe
    public void onQuit(DisconnectEvent event) {
        proxyServer.getScheduler().buildTask((Object)this, () -> instance.getLotteryPlayerManager().unloadLotteryPlayer(event.getPlayer().getUniqueId(), true));
    }

    static {
        plugin = null;
        latestBossBar = BossBarInfo.CLEAR;
        latestBossBarGame = null;
    }
}

