/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ChatColorUtils {
    public static char COLOR_CHAR = (char)167;
    public static Set<Character> VALID_COLORS = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('r'))));
    public static String RED = COLOR_CHAR + "c";
    public static String AQUA = COLOR_CHAR + "b";
    public static String GREEN = COLOR_CHAR + "a";
    private static final String[] NUMBER_COLOR = new String[]{RED, RED, AQUA, AQUA, GREEN, GREEN, RED, RED, AQUA, GREEN, RED, RED, AQUA, AQUA, GREEN, GREEN, RED, RED, GREEN, GREEN, RED, RED, AQUA, AQUA, GREEN, GREEN, RED, AQUA, GREEN, GREEN, RED, RED, AQUA, AQUA, GREEN, GREEN, AQUA, AQUA, GREEN, GREEN, RED, RED, AQUA, AQUA, GREEN, RED, AQUA, AQUA, GREEN, GREEN, RED, RED, AQUA, AQUA};

    public static String applyNumberColor(int i) {
        return ChatColorUtils.getNumberColor(i) + i;
    }

    public static String getNumberColor(int i) {
        return NUMBER_COLOR[(i - 1) % NUMBER_COLOR.length];
    }

    public static String translateAlternateColorCodes(char code, String text) {
        if (text == null) {
            return null;
        }
        if (text.length() < 2) {
            return text;
        }
        for (int i = 0; i < text.length() - 1; ++i) {
            if (text.charAt(i) != code) continue;
            if (text.charAt(i + 1) == 'x' && text.length() > i + 14) {
                String section = text.substring(i, i + 14);
                String translated = section.replace(code, COLOR_CHAR);
                text = text.replace(section, translated);
                continue;
            }
            if (!VALID_COLORS.contains(Character.valueOf(text.charAt(i + 1)))) continue;
            text = text.substring(0, i) + COLOR_CHAR + text.substring(i + 1);
        }
        return text;
    }
}

