/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.utils;

import java.math.BigInteger;
import java.util.stream.LongStream;

public class MathUtils {
    public static long followRound(long follow, long value) {
        return MathUtils.followRound(follow, value, true);
    }

    private static long followRound(long follow, long value, boolean tryAgain) {
        int i;
        int signNum = value < 0L ? -1 : 1;
        value = Math.abs(value);
        String str = Long.toString(Math.abs(follow));
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == '0'; --i) {
        }
        double d = Math.pow(10.0, str.length() - i - 1);
        if ((double)value < d) {
            if (!tryAgain) {
                new RuntimeException("Please report this to the LotterySix developer! (" + value + ")").printStackTrace();
                return value;
            }
            int valurStrLength = Long.toString(value).length();
            if (valurStrLength <= 1) {
                return value * (long)signNum;
            }
            return MathUtils.followRound((long)Math.pow(10.0, valurStrLength - 1), value * (long)signNum, false);
        }
        long result = (long)((double)Math.round((double)value / d) * d);
        return (result <= 0L ? value : result) * (long)signNum;
    }

    public static long followRoundDown(long follow, long value) {
        return MathUtils.followRoundDown(follow, value, true);
    }

    private static long followRoundDown(long follow, long value, boolean tryAgain) {
        int i;
        int signNum = value < 0L ? -1 : 1;
        value = Math.abs(value);
        String str = Long.toString(Math.abs(follow));
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == '0'; --i) {
        }
        double d = Math.pow(10.0, str.length() - i - 1);
        if ((double)value < d) {
            if (!tryAgain) {
                new RuntimeException("Please report this to the LotterySix developer! (" + value + ")").printStackTrace();
                return value;
            }
            int valurStrLength = Long.toString(value).length();
            if (valurStrLength <= 1) {
                return value * (long)signNum;
            }
            return MathUtils.followRoundDown((long)Math.pow(10.0, valurStrLength - 1), value * (long)signNum, false);
        }
        long result = (long)(Math.floor((double)value / d) * d);
        return (result <= 0L ? value : result) * (long)signNum;
    }

    public static BigInteger factorial(long number) {
        return LongStream.rangeClosed(1L, number).mapToObj(i -> BigInteger.valueOf(i)).reduce(BigInteger.ONE, (x, y) -> x.multiply((BigInteger)y));
    }

    public static double probabilityFormula(double a, double b) {
        if (a == b) {
            return 1.0;
        }
        double result = 1.0;
        while (b > 0.0) {
            result *= a / b;
            a -= 1.0;
            b -= 1.0;
        }
        return result;
    }

    public static long combinationsCount(int size, int bankerSize) {
        if (bankerSize <= 0) {
            if (size < 6) {
                return 0L;
            }
            if (size == 6) {
                return 1L;
            }
            return MathUtils.factorial(size).divide(MathUtils.factorial(size - 6).multiply(MathUtils.factorial(6L))).longValue();
        }
        if (size + bankerSize < 7) {
            return 0L;
        }
        return MathUtils.factorial(size).divide(MathUtils.factorial(size - (6 - bankerSize)).multiply(MathUtils.factorial(6 - bankerSize))).longValue();
    }
}

