/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.lotterysix.utils;

import com.loohp.lotterysix.LotterySixPlugin;
import com.loohp.lotterysix.libs.com.cryptomorin.xseries.XMaterial;
import com.loohp.lotterysix.utils.MCVersion;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SkinUtils {
    private static Class<?> craftPlayerClass;
    private static Class<?> nmsEntityPlayerClass;
    private static Method craftPlayerGetHandleMethod;
    private static Method nmsEntityPlayerGetProfileMethod;
    private static Method playerGetPlayerProfileMethod;
    private static Method mojangPropertyGetValueMethod;

    public static String getSkinValue(Player player) throws Exception {
        if (LotterySixPlugin.version.isNewerOrEqualTo(MCVersion.V1_19)) {
            Object playerProfile = playerGetPlayerProfileMethod.invoke((Object)player, new Object[0]);
            Method craftPlayerProfileGetPropertyMethod = playerProfile.getClass().getDeclaredMethod("getProperty", String.class);
            craftPlayerProfileGetPropertyMethod.setAccessible(true);
            Property property = (Property)craftPlayerProfileGetPropertyMethod.invoke(playerProfile, "textures");
            if (property == null) {
                return null;
            }
            return (String)mojangPropertyGetValueMethod.invoke((Object)property, new Object[0]);
        }
        Object playerNMS = craftPlayerGetHandleMethod.invoke(craftPlayerClass.cast(player), new Object[0]);
        GameProfile profile = (GameProfile)nmsEntityPlayerGetProfileMethod.invoke(playerNMS, new Object[0]);
        Collection textures = profile.getProperties().get((Object)"textures");
        if (textures == null || textures.isEmpty()) {
            return null;
        }
        return (String)mojangPropertyGetValueMethod.invoke(textures.iterator().next(), new Object[0]);
    }

    public static ItemStack getSkull(UUID uuid) {
        ItemStack head = XMaterial.PLAYER_HEAD.parseItem();
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (LotterySixPlugin.version.isNewerOrEqualTo(MCVersion.V1_12)) {
            meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)uuid));
        } else {
            meta.setOwner(uuid.toString());
        }
        head.setItemMeta((ItemMeta)meta);
        Player player = Bukkit.getPlayer((UUID)uuid);
        try {
            if (player != null) {
                String base64 = SkinUtils.getSkinValue(player);
                head = LotterySixPlugin.version.isNewerOrEqualTo(MCVersion.V1_20_5) ? Bukkit.getUnsafe().modifyItemStack(head, "minecraft:player_head[minecraft:profile={properties:[{name:\"textures\",value:\"" + base64 + "\"}]}]") : Bukkit.getUnsafe().modifyItemStack(head, "{SkullOwner: {Properties: {textures: [{Value: \"" + base64 + "\"}]}}}");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return head;
    }

    private static Class<?> getLegacyNMSClass(String path, String ... paths) throws ClassNotFoundException {
        String version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        if (!version.matches("v[0-9]+_[0-9]+_R[0-9]+")) {
            version = "";
        }
        try {
            return Class.forName(path.replace("%s", version).replaceAll("\\.+", "."));
        }
        catch (ClassNotFoundException e) {
            ClassNotFoundException error = e;
            for (String classpath : paths) {
                try {
                    return Class.forName(classpath.replace("%s", version).replaceAll("\\.+", "."));
                }
                catch (ClassNotFoundException e2) {
                    error = e2;
                }
            }
            throw error;
        }
    }

    @SafeVarargs
    private static <T extends AccessibleObject> T reflectiveLookup(Class<T> lookupType, ReflectionLookupSupplier<T> methodLookup, ReflectionLookupSupplier<T> ... methodLookups) throws ReflectiveOperationException {
        try {
            return (T)((AccessibleObject)methodLookup.lookup());
        }
        catch (ReflectiveOperationException e) {
            ReflectiveOperationException error = e;
            for (ReflectionLookupSupplier<T> supplier : methodLookups) {
                try {
                    return (T)((AccessibleObject)supplier.lookup());
                }
                catch (ReflectiveOperationException e2) {
                    error = e2;
                }
            }
            throw error;
        }
    }

    static {
        if (LotterySixPlugin.version.isOlderThan(MCVersion.V1_19)) {
            try {
                craftPlayerClass = SkinUtils.getLegacyNMSClass("org.bukkit.craftbukkit.%s.entity.CraftPlayer", new String[0]);
                nmsEntityPlayerClass = SkinUtils.getLegacyNMSClass("net.minecraft.server.%s.EntityPlayer", "net.minecraft.server.level.EntityPlayer");
                craftPlayerGetHandleMethod = craftPlayerClass.getMethod("getHandle", new Class[0]);
                nmsEntityPlayerGetProfileMethod = SkinUtils.reflectiveLookup(Method.class, () -> nmsEntityPlayerClass.getMethod("getProfile", new Class[0]), () -> {
                    Method method = nmsEntityPlayerClass.getMethod("fp", new Class[0]);
                    if (!method.getReturnType().equals(GameProfile.class)) {
                        throw new NoSuchMethodException();
                    }
                    return method;
                }, () -> {
                    Method method = nmsEntityPlayerClass.getMethod("fq", new Class[0]);
                    if (!method.getReturnType().equals(GameProfile.class)) {
                        throw new NoSuchMethodException();
                    }
                    return method;
                }, () -> nmsEntityPlayerClass.getMethod("fQ", new Class[0]));
                mojangPropertyGetValueMethod = Property.class.getMethod("getValue", new Class[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                mojangPropertyGetValueMethod = LotterySixPlugin.version.isNewerOrEqualTo(MCVersion.V1_20_2) ? Property.class.getMethod("value", new Class[0]) : Property.class.getMethod("getValue", new Class[0]);
                playerGetPlayerProfileMethod = Player.class.getMethod("getPlayerProfile", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }

    @FunctionalInterface
    private static interface ReflectionLookupSupplier<T> {
        public T lookup() throws ReflectiveOperationException;
    }
}

