/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.ears;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.unascribed.ears.EarsPlayerRenderState;
import com.unascribed.ears.NotRandom119;
import com.unascribed.ears.api.features.EarsFeatures;
import com.unascribed.ears.common.EarsFeaturesHolder;
import com.unascribed.ears.common.EarsFeaturesStorage;
import com.unascribed.ears.common.debug.EarsLog;
import com.unascribed.ears.common.render.EarsRenderDelegate;
import com.unascribed.ears.common.render.IndirectEarsRenderDelegate;
import com.unascribed.ears.common.util.Decider;
import com.unascribed.ears.mixin.AccessorHumanoidArmorLayer;
import com.unascribed.ears.mixin.AccessorLivingEntityRenderer;
import com.unascribed.ears.mixin.AccessorTextureManager;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.PlayerModelType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import org.joml.AxisAngle4f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class EarsLayerRenderer
extends RenderLayer<AvatarRenderState, PlayerModel> {
    private final AvatarRenderer<LocalPlayer> per;
    private final IndirectEarsRenderDelegate<PoseStack, SubmitNodeCollector, RenderType, AvatarRenderState, ModelPart> delegate = new IndirectEarsRenderDelegate<PoseStack, SubmitNodeCollector, RenderType, AvatarRenderState, ModelPart>(){
        private float armorR = 1.0f;
        private float armorG = 1.0f;
        private float armorB = 1.0f;
        private float armorA = 1.0f;
        private HumanoidArmorLayer<?, ?, ?> afr;
        private final List<MethodHandle> entityCaptures = Lists.newArrayList();
        private final List<MethodHandle> slotCaptures = Lists.newArrayList();
        private final PoseStack.Pose IDENTITY3 = new PoseStack().last();

        @Override
        protected Decider<EarsRenderDelegate.BodyPart, ModelPart> decideModelPart(Decider<EarsRenderDelegate.BodyPart, ModelPart> d) {
            PlayerModel model = (PlayerModel)EarsLayerRenderer.this.getParentModel();
            return d.map(EarsRenderDelegate.BodyPart.HEAD, model.head).map(EarsRenderDelegate.BodyPart.LEFT_ARM, model.leftArm).map(EarsRenderDelegate.BodyPart.LEFT_LEG, model.leftLeg).map(EarsRenderDelegate.BodyPart.RIGHT_ARM, model.rightArm).map(EarsRenderDelegate.BodyPart.RIGHT_LEG, model.rightLeg).map(EarsRenderDelegate.BodyPart.TORSO, model.body);
        }

        @Override
        protected void doAnchorTo(EarsRenderDelegate.BodyPart part, ModelPart modelPart) {
            modelPart.translateAndRotate((PoseStack)this.matrices);
            ModelPart.Cube cuboid = modelPart.getRandomCube((RandomSource)NotRandom119.INSTANCE);
            ((PoseStack)this.matrices).scale(0.0625f, 0.0625f, 0.0625f);
            ((PoseStack)this.matrices).translate(cuboid.minX, cuboid.maxY, cuboid.minZ);
        }

        @Override
        protected boolean isVisible(ModelPart modelPart) {
            return modelPart.visible;
        }

        @Override
        protected EarsFeatures getEarsFeatures() {
            return EarsLayerRenderer.getEarsFeatures((AvatarRenderState)this.peer);
        }

        @Override
        public boolean isSlim() {
            return ((AvatarRenderState)this.peer).skin.model() == PlayerModelType.SLIM;
        }

        @Override
        protected void pushMatrix() {
            ((PoseStack)this.matrices).pushPose();
        }

        @Override
        protected void popMatrix() {
            ((PoseStack)this.matrices).popPose();
        }

        @Override
        protected void doTranslate(float x, float y, float z) {
            ((PoseStack)this.matrices).translate(x, y, z);
        }

        @Override
        protected void doRotate(float ang, float x, float y, float z) {
            ((PoseStack)this.matrices).mulPose((Quaternionfc)new AxisAngle4f(ang * ((float)Math.PI / 180), x, y, z).get(new Quaternionf()));
        }

        @Override
        protected void doScale(float x, float y, float z) {
            ((PoseStack)this.matrices).scale(x, y, z);
        }

        @Override
        protected void doUploadAux(EarsRenderDelegate.TexSource src, byte[] pngData) {
            ResourceLocation skin = ((AvatarRenderState)this.peer).skin.body().id();
            ResourceLocation id = ResourceLocation.tryBuild((String)skin.getNamespace(), (String)src.addSuffix(skin.getPath()));
            TextureManager textureManager = Minecraft.getInstance().getTextureManager();
            if (pngData != null && !((AccessorTextureManager)textureManager).ears$getTextures().containsKey(id)) {
                try {
                    textureManager.register(id, (AbstractTexture)new DynamicTexture(src::toString, NativeImage.read((ByteBuffer)1.toNativeBuffer(pngData))));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        protected void doBindBuiltin(EarsRenderDelegate.TexSource src) {
            this.commitQuads();
            if (src.isGlint()) {
                this.armorA = 1.0f;
                this.armorB = 1.0f;
                this.armorG = 1.0f;
                this.armorR = 1.0f;
                this.vc = RenderType.armorEntityGlint();
            } else if (this.canBind(src)) {
                EquipmentSlot slot = this.getSlot(src);
                ItemStack equipment = this.getEquippedStack((AvatarRenderState)this.peer, slot);
                AccessorHumanoidArmorLayer aafr = (AccessorHumanoidArmorLayer)this.afr;
                if (equipment.get(DataComponents.DYED_COLOR) != null) {
                    int c = ((DyedItemColor)equipment.get(DataComponents.DYED_COLOR)).rgb();
                    this.armorR = (float)(c >> 16 & 0xFF) / 255.0f;
                    this.armorG = (float)(c >> 8 & 0xFF) / 255.0f;
                    this.armorB = (float)(c & 0xFF) / 255.0f;
                    this.armorA = 1.0f;
                }
                try {
                    this.setCaptures((HumanoidRenderState)this.peer, slot);
                    aafr.ears$renderArmorPiece((PoseStack)this.matrices, (SubmitNodeCollector)this.vcp, equipment, slot, 0, (HumanoidRenderState)this.peer);
                    this.setCaptures(null, null);
                }
                catch (Throwable t) {
                    if (this.skipRendering == 0) {
                        this.skipRendering = 1;
                    }
                    EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "Exception while attempting to retrieve armor texture", t);
                }
            }
        }

        @Override
        public boolean canBind(EarsRenderDelegate.TexSource tex) {
            EquipmentSlot slot;
            boolean glint = tex.isGlint();
            if (glint) {
                tex = tex.getParent();
            }
            if ((slot = this.getSlot(tex)) == null) {
                return super.canBind(tex);
            }
            ItemStack equipment = this.getEquippedStack((AvatarRenderState)this.peer, slot);
            if (equipment.isEmpty() || !equipment.getComponents().has(DataComponents.EQUIPPABLE)) {
                return false;
            }
            if (this.afr == null) {
                for (RenderLayer<?, ?> fr : ((AccessorLivingEntityRenderer)EarsLayerRenderer.this.per).ears$getLayers()) {
                    if (!(fr instanceof HumanoidArmorLayer)) continue;
                    this.afr = (HumanoidArmorLayer)fr;
                    for (Field f : HumanoidArmorLayer.class.getDeclaredFields()) {
                        try {
                            f.setAccessible(true);
                            if (Modifier.isStatic(f.getModifiers())) continue;
                            if (EquipmentSlot.class == f.getType()) {
                                this.slotCaptures.add(MethodHandles.lookup().unreflectSetter(f));
                                continue;
                            }
                            if (!HumanoidRenderState.class.isAssignableFrom(f.getType())) continue;
                            this.entityCaptures.add(MethodHandles.lookup().unreflectSetter(f));
                        }
                        catch (Throwable t) {
                            EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "Exception while attempting to scan for captures", t);
                        }
                    }
                }
            }
            if (this.afr != null) {
                AccessorHumanoidArmorLayer aafr = (AccessorHumanoidArmorLayer)this.afr;
                HumanoidModel bmodel = (HumanoidModel)aafr.ears$getModelSet().chest();
                HumanoidModel lmodel = (HumanoidModel)aafr.ears$getModelSet().legs();
                try {
                    this.setCaptures((HumanoidRenderState)this.peer, slot);
                    HumanoidModel<?> model = aafr.ears$getArmor((HumanoidRenderState)this.peer, slot);
                    this.setCaptures(null, null);
                    if (model != bmodel && model != lmodel) {
                        return false;
                    }
                    return glint ? equipment.hasFoil() : true;
                }
                catch (Throwable t) {
                    EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "Exception while attempting to retrieve armor model", t);
                    return false;
                }
            }
            return false;
        }

        private void setCaptures(HumanoidRenderState entity, EquipmentSlot slot) {
            for (MethodHandle mh : this.entityCaptures) {
                try {
                    mh.invoke(this.afr, entity);
                }
                catch (Throwable throwable) {}
            }
            for (MethodHandle mh : this.slotCaptures) {
                try {
                    mh.invoke(this.afr, slot);
                }
                catch (Throwable throwable) {}
            }
        }

        private EquipmentSlot getSlot(EarsRenderDelegate.TexSource tex) {
            return Decider.begin(tex).map(EarsRenderDelegate.TexSource.HELMET, EquipmentSlot.HEAD).map(EarsRenderDelegate.TexSource.CHESTPLATE, EquipmentSlot.CHEST).map(EarsRenderDelegate.TexSource.LEGGINGS, EquipmentSlot.LEGS).map(EarsRenderDelegate.TexSource.BOOTS, EquipmentSlot.FEET).orElse(null);
        }

        private ItemStack getEquippedStack(AvatarRenderState peer, EquipmentSlot slot) {
            return switch (slot) {
                case EquipmentSlot.HEAD -> peer.headEquipment;
                case EquipmentSlot.CHEST -> peer.chestEquipment;
                case EquipmentSlot.LEGS -> peer.legsEquipment;
                case EquipmentSlot.FEET -> peer.feetEquipment;
                default -> null;
            };
        }

        @Override
        protected void addVertex(float x, float y, int z, float r, float g, float b, float a, float u, float v, float nX, float nY, float nZ) {
            r *= this.armorR;
            g *= this.armorG;
            b *= this.armorB;
            a *= this.armorA;
            PoseStack.Pose snapshot = ((PoseStack)this.matrices).last().copy();
            Matrix4f positionMatrix = snapshot.pose();
            PoseStack.Pose normalMatrix = this.emissive ? this.IDENTITY3 : snapshot;
            int packedLight = this.emissive ? LightTexture.pack((int)15, (int)15) : this.light;
            int packedOverlay = this.overlay;
            PoseStack frozenStack = new PoseStack();
            frozenStack.last().pose().set((Matrix4fc)positionMatrix);
            frozenStack.last().normal().set((Matrix3fc)snapshot.normal());
            float fr = r;
            float fg = g;
            float fb = b;
            float fa = a;
            ((SubmitNodeCollector)this.vcp).submitCustomGeometry(frozenStack, (RenderType)this.vc, (entry, consumer) -> consumer.addVertex(positionMatrix, x, y, (float)z).setColor(fr, fg, fb, fa).setUv(u, v).setOverlay(packedOverlay).setLight(packedLight).setNormal(normalMatrix, nX, nY, nZ));
        }

        @Override
        protected void commitQuads() {
        }

        @Override
        protected void doRenderDebugDot(float r, float g, float b, float a) {
        }

        @Override
        protected RenderType getVertexConsumer(EarsRenderDelegate.TexSource src) {
            this.armorA = 1.0f;
            this.armorB = 1.0f;
            this.armorG = 1.0f;
            this.armorR = 1.0f;
            ResourceLocation id = ((AvatarRenderState)this.peer).skin.body().id();
            if (src != EarsRenderDelegate.TexSource.SKIN) {
                id = ResourceLocation.tryBuild((String)id.getNamespace(), (String)src.addSuffix(id.getPath()));
            }
            return RenderType.itemEntityTranslucentCull((ResourceLocation)id);
        }

        @Override
        public float getTime() {
            return ((AvatarRenderState)this.peer).ageInTicks;
        }

        @Override
        public boolean isFlying() {
            return ((EarsPlayerRenderState)this.peer).ears$isFlying();
        }

        @Override
        public boolean isGliding() {
            return ((AvatarRenderState)this.peer).isFallFlying;
        }

        @Override
        public boolean isJacketEnabled() {
            return ((AvatarRenderState)this.peer).showJacket;
        }

        @Override
        public boolean isWearingBoots() {
            return ((AvatarRenderState)this.peer).feetEquipment.getComponents().has(DataComponents.EQUIPPABLE);
        }

        @Override
        public boolean isWearingChestplate() {
            return ((AvatarRenderState)this.peer).chestEquipment.getComponents().has(DataComponents.EQUIPPABLE) && !this.isWearingElytra();
        }

        @Override
        public boolean isWearingElytra() {
            return ((AvatarRenderState)this.peer).chestEquipment.getComponents().has(DataComponents.GLIDER);
        }

        @Override
        public float getHorizontalSpeed() {
            return ((EarsPlayerRenderState)this.peer).ears$getHorizontalSpeed();
        }

        @Override
        public float getLimbSwing() {
            return ((AvatarRenderState)this.peer).attackTime;
        }

        @Override
        public float getStride() {
            return ((EarsPlayerRenderState)this.peer).ears$getStride();
        }

        @Override
        public float getBodyYaw() {
            return ((AvatarRenderState)this.peer).bodyRot;
        }

        @Override
        public double getCapeX() {
            return ((EarsPlayerRenderState)this.peer).ears$getCapeX();
        }

        @Override
        public double getCapeY() {
            return ((EarsPlayerRenderState)this.peer).ears$getCapeY();
        }

        @Override
        public double getCapeZ() {
            return ((EarsPlayerRenderState)this.peer).ears$getCapeZ();
        }

        @Override
        public double getX() {
            return ((AvatarRenderState)this.peer).x;
        }

        @Override
        public double getY() {
            return ((AvatarRenderState)this.peer).y;
        }

        @Override
        public double getZ() {
            return ((AvatarRenderState)this.peer).z;
        }
    };

    public EarsLayerRenderer(AvatarRenderer<LocalPlayer> per) {
        super(per);
        this.per = per;
        EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "Constructed");
    }

    public void submit(PoseStack m, SubmitNodeCollector vertexConsumers, int light, AvatarRenderState entity, float limbAngle, float limbDistance) {
        this.delegate.render(m, vertexConsumers, entity, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)entity, (float)0.0f));
    }

    public void renderLeftArm(PoseStack m, SubmitNodeCollector vertexConsumers, int light) {
        AvatarRenderState state = (AvatarRenderState)this.per.createRenderState((Entity)Minecraft.getInstance().player, 1.0f);
        this.delegate.render(m, vertexConsumers, state, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f), EarsRenderDelegate.BodyPart.LEFT_ARM);
    }

    public void renderRightArm(PoseStack m, SubmitNodeCollector vertexConsumers, int light) {
        AvatarRenderState state = (AvatarRenderState)this.per.createRenderState((Entity)Minecraft.getInstance().player, 1.0f);
        this.delegate.render(m, vertexConsumers, state, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f), EarsRenderDelegate.BodyPart.RIGHT_ARM);
    }

    public static EarsFeatures getEarsFeatures(AvatarRenderState peer) {
        ResourceLocation skin = peer.skin.body().id();
        AbstractTexture tex = Minecraft.getInstance().getTextureManager().getTexture(skin);
        EarsLog.debug(EarsLog.Tag.PLATFORM_RENDERER, "getEarsFeatures(): skin={}, tex={}", (Object)skin, (Object)tex);
        if (tex instanceof EarsFeaturesHolder) {
            EarsFeatures feat = ((EarsFeaturesHolder)tex).getEarsFeatures();
            EarsFeaturesStorage.INSTANCE.put(peer.scoreText == null ? Minecraft.getInstance().name() : peer.scoreText.getString(), null, feat);
            if (!peer.isInvisible) {
                return feat;
            }
        }
        return EarsFeatures.DISABLED;
    }
}

