/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.flashback;

import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.record.Recorder;
import java.net.InetSocketAddress;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.crypto.Cipher;
import net.minecraft.class_2539;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.capture.ClientActivation;
import su.plo.voice.api.client.audio.capture.ClientActivationManager;
import su.plo.voice.api.client.audio.line.ClientSourceLine;
import su.plo.voice.api.client.audio.line.ClientSourceLineManager;
import su.plo.voice.api.client.audio.source.ClientAudioSource;
import su.plo.voice.api.client.audio.source.ClientSelfSourceInfo;
import su.plo.voice.api.client.connection.ServerConnection;
import su.plo.voice.api.client.connection.ServerInfo;
import su.plo.voice.api.client.event.connection.UdpClientPacketReceivedEvent;
import su.plo.voice.api.client.event.connection.UdpClientPacketSendEvent;
import su.plo.voice.api.client.socket.UdpClient;
import su.plo.voice.api.encryption.Encryption;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.flashback.event.FlashbackEvents;
import su.plo.voice.flashback.network.PacketUdpWrapper;
import su.plo.voice.flashback.network.VoiceSetupPacket;
import su.plo.voice.flashback.util.extension.PacketKt;
import su.plo.voice.libs.kotlin.Lazy;
import su.plo.voice.libs.kotlin.LazyKt;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.collections.CollectionsKt;
import su.plo.voice.libs.kotlin.collections.SetsKt;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.libs.kotlin.jvm.optionals.OptionalsKt;
import su.plo.voice.proto.data.audio.capture.CaptureInfo;
import su.plo.voice.proto.data.audio.capture.VoiceActivation;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.line.VoiceSourceLine;
import su.plo.voice.proto.data.encryption.EncryptionInfo;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.clientbound.ConfigPacket;
import su.plo.voice.proto.packets.tcp.clientbound.ConnectionPacket;
import su.plo.voice.proto.packets.tcp.clientbound.LanguagePacket;
import su.plo.voice.proto.packets.tcp.clientbound.PlayerListPacket;
import su.plo.voice.proto.packets.tcp.clientbound.SelfSourceInfoPacket;
import su.plo.voice.proto.packets.tcp.clientbound.SourceInfoPacket;
import su.plo.voice.proto.packets.udp.PacketUdp;
import su.plo.voice.proto.packets.udp.clientbound.SelfAudioInfoPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;
import su.plo.voice.proto.packets.udp.serverbound.PlayerAudioPacket;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0007J\u0014\u0010\u0013\u001a\u00020\u000e2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#H\u0002J\u0010\u0010%\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006'"}, d2={"Lsu/plo/voice/flashback/VoicePacketRecorder;", "", "voiceClient", "Lsu/plo/voice/api/client/PlasmoVoiceClient;", "<init>", "(Lsu/plo/voice/api/client/PlasmoVoiceClient;)V", "minecraft", "Lnet/minecraft/client/Minecraft;", "su.plo.voice.libs.kotlin.jvm.PlatformType", "getMinecraft", "()Lnet/minecraft/client/Minecraft;", "minecraft$delegate", "Lsu/plo/voice/libs/kotlin/Lazy;", "onSourceAudioPacketReceived", "", "event", "Lsu/plo/voice/api/client/event/connection/UdpClientPacketReceivedEvent;", "onUdpPacketSend", "Lsu/plo/voice/api/client/event/connection/UdpClientPacketSendEvent;", "recordUdpPacket", "packet", "Lsu/plo/voice/proto/packets/Packet;", "shouldRecordPackets", "", "createLanguagePacket", "Lsu/plo/voice/proto/packets/tcp/clientbound/LanguagePacket;", "createPlayerListPacket", "Lsu/plo/voice/proto/packets/tcp/clientbound/PlayerListPacket;", "createConnectionPacket", "Lsu/plo/voice/proto/packets/tcp/clientbound/ConnectionPacket;", "createConfigPacket", "Lsu/plo/voice/proto/packets/tcp/clientbound/ConfigPacket;", "keyPair", "Ljava/security/KeyPair;", "currentSourcesPackets", "", "Lsu/plo/voice/proto/packets/tcp/clientbound/SourceInfoPacket;", "currentSelfSourcesPackets", "Lsu/plo/voice/proto/packets/tcp/clientbound/SelfSourceInfoPacket;", "pv-addon-flashback"})
@SourceDebugExtension(value={"SMAP\nVoicePacketRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VoicePacketRecorder.kt\nsu/plo/voice/flashback/VoicePacketRecorder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n1557#2:208\n1628#2,2:209\n1630#2:212\n1557#2:213\n1628#2,3:214\n1557#2:217\n1628#2,3:218\n1557#2:221\n1628#2,3:222\n1863#2,2:225\n1863#2,2:227\n1#3:211\n*S KotlinDebug\n*F\n+ 1 VoicePacketRecorder.kt\nsu/plo/voice/flashback/VoicePacketRecorder\n*L\n168#1:208\n168#1:209,2\n168#1:212\n179#1:213\n179#1:214,3\n199#1:217\n199#1:218,3\n204#1:221\n204#1:222,3\n59#1:225,2\n68#1:227,2\n*E\n"})
public final class VoicePacketRecorder {
    @NotNull
    private final PlasmoVoiceClient voiceClient;
    @NotNull
    private final Lazy minecraft$delegate;

    public VoicePacketRecorder(@NotNull PlasmoVoiceClient voiceClient) {
        Intrinsics.checkNotNullParameter((Object)voiceClient, (String)"voiceClient");
        this.voiceClient = voiceClient;
        this.minecraft$delegate = LazyKt.lazy(VoicePacketRecorder::minecraft_delegate$lambda$0);
        FlashbackEvents.WRITE_INITIAL_SNAPSHOT.register(arg_0 -> VoicePacketRecorder._init_$lambda$3(this, arg_0));
    }

    private final class_310 getMinecraft() {
        Lazy lazy = this.minecraft$delegate;
        return (class_310)lazy.getValue();
    }

    @EventSubscribe
    public final void onSourceAudioPacketReceived(@NotNull UdpClientPacketReceivedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.shouldRecordPackets()) {
            return;
        }
        if (event.getPacket() instanceof SourceAudioPacket) {
            Packet packet = event.getPacket();
            Intrinsics.checkNotNullExpressionValue((Object)packet, (String)"getPacket(...)");
            this.recordUdpPacket(packet);
        } else if (event.getPacket() instanceof SelfAudioInfoPacket) {
            Packet packet = event.getPacket();
            Intrinsics.checkNotNullExpressionValue((Object)packet, (String)"getPacket(...)");
            this.recordUdpPacket(packet);
        }
    }

    @EventSubscribe
    public final void onUdpPacketSend(@NotNull UdpClientPacketSendEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.shouldRecordPackets() || this.getMinecraft().field_1724 == null || !(event.getPacket() instanceof PlayerAudioPacket)) {
            return;
        }
        Packet packet = event.getPacket();
        Intrinsics.checkNotNullExpressionValue((Object)packet, (String)"getPacket(...)");
        this.recordUdpPacket(packet);
    }

    private final void recordUdpPacket(Packet<?> packet) {
        UUID uUID;
        Optional optional = this.voiceClient.getUdpClientManager().getClient();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getClient(...)");
        UdpClient udpClient = (UdpClient)OptionalsKt.getOrNull((Optional)optional);
        if (udpClient == null || (uUID = udpClient.getSecret()) == null) {
            return;
        }
        UUID secret = uUID;
        PacketUdpWrapper udpPacket = new PacketUdpWrapper(new PacketUdp(secret, System.currentTimeMillis(), packet));
        if (!this.shouldRecordPackets()) {
            return;
        }
        Flashback.RECORDER.writePacketAsync((class_2596)new class_2658((class_8710)udpPacket), class_2539.field_20591);
    }

    private final boolean shouldRecordPackets() {
        Recorder recorder = Flashback.RECORDER;
        return recorder != null ? recorder.readyToWrite() : false;
    }

    private final LanguagePacket createLanguagePacket() {
        Optional optional = this.voiceClient.getServerConnection();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getServerConnection(...)");
        ServerConnection serverConnection = (ServerConnection)OptionalsKt.getOrNull((Optional)optional);
        if (serverConnection == null) {
            return null;
        }
        ServerConnection serverConnection2 = serverConnection;
        return new LanguagePacket("", serverConnection2.getLanguage());
    }

    private final PlayerListPacket createPlayerListPacket() {
        Optional optional = this.voiceClient.getServerConnection();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getServerConnection(...)");
        ServerConnection serverConnection = (ServerConnection)OptionalsKt.getOrNull((Optional)optional);
        if (serverConnection == null) {
            return null;
        }
        ServerConnection serverConnection2 = serverConnection;
        Collection collection = serverConnection2.getPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPlayers(...)");
        return new PlayerListPacket(CollectionsKt.toList((Iterable)collection));
    }

    private final ConnectionPacket createConnectionPacket() {
        Optional optional = this.voiceClient.getUdpClientManager().getClient();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getClient(...)");
        UdpClient udpClient = (UdpClient)OptionalsKt.getOrNull((Optional)optional);
        if (udpClient == null) {
            return null;
        }
        UdpClient udpClient2 = udpClient;
        Optional optional2 = udpClient2.getRemoteAddress();
        Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"getRemoteAddress(...)");
        InetSocketAddress inetSocketAddress = (InetSocketAddress)OptionalsKt.getOrNull((Optional)optional2);
        if (inetSocketAddress == null) {
            return null;
        }
        InetSocketAddress remoteAddress = inetSocketAddress;
        return new ConnectionPacket(udpClient2.getSecret(), remoteAddress.getHostString(), remoteAddress.getPort());
    }

    /*
     * WARNING - void declaration
     */
    private final ConfigPacket createConfigPacket(KeyPair keyPair) {
        Collection<VoiceActivation> collection;
        ClientActivation sourceLine;
        Collection<VoiceSourceLine> collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Cipher cipher;
        Cipher cipher2;
        void it;
        UUID uUID;
        CaptureInfo captureInfo;
        Optional optional = this.voiceClient.getServerInfo();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getServerInfo(...)");
        ServerInfo serverInfo = (ServerInfo)OptionalsKt.getOrNull((Optional)optional);
        if (serverInfo == null) {
            return null;
        }
        ServerInfo serverInfo2 = serverInfo;
        ClientSourceLineManager clientSourceLineManager = this.voiceClient.getSourceLineManager();
        Intrinsics.checkNotNullExpressionValue((Object)clientSourceLineManager, (String)"getSourceLineManager(...)");
        ClientSourceLineManager sourceLines = clientSourceLineManager;
        ClientActivationManager clientActivationManager = this.voiceClient.getActivationManager();
        Intrinsics.checkNotNullExpressionValue((Object)clientActivationManager, (String)"getActivationManager(...)");
        ClientActivationManager activations = clientActivationManager;
        UUID uUID2 = serverInfo2.getServerId();
        CaptureInfo captureInfo2 = serverInfo2.getVoiceInfo().getCaptureInfo();
        Optional optional2 = serverInfo2.getEncryption();
        Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"getEncryption(...)");
        Object object = (Encryption)OptionalsKt.getOrNull((Optional)optional2);
        if (object != null) {
            Cipher encryptCipher;
            Encryption encryption = object;
            captureInfo = captureInfo2;
            uUID = uUID2;
            boolean bl = false;
            try {
                encryptCipher = Cipher.getInstance("RSA");
                encryptCipher.init(1, keyPair.getPublic());
                byte[] encryptionData = encryptCipher.doFinal(it.getKey().getEncoded());
                encryptCipher = new EncryptionInfo(it.getName(), encryptionData);
            }
            catch (Exception e) {
                return null;
            }
            cipher2 = encryptCipher;
            uUID2 = uUID;
            captureInfo2 = captureInfo;
            cipher = cipher2;
        } else {
            cipher = null;
        }
        object = sourceLines.getLines();
        cipher2 = cipher;
        captureInfo = captureInfo2;
        uUID = uUID2;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection collection3;
            ClientSourceLine clientSourceLine = (ClientSourceLine)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            Collection collection4 = collection3 = sourceLine.getPlayers();
            int n = sourceLine.getWeight();
            double d = sourceLine.getDefaultVolume();
            String string = sourceLine.getIcon();
            String string2 = sourceLine.getTranslation();
            String string3 = sourceLine.getName();
            boolean bl2 = false;
            boolean bl3 = sourceLine.hasPlayers();
            Collection collection5 = bl3 ? collection3 : null;
            if (collection5 == null || (collection5 = CollectionsKt.toSet((Iterable)collection5)) == null) {
                collection5 = SetsKt.emptySet();
            }
            Collection collection6 = collection5;
            int n2 = n;
            double d2 = d;
            String string4 = string;
            String string5 = string2;
            String string6 = string3;
            collection2.add(new VoiceSourceLine(string6, string5, string4, d2, n2, (Set)collection6));
        }
        collection2 = (List)destination$iv$iv;
        Set set = CollectionsKt.toSet((Iterable)collection2);
        Collection collection7 = activations.getActivations();
        Intrinsics.checkNotNullExpressionValue((Object)collection7, (String)"getActivations(...)");
        $this$map$iv = collection7;
        collection2 = set;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void activation;
            sourceLine = (ClientActivation)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = activation.getName();
            String string7 = activation.getTranslation();
            String string8 = activation.getIcon();
            List list = activation.getDistances();
            int n = activation.getDefaultDistance();
            boolean bl4 = activation.isProximity();
            boolean bl5 = activation.isStereoSupported();
            boolean bl6 = activation.isTransitive();
            Optional optional3 = activation.getEncoderInfo();
            Intrinsics.checkNotNullExpressionValue((Object)optional3, (String)"getEncoderInfo(...)");
            collection.add(new VoiceActivation(string, string7, string8, list, n, bl4, bl5, bl6, (CodecInfo)OptionalsKt.getOrNull((Optional)optional3), activation.getWeight()));
        }
        collection = (List)destination$iv$iv;
        Map map = serverInfo2.getPlayerInfo().getPermissions();
        Set set2 = CollectionsKt.toSet((Iterable)collection);
        Collection<VoiceSourceLine> collection8 = collection2;
        Cipher cipher3 = cipher2;
        CaptureInfo captureInfo3 = captureInfo;
        UUID uUID3 = uUID;
        return new ConfigPacket(uUID3, captureInfo3, (EncryptionInfo)cipher3, collection8, set2, map);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SourceInfoPacket> currentSourcesPackets() {
        void $this$mapTo$iv$iv;
        if (this.voiceClient.getServerInfo().isEmpty()) {
            return null;
        }
        Collection collection = this.voiceClient.getSourceManager().getSources();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSources(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClientAudioSource clientAudioSource = (ClientAudioSource)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new SourceInfoPacket(it.getSourceInfo()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SelfSourceInfoPacket> currentSelfSourcesPackets() {
        void $this$mapTo$iv$iv;
        if (this.voiceClient.getServerInfo().isEmpty()) {
            return null;
        }
        Collection collection = this.voiceClient.getSourceManager().getAllSelfSourceInfos();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllSelfSourceInfos(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClientSelfSourceInfo clientSelfSourceInfo = (ClientSelfSourceInfo)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new SelfSourceInfoPacket(it.getSelfSourceInfo()));
        }
        return (List)destination$iv$iv;
    }

    private static final class_310 minecraft_delegate$lambda$0() {
        return class_310.method_1551();
    }

    private static final void _init_$lambda$3(VoicePacketRecorder this$0, Recorder it) {
        block8: {
            SourceInfoPacket sourceInfoPacket;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Optional optional = this$0.voiceClient.getServerConnection();
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getServerConnection(...)");
            Object object = (ServerConnection)OptionalsKt.getOrNull((Optional)optional);
            if (object == null || (object = object.getKeyPair()) == null) {
                return;
            }
            Object keyPair = object;
            ConnectionPacket connectionPacket = this$0.createConnectionPacket();
            if (connectionPacket == null) {
                return;
            }
            ConnectionPacket connectionPacket2 = connectionPacket;
            ConfigPacket configPacket = this$0.createConfigPacket((KeyPair)keyPair);
            if (configPacket == null) {
                return;
            }
            ConfigPacket configPacket2 = configPacket;
            PlayerListPacket playerListPacket = this$0.createPlayerListPacket();
            if (playerListPacket == null) {
                return;
            }
            PlayerListPacket playerList = playerListPacket;
            LanguagePacket languagePacket = this$0.createLanguagePacket();
            if (languagePacket == null) {
                return;
            }
            LanguagePacket language = languagePacket;
            Flashback.RECORDER.writePacketAsync((class_2596)new class_2658((class_8710)new VoiceSetupPacket((KeyPair)keyPair, connectionPacket2, configPacket2, playerList, language)), class_2539.field_20591);
            List<SourceInfoPacket> list = this$0.currentSourcesPackets();
            if (list != null) {
                $this$forEach$iv = list;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    sourceInfoPacket = (SourceInfoPacket)element$iv;
                    boolean bl = false;
                    Flashback.RECORDER.writePacketAsync((class_2596)new class_2658((class_8710)PacketKt.encodeToByteArrayPayload((Packet)sourceInfoPacket)), class_2539.field_20591);
                }
            }
            List<SelfSourceInfoPacket> list2 = this$0.currentSelfSourcesPackets();
            if (list2 == null) break block8;
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                sourceInfoPacket = (SelfSourceInfoPacket)element$iv;
                boolean bl = false;
                Flashback.RECORDER.writePacketAsync((class_2596)new class_2658((class_8710)PacketKt.encodeToByteArrayPayload((Packet)sourceInfoPacket)), class_2539.field_20591);
            }
        }
    }
}

