/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.flashback.playback;

import com.google.common.collect.Maps;
import com.moulberry.flashback.Flashback;
import com.moulberry.flashback.playback.ReplayServer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.ConfigEntry;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.source.ClientAudioSource;
import su.plo.voice.api.client.audio.source.ClientSelfSourceInfo;
import su.plo.voice.flashback.CameraUtilKt;
import su.plo.voice.flashback.FlashbackVoiceAddon;
import su.plo.voice.flashback.FlashbackVoiceConfigKt;
import su.plo.voice.flashback.network.PacketUdpWrapper;
import su.plo.voice.libs.kotlin.Lazy;
import su.plo.voice.libs.kotlin.LazyKt;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.functions.Function1;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.optionals.OptionalsKt;
import su.plo.voice.proto.data.audio.source.DirectSourceInfo;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.udp.PacketUdp;
import su.plo.voice.proto.packets.udp.clientbound.SelfAudioInfoPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;
import su.plo.voice.proto.packets.udp.serverbound.PlayerAudioPacket;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lsu/plo/voice/flashback/playback/VoicePacketUdpListener;", "Lnet/fabricmc/fabric/api/client/networking/v1/ClientPlayNetworking$PlayPayloadHandler;", "Lsu/plo/voice/flashback/network/PacketUdpWrapper;", "addon", "Lsu/plo/voice/flashback/FlashbackVoiceAddon;", "<init>", "(Lsu/plo/voice/flashback/FlashbackVoiceAddon;)V", "voiceClient", "Lsu/plo/voice/api/client/PlasmoVoiceClient;", "getVoiceClient", "()Lsu/plo/voice/api/client/PlasmoVoiceClient;", "voiceClient$delegate", "Lsu/plo/voice/libs/kotlin/Lazy;", "selfAudioHandler", "Lsu/plo/voice/flashback/playback/VoicePacketUdpListener$SelfAudioHandler;", "receive", "", "packetUdpWrapper", "context", "Lnet/fabricmc/fabric/api/client/networking/v1/ClientPlayNetworking$Context;", "handleSourceAudio", "packet", "Lsu/plo/voice/proto/packets/udp/clientbound/SourceAudioPacket;", "SelfAudioHandler", "pv-addon-flashback"})
public final class VoicePacketUdpListener
implements ClientPlayNetworking.PlayPayloadHandler<PacketUdpWrapper> {
    @NotNull
    private final FlashbackVoiceAddon addon;
    @NotNull
    private final Lazy voiceClient$delegate;
    @NotNull
    private final SelfAudioHandler selfAudioHandler;

    public VoicePacketUdpListener(@NotNull FlashbackVoiceAddon addon) {
        Intrinsics.checkNotNullParameter((Object)addon, (String)"addon");
        this.addon = addon;
        this.voiceClient$delegate = LazyKt.lazy(() -> VoicePacketUdpListener.voiceClient_delegate$lambda$0(this));
        this.selfAudioHandler = new SelfAudioHandler();
    }

    private final PlasmoVoiceClient getVoiceClient() {
        Lazy lazy = this.voiceClient$delegate;
        return (PlasmoVoiceClient)lazy.getValue();
    }

    public void receive(@NotNull PacketUdpWrapper packetUdpWrapper, @NotNull ClientPlayNetworking.Context context) {
        boolean shouldSend;
        Intrinsics.checkNotNullParameter((Object)packetUdpWrapper, (String)"packetUdpWrapper");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ReplayServer replayServer = Flashback.getReplayServer();
        if (replayServer == null) {
            return;
        }
        ReplayServer replayServer2 = replayServer;
        if (replayServer2.isProcessingSnapshot) {
            return;
        }
        boolean bl = Flashback.isExporting() ? ((Boolean)FlashbackVoiceConfigKt.invoke((ConfigEntry)FlashbackVoiceAddon.Companion.getConfig().getExportVoiceChat())).booleanValue() && Flashback.EXPORT_JOB.getSettings().recordAudio() && Flashback.EXPORT_JOB.getCurrentTickDouble() > 0.0 : (shouldSend = !replayServer2.fastForwarding && !replayServer2.replayPaused);
        if (!shouldSend) {
            return;
        }
        boolean stateInitialized = this.getVoiceClient().getServerInfo().isPresent();
        if (!stateInitialized) {
            return;
        }
        PacketUdp packetUdp = packetUdpWrapper.getPacketUdp();
        Packet packet = packetUdp.getPacketUntyped();
        if (packet instanceof SourceAudioPacket) {
            this.handleSourceAudio((SourceAudioPacket)packet);
        } else if (packet instanceof PlayerAudioPacket) {
            this.selfAudioHandler.handleSelfAudio((PlayerAudioPacket)packet);
        } else if (packet instanceof SelfAudioInfoPacket) {
            this.selfAudioHandler.handleSelfAudioInfo((SelfAudioInfoPacket)packet);
        }
    }

    private final void handleSourceAudio(SourceAudioPacket packet) {
        ClientAudioSource clientAudioSource;
        Optional optional = this.getVoiceClient().getSourceManager().getSourceById(packet.getSourceId());
        if (optional == null || (clientAudioSource = (ClientAudioSource)OptionalsKt.getOrNull((Optional)optional)) == null) {
            return;
        }
        ClientAudioSource source = clientAudioSource;
        if (source.getSourceInfo().getState() != packet.getSourceState()) {
            return;
        }
        source.process(packet);
    }

    private static final PlasmoVoiceClient voiceClient_delegate$lambda$0(VoicePacketUdpListener this$0) {
        return this$0.addon.getVoiceClient();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lsu/plo/voice/flashback/playback/VoicePacketUdpListener$SelfAudioHandler;", "", "<init>", "(Lsu/plo/voice/flashback/playback/VoicePacketUdpListener;)V", "maxPackets", "", "packetIndex", "", "", "packets", "", "Lsu/plo/voice/proto/packets/udp/serverbound/PlayerAudioPacket;", "currentPacketIndex", "handleSelfAudio", "", "packet", "handleSelfAudioInfo", "Lsu/plo/voice/proto/packets/udp/clientbound/SelfAudioInfoPacket;", "pv-addon-flashback"})
    private final class SelfAudioHandler {
        private final int maxPackets;
        @NotNull
        private final Map<Long, Integer> packetIndex;
        @NotNull
        private final List<PlayerAudioPacket> packets;
        private int currentPacketIndex;

        public SelfAudioHandler() {
            this.maxPackets = 50;
            HashMap hashMap = Maps.newHashMap();
            Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap(...)");
            this.packetIndex = hashMap;
            this.packets = new ArrayList();
        }

        public final void handleSelfAudio(@NotNull PlayerAudioPacket packet) {
            PlayerAudioPacket currentPacket;
            Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
            PlayerAudioPacket playerAudioPacket = currentPacket = this.packets.size() > this.currentPacketIndex ? this.packets.get(this.currentPacketIndex) : null;
            if (currentPacket != null) {
                this.packetIndex.remove(currentPacket.getSequenceNumber());
            }
            if (this.packets.size() > this.currentPacketIndex) {
                this.packets.set(this.currentPacketIndex, packet);
            } else {
                this.packets.add(packet);
            }
            this.packetIndex.put(packet.getSequenceNumber(), this.currentPacketIndex);
            this.currentPacketIndex = (this.currentPacketIndex + 1) % this.maxPackets;
        }

        public final void handleSelfAudioInfo(@NotNull SelfAudioInfoPacket packet) {
            byte[] byArray;
            byte[] byArray2;
            Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
            Boolean shouldPlay = VoicePacketUdpListener.this.getVoiceClient().getSourceManager().getSelfSourceInfo(packet.getSourceId()).map(arg_0 -> SelfAudioHandler.handleSelfAudioInfo$lambda$1(arg_0 -> SelfAudioHandler.handleSelfAudioInfo$lambda$0(VoicePacketUdpListener.this, packet, arg_0), arg_0)).orElse(true);
            Optional optional = VoicePacketUdpListener.this.getVoiceClient().getSourceManager().getSourceById(packet.getSourceId(), false);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getSourceById(...)");
            ClientAudioSource clientAudioSource = (ClientAudioSource)OptionalsKt.getOrNull((Optional)optional);
            if (clientAudioSource == null) {
                return;
            }
            ClientAudioSource source = clientAudioSource;
            if (source.isActivated() && !shouldPlay.booleanValue()) {
                source.closeAsync();
            } else if (!shouldPlay.booleanValue()) {
                return;
            }
            Optional optional2 = packet.getData();
            if (optional2 != null && (byArray2 = (byte[])OptionalsKt.getOrNull((Optional)optional2)) != null) {
                byArray = byArray2;
            } else {
                SelfAudioHandler $this$handleSelfAudioInfo_u24lambda_u242 = this;
                boolean bl = false;
                int index = ((Number)$this$handleSelfAudioInfo_u24lambda_u242.packetIndex.getOrDefault(packet.getSequenceNumber(), -1)).intValue();
                if (index == -1) {
                    return;
                }
                byArray = $this$handleSelfAudioInfo_u24lambda_u242.packets.get(index).getData();
            }
            byte[] packetData = byArray;
            source.process(new SourceAudioPacket(packet.getSequenceNumber(), source.getSourceInfo().getState(), packetData, packet.getSourceId(), packet.getDistance()));
        }

        private static final Boolean handleSelfAudioInfo$lambda$0(VoicePacketUdpListener this$0, SelfAudioInfoPacket $packet, ClientSelfSourceInfo selfSourceInfo) {
            if (!CameraUtilKt.isCameraRemotePlayer() && selfSourceInfo.getSelfSourceInfo().getSourceInfo() instanceof DirectSourceInfo) {
                return false;
            }
            if (this$0.getVoiceClient().getSourceManager().getSourceById($packet.getSourceId(), false).isPresent()) {
                return true;
            }
            this$0.getVoiceClient().getSourceManager().createOrUpdateSource(selfSourceInfo.getSelfSourceInfo().getSourceInfo());
            return true;
        }

        private static final Boolean handleSelfAudioInfo$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

