/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.flashback.playback;

import com.moulberry.flashback.Flashback;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_310;
import net.minecraft.class_745;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.source.ClientAudioSource;
import su.plo.voice.api.client.audio.source.ClientSelfSourceInfo;
import su.plo.voice.api.client.audio.source.ClientSourceManager;
import su.plo.voice.api.client.event.audio.capture.AudioCaptureEvent;
import su.plo.voice.api.client.event.audio.capture.AudioCaptureInitializeEvent;
import su.plo.voice.api.client.event.audio.device.source.AlSourceWriteEvent;
import su.plo.voice.api.client.event.audio.source.AudioSourceResetEvent;
import su.plo.voice.api.client.event.connection.ConnectionKeyPairGenerateEvent;
import su.plo.voice.api.client.event.render.HudActivationRenderEvent;
import su.plo.voice.api.client.event.render.VoiceDistanceRenderEvent;
import su.plo.voice.api.client.event.socket.UdpClientClosedEvent;
import su.plo.voice.api.client.event.socket.UdpClientConnectEvent;
import su.plo.voice.api.client.socket.UdpClient;
import su.plo.voice.api.client.time.SystemTimeSupplier;
import su.plo.voice.api.client.time.TimeSupplier;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.flashback.CameraUtilKt;
import su.plo.voice.flashback.FlashbackVoiceAddon;
import su.plo.voice.flashback.playback.DummyUdpClient;
import su.plo.voice.flashback.playback.ReplayTimeSupplier;
import su.plo.voice.flashback.playback.VoiceSetupListener;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;
import su.plo.voice.libs.kotlin.jvm.optionals.OptionalsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lsu/plo/voice/flashback/playback/VoiceReplayEvents;", "", "addon", "Lsu/plo/voice/flashback/FlashbackVoiceAddon;", "voiceClient", "Lsu/plo/voice/api/client/PlasmoVoiceClient;", "<init>", "(Lsu/plo/voice/flashback/FlashbackVoiceAddon;Lsu/plo/voice/api/client/PlasmoVoiceClient;)V", "onKeyPairGenerate", "", "event", "Lsu/plo/voice/api/client/event/connection/ConnectionKeyPairGenerateEvent;", "onUdpClientConnect", "Lsu/plo/voice/api/client/event/socket/UdpClientConnectEvent;", "onUdpClientDisconnect", "Lsu/plo/voice/api/client/event/socket/UdpClientClosedEvent;", "onHudActivationRender", "Lsu/plo/voice/api/client/event/render/HudActivationRenderEvent;", "onDistanceRender", "Lsu/plo/voice/api/client/event/render/VoiceDistanceRenderEvent;", "onAudioCaptureInitialize", "Lsu/plo/voice/api/client/event/audio/capture/AudioCaptureInitializeEvent;", "onAudioCapture", "Lsu/plo/voice/api/client/event/audio/capture/AudioCaptureEvent;", "onSourceReset", "Lsu/plo/voice/api/client/event/audio/source/AudioSourceResetEvent;", "onSourceWrite", "Lsu/plo/voice/api/client/event/audio/device/source/AlSourceWriteEvent;", "pv-addon-flashback"})
@SourceDebugExtension(value={"SMAP\nVoiceReplayEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VoiceReplayEvents.kt\nsu/plo/voice/flashback/playback/VoiceReplayEvents\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n774#2:113\n865#2,2:114\n1755#2,3:116\n*S KotlinDebug\n*F\n+ 1 VoiceReplayEvents.kt\nsu/plo/voice/flashback/playback/VoiceReplayEvents\n*L\n62#1:113\n62#1:114,2\n65#1:116,3\n*E\n"})
public final class VoiceReplayEvents {
    @NotNull
    private final FlashbackVoiceAddon addon;
    @NotNull
    private final PlasmoVoiceClient voiceClient;

    public VoiceReplayEvents(@NotNull FlashbackVoiceAddon addon, @NotNull PlasmoVoiceClient voiceClient) {
        Intrinsics.checkNotNullParameter((Object)addon, (String)"addon");
        Intrinsics.checkNotNullParameter((Object)voiceClient, (String)"voiceClient");
        this.addon = addon;
        this.voiceClient = voiceClient;
    }

    @EventSubscribe
    public final void onKeyPairGenerate(@NotNull ConnectionKeyPairGenerateEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            KeyPair keyPair = VoiceSetupListener.Companion.getCurrentKeyPair();
            if (keyPair == null) break block0;
            KeyPair it = keyPair;
            boolean bl = false;
            event.setKeyPair(it);
        }
    }

    @EventSubscribe
    public final void onUdpClientConnect(@NotNull UdpClientConnectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Flashback.isInReplay()) {
            return;
        }
        this.voiceClient.setTimeSupplier((TimeSupplier)ReplayTimeSupplier.INSTANCE);
        UUID uUID = event.getConnectionPacket().getSecret();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getSecret(...)");
        DummyUdpClient udpClient = new DummyUdpClient(this.voiceClient, uUID);
        this.voiceClient.getEventBus().register((Object)this.addon, (Object)udpClient);
        this.voiceClient.getUdpClientManager().setClient((UdpClient)udpClient);
        event.setCancelled(true);
    }

    @EventSubscribe
    public final void onUdpClientDisconnect(@NotNull UdpClientClosedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(this.voiceClient.getTimeSupplier() instanceof ReplayTimeSupplier)) {
            return;
        }
        this.voiceClient.setTimeSupplier((TimeSupplier)new SystemTimeSupplier());
        VoiceSetupListener.Companion.setCurrentKeyPair(null);
    }

    /*
     * WARNING - void declaration
     */
    @EventSubscribe
    public final void onHudActivationRender(@NotNull HudActivationRenderEvent event) {
        boolean bl;
        block6: {
            void $this$any$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!Flashback.isInReplay() || event.isRender()) {
                return;
            }
            if (!CameraUtilKt.isCameraRemotePlayer()) {
                return;
            }
            class_745 player = (class_745)class_310.method_1551().method_1560();
            Collection collection = this.voiceClient.getSourceManager().getAllSelfSourceInfos();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllSelfSourceInfos(...)");
            Iterable iterable = collection;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ClientSelfSourceInfo sourceInfo = (ClientSelfSourceInfo)element$iv$iv;
                boolean bl2 = false;
                UUID uUID = sourceInfo.getSelfSourceInfo().getPlayerId();
                class_745 class_7452 = player;
                Intrinsics.checkNotNull((Object)class_7452);
                if (!(Intrinsics.areEqual((Object)uUID, (Object)class_7452.method_5667()) && Intrinsics.areEqual((Object)sourceInfo.getSelfSourceInfo().getActivationId(), (Object)event.getActivation().getId()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ClientSelfSourceInfo sourceInfo = (ClientSelfSourceInfo)element$iv;
                    boolean bl3 = false;
                    ClientSourceManager clientSourceManager = this.voiceClient.getSourceManager();
                    ClientSelfSourceInfo clientSelfSourceInfo = sourceInfo;
                    Intrinsics.checkNotNull((Object)clientSelfSourceInfo);
                    Optional optional = clientSourceManager.getSourceById(clientSelfSourceInfo.getSelfSourceInfo().getSourceInfo().getId());
                    Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getSourceById(...)");
                    ClientAudioSource clientAudioSource = (ClientAudioSource)OptionalsKt.getOrNull((Optional)optional);
                    if (!(clientAudioSource != null ? clientAudioSource.isActivated() : false)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean isActivated = bl;
        event.setRender(isActivated);
    }

    @EventSubscribe(ignoreCancelled=true)
    public final void onDistanceRender(@NotNull VoiceDistanceRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Flashback.isInReplay()) {
            return;
        }
        event.setCancelled(!CameraUtilKt.isCameraRemotePlayer());
    }

    @EventSubscribe(ignoreCancelled=true)
    public final void onAudioCaptureInitialize(@NotNull AudioCaptureInitializeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.setCancelled(Flashback.isInReplay());
    }

    @EventSubscribe(ignoreCancelled=true)
    public final void onAudioCapture(@NotNull AudioCaptureEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.setCancelled(Flashback.isInReplay());
    }

    @EventSubscribe
    public final void onSourceReset(@NotNull AudioSourceResetEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Flashback.isInReplay()) {
            return;
        }
        if (event.getCause() != AudioSourceResetEvent.Cause.SOURCE_STOPPED) {
            return;
        }
        event.setCancelled(true);
    }

    @EventSubscribe
    public final void onSourceWrite(@NotNull AlSourceWriteEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }
}

