package net.thefluffycart.litavis;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.minecraft.class_1928;
import net.minecraft.class_3962;
import net.thefluffycart.litavis.block.ModBlocks;
import net.thefluffycart.litavis.block.ModCompatBlocks;
import net.thefluffycart.litavis.block.entity.LitavisBlockEntityType;
import net.thefluffycart.litavis.entity.ModBoats;
import net.thefluffycart.litavis.entity.ModEntities;
import net.thefluffycart.litavis.entity.custom.BurrowEntity;
import net.thefluffycart.litavis.entity.custom.CopperGolemEntity;
import net.thefluffycart.litavis.item.ModItemGroups;
import net.thefluffycart.litavis.item.ModItems;
import net.thefluffycart.litavis.item.custom.TerraformerItem;
import net.thefluffycart.litavis.sound.ModSounds;
import net.thefluffycart.litavis.world.gen.ModWorldGeneration;
import net.thefluffycart.litavis.world.tree.ModTrunkPlacerTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Litavis implements ModInitializer {

	public static final String MOD_ID = "litavis";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

	@Override
	public void onInitialize() {

//		FuelRegistry.INSTANCE.add(ModBlocks.KINDLING, 1000);

		class_3962.field_17566.put(ModItems.TIRIM_BERRIES, 0.3f);
		class_3962.field_17566.put(ModBlocks.EUCALYPTUS_LEAVES.method_8389(), 0.3f);
		class_3962.field_17566.put(ModBlocks.EUCALYPTUS_SAPLING.method_8389(), 0.3f);

		registerStrippables();

		ModSounds.registerSounds();
		ModEntities.registerModEntities();
		ModItemGroups.registerItemGroups();
		ModItems.registerModItems();
		ModBlocks.registerModBlocks();
		ModBlocks.registerModBlocks();
		ModTrunkPlacerTypes.register();
		ModCompatBlocks.register();
//		LitavisBlockEntityType.registerAllBlockEntities();
		//ModBoats.registerBoats();
		ModWorldGeneration.generateModWorldGeneration();

		FabricDefaultAttributeRegistry.register(ModEntities.BURROW, BurrowEntity.createburrowAttributes());
		FabricDefaultAttributeRegistry.register(ModEntities.COPPER_GOLEM, CopperGolemEntity.createCopperGolemAttributes());
	}

	public static final class_1928.class_4313<class_1928.class_4310> EARTH_CHARGE_GRIEFING =
			GameRuleRegistry.register("earthChargeGriefing", class_1928.class_5198.field_24100, GameRuleFactory.createBooleanRule(true));

	public static final class_1928.class_4313<class_1928.class_4310> EARTH_CHARGE_RESTRICTED =
			GameRuleRegistry.register("earthChargeRestricted", class_1928.class_5198.field_24100, GameRuleFactory.createBooleanRule(false));

	public static final class_1928.class_4313<class_1928.class_4312> EARTH_CHARGE_COOLDOWN =
			GameRuleRegistry.register("earthChargeCooldown", class_1928.class_5198.field_24100, GameRuleFactory.createIntRule(300));

	public static final class_1928.class_4313<class_1928.class_4312> CAPSIZER_COOLDOWN =
			GameRuleRegistry.register("capsizerCooldown", class_1928.class_5198.field_24100, GameRuleFactory.createIntRule(200));

	private static void registerStrippables(){
		StrippableBlockRegistry.register(ModBlocks.EUCALYPTUS_LOG, ModBlocks.STRIPPED_EUCALYPTUS_LOG);
		StrippableBlockRegistry.register(ModBlocks.EUCALYPTUS_WOOD, ModBlocks.STRIPPED_EUCALYPTUS_WOOD);
	}
}


