package net.thefluffycart.litavis;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1921;
import net.thefluffycart.litavis.block.ModBlocks;
import net.thefluffycart.litavis.block.entity.LitavisBlockEntityType;
import net.thefluffycart.litavis.entity.ModBoats;
import net.thefluffycart.litavis.entity.ModEntities;
import net.thefluffycart.litavis.entity.client.*;
import net.thefluffycart.litavis.util.PlushieBlockRenderer;

public class LitavisClient implements ClientModInitializer {
    @Override
    public void onInitializeClient() {
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.EUCALYPTUS_DOOR, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.EUCALYPTUS_TRAPDOOR, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.EUCALYPTUS_SAPLING, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(ModBlocks.TIRIM_BERRY_BUSH, class_1921.method_23581());

        //RENDER THE BOAT, EARTH CHARGE, AND BURROW
        EntityModelLayerRegistry.registerModelLayer(ModEntityModelLayers.BURROW, BurrowModel::getTexturedModelData);
        EntityRendererRegistry.register(ModEntities.BURROW, BurrowRenderer::new);

        EntityModelLayerRegistry.registerModelLayer(ModEntityModelLayers.COPPER_GOLEM, CopperGolemModel::getTexturedModelData);
        EntityRendererRegistry.register(ModEntities.COPPER_GOLEM, CopperGolemRenderer::new);

        EntityModelLayerRegistry.registerModelLayer(ModEntityModelLayers.EARTH_CHARGE, EarthChargeModel::getTexturedModelData);
        EntityRendererRegistry.register(ModEntities.EARTH_CHARGE, EarthChargeRenderer::new);

    }
}
