package net.thefluffycart.litavis.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1750;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2459;
import net.minecraft.class_2465;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_5819;

public class CalibratedTripslateBlock extends class_2248 {
    public static final class_2746 LIT = class_2459.field_11446;
    public static final MapCodec<class_2465> CODEC = class_2465.method_54094(class_2465::new);
    public static final class_2754<class_2350.class_2351> AXIS = class_2741.field_12496;

    public CalibratedTripslateBlock(class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657(AXIS, class_2350.class_2351.field_11052));
        this.method_9590(this.method_9564().method_11657(LIT, false));

    }

    public MapCodec<? extends class_2465> method_53969() {
        return field_46280;
    }

    @Override
    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return class_2465.method_36377(state, rotation);
    }

    protected int getFallDelay()
    {
        return 200;
    }

    @Override
    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (neighborState.method_27852(this) && neighborState.method_11654(LIT)) {
            this.blockDrop(state, (class_3218) world, pos);
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        boolean bl = state.method_11654(LIT);
        if (bl != world.method_49803(pos)) {
            if (bl) {
                world.method_39279(pos, this, 4);
            } else {
                world.method_8652(pos, (class_2680)state.method_28493(LIT), class_2248.field_31028);
            }
        }
    }

    @Override
    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (state.method_11654(LIT).booleanValue() && !world.method_49803(pos)) {
            world.method_8652(pos, (class_2680)state.method_28493(LIT), class_2248.field_31028);
        }
    }

    public class_1282 getDamageSource(class_1297 attacker) {
        return attacker.method_48923().method_48810(attacker);
    }

    public void blockDrop(class_2680 state, class_3218 world, class_2338 pos) {
        if (!TripslateBlock.canFallThrough(world.method_8320(pos.method_10074())) || pos.method_10264() < world.method_31607()) {
            return;
        }
        if (state.method_27852(this)) {
            world.method_39279(pos, this, this.getFallDelay());
            world.method_8501(pos, state.method_28493(LIT));
            class_1540 fallingBlockEntity = class_1540.method_40005(world, pos, state);
            fallingBlockEntity.method_5747(1f, 5f, getDamageSource(fallingBlockEntity));
            world.method_22352(pos, false);
            for (class_2350 direction : class_2350.values()) {
                class_2338 neighborPos = pos.method_10093(direction);
                world.method_8408(neighborPos, this);
            }

            this.configureFallingBlockEntity(fallingBlockEntity);
        }
    }

    protected void configureFallingBlockEntity(class_1540 entity) {
        entity.method_6965(1.5F, 40);
    }

    public static boolean canFallThrough(class_2680 state) {
        return state.method_26215() || state.method_26164(class_3481.field_21952) || state.method_51176() || state.method_45474();
    }

    public static class_2680 changeRotation(class_2680 state, class_2470 rotation) {
        switch (rotation) {
            case field_11465:
            case field_11463: {
                switch (state.method_11654(AXIS)) {
                    case field_11048: {
                        return (class_2680)state.method_11657(AXIS, class_2350.class_2351.field_11051);
                    }
                    case field_11051: {
                        return (class_2680)state.method_11657(AXIS, class_2350.class_2351.field_11048);
                    }
                }
                return state;
            }
        }
        return state;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(AXIS);
        builder.method_11667(LIT);
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        this.method_9564().method_11657(LIT, Boolean.valueOf(ctx.method_8045().method_49803(ctx.method_8037())));
        return this.method_9564().method_11657(AXIS, ctx.method_8038().method_10166());
    }
}