package net.thefluffycart.litavis.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3965;
import net.minecraft.class_4481;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_9062;
import net.thefluffycart.litavis.item.ModItems;
import org.jetbrains.annotations.Nullable;

public class OilyLeavesBlock extends class_2397 {
    public static class_2746 HAS_OIL = class_2746.method_11825("has_oil");
    public static final MapCodec<class_4481> CODEC = method_54094(class_4481::new);

    public OilyLeavesBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(HAS_OIL, true));
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        boolean has_oil = (Boolean)state.method_11654(HAS_OIL);
        boolean bl = false;
        if (has_oil) {
            class_1792 item = stack.method_7909();
              if (stack.method_31574(class_1802.field_8469)) {
                stack.method_7934(1);
                world.method_43128(player, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14779, class_3419.field_15245, 1.0F, 1.0F);
                this.takeOil(world, state, pos);
                if (stack.method_7960()) {
                    player.method_6122(hand, new class_1799(ModItems.EUCALYPTUS_OIL_VIAL));
                } else if (!player.method_31548().method_7394(new class_1799(ModItems.EUCALYPTUS_OIL_VIAL))) {
                    player.method_7328(new class_1799(ModItems.EUCALYPTUS_OIL_VIAL), false);
                }

                bl = true;
                world.method_33596(player, class_5712.field_28167, pos);
            }

            if (!world.method_8608() && bl) {
                player.method_7259(class_3468.field_15372.method_14956(item));
            }
        }
        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        float f = random.method_43057();
        boolean has_oil = (Boolean)state.method_11654(HAS_OIL);
        if (has_oil)
        {
            if (!(f > 0.05F)) {
                if (EucalyptusLeavesBlock.canSpawnParticles(world.method_8320(pos.method_10074())))
                {
                    createParticle(world, pos, state, random);
                }
            }
        }
    }

    private static void createParticle(class_1937 world, class_2338 pos, class_2680 state, class_5819 random) {
        class_243 vec3d = state.method_26226(world, pos);
        double d = (double)0.0625F;
        double e = (double)pos.method_10263() + (double)0.5F + vec3d.field_1352 + (random.method_43058() - 0.5);
        double f = (double)((float)(pos.method_10264() + 0.6) - 0.6875F) - (double)0.0625F;
        double g = (double)pos.method_10260() + (double)0.5F + vec3d.field_1350 + (random.method_43058() - 0.5);
        class_2394 particleEffect = class_2398.field_20534;
        world.method_8406(particleEffect, e, f, g, (double)0.0, (double)0.0F, (double)0.0F);
    }

    public void takeOil(class_1937 world, class_2680 state, class_2338 pos) {
        world.method_8652(pos, (class_2680)state.method_11657(HAS_OIL, false), 3);
    }

    public static boolean canSpawnParticles(class_2680 state)
    {
        return state.method_26215();
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(HAS_OIL);
    }
}
