package net.thefluffycart.litavis.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_9062;
import net.thefluffycart.litavis.item.ModItems;

import java.util.function.ToIntFunction;

public class TirimBerryBushBlock extends class_2261
        implements class_2256 {
    public static final MapCodec<TirimBerryBushBlock> CODEC = TirimBerryBushBlock.method_54094(TirimBerryBushBlock::new);
    private static final float MIN_MOVEMENT_FOR_DAMAGE = 0.003f;
    public static final int MAX_AGE = 3;
    public static final class_2758 AGE = class_2741.field_12497;
    private static final class_265 SMALL_SHAPE = class_2248.method_9541(3.0, 0.0, 3.0, 13.0, 8.0, 13.0);
    private static final class_265 LARGE_SHAPE = class_2248.method_9541(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);

    public MapCodec<TirimBerryBushBlock> method_53969() {
        return field_46280;
    }

    public TirimBerryBushBlock(class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(AGE, 0));
    }

    @Override
    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        return new class_1799(ModItems.TIRIM_BERRIES);
    }



    @Override
    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (state.method_11654(AGE) == 0) {
            return SMALL_SHAPE;
        }
        if (state.method_11654(AGE) < 3) {
            return LARGE_SHAPE;
        }
        return super.method_9530(state, world, pos, context);
    }

        @Override
    protected boolean method_9542(class_2680 state) {
        return state.method_11654(AGE) < 3;
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        int i = pos.method_10263();
        int j = pos.method_10264();
        int k = pos.method_10260();
        double d = (double)i + random.method_43058();
        double e = (double)j + 0.7;
        double f = (double)k + random.method_43058();
        world.method_8406(class_2398.field_28803, d, e, f, (double)0.0F, (double)0.0F, (double)0.0F);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        if(state.method_11654(AGE) == 3)
        {
            for(int l = 0; l < 14; ++l) {
                mutable.method_10103(i + class_3532.method_15395(random, 10, -10), j - random.method_43048(10), k + class_3532.method_15395(random, 10, -10));
                class_2680 blockState = world.method_8320(mutable);
                if (!blockState.method_26234(world, mutable)) {
                    world.method_8406(class_2398.field_28479, d, e, f, (double)0.0F, (double)0.0F, (double)0.0F);
                }
            }
        }
    }

    @Override
    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        int i = state.method_11654(AGE);
        if (i < 3 && random.method_43048(5) == 0) {
            class_2680 blockState = (class_2680)state.method_11657(AGE, i + 1);
            world.method_8652(pos, blockState, class_2248.field_31028);
            world.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43287(blockState));
        }
        class_2338.class_2339 mutable = new class_2338.class_2339();
        mutable.method_10103(i + class_3532.method_15395(random, -5, 5), 8 - random.method_43048(5), 8 + class_3532.method_15395(random, -5, 5));
    }

    @Override
    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (!(entity instanceof class_1309) || entity.method_5864() == class_1299.field_17943 || entity.method_5864() == class_1299.field_20346) {
            return;
        }
        if (!(world.field_9236 || state.method_11654(AGE) <= 0 || entity.field_6038 == entity.method_23317() && entity.field_5989 == entity.method_23321())) {
            double d = Math.abs(entity.method_23317() - entity.field_6038);
            double e = Math.abs(entity.method_23321() - entity.field_5989);
        }
    }

    @Override
    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        boolean bl;
        int i = state.method_11654(AGE);
        boolean bl2 = bl = i == 3;
        if (!bl && stack.method_31574(class_1802.field_8324)) {
            return class_9062.field_47732;
        }
        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }

    @Override
    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        boolean bl;
        int i = state.method_11654(AGE);
        boolean bl2 = bl = i == 3;
        if (i > 1) {
            int j = 1 + world.field_9229.method_43048(2);
            TirimBerryBushBlock.method_9577(world, pos, new class_1799(ModItems.TIRIM_BERRIES, j + (bl ? 1 : 0)));
            world.method_8396(null, pos, class_3417.field_17617, class_3419.field_15245, 1.0f, 0.8f + world.field_9229.method_43057() * 0.4f);
            class_2680 blockState = (class_2680)state.method_11657(AGE, 1);
            world.method_8652(pos, blockState, class_2248.field_31028);
            world.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43286(player, blockState));
            return class_1269.method_29236(world.field_9236);
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(AGE);
    }

    @Override
    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
        return state.method_11654(AGE) < 3;
    }

    @Override
    public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return true;
    }

    @Override
    public void method_9652(class_3218 world, class_5819 random, class_2338 pos, class_2680 state) {
        int i = Math.min(3, state.method_11654(AGE) + 1);
        world.method_8652(pos, (class_2680)state.method_11657(AGE, i), class_2248.field_31028);
    }
    public static ToIntFunction<class_2680> getLuminanceSupplier(int luminance) {
        return state -> state.method_11654(AGE) > 2 ? luminance : 0;
    }

}