package net.thefluffycart.litavis.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import net.thefluffycart.litavis.entity.ModEntities;
import net.thefluffycart.litavis.entity.custom.EarthChargeEntity;

public class TripslateBlock extends class_2248 {
    public static final class_2746 FALLING = class_2746.method_11825("falling");
    public static final MapCodec<class_2465> field_46280 = class_2465.method_54094(class_2465::new);
    public static final class_2754<class_2350.class_2351> AXIS = class_2741.field_12496;

    public TripslateBlock(class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657(AXIS, class_2350.class_2351.field_11052));
        this.method_9590(this.method_9564().method_11657(FALLING, false));

    }

    @Override
    protected void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        method_9588(state, (class_3218) world, pos, class_5819.method_43047());
        super.method_9615(state, world, pos, oldState, notify);
    }

    @Override
    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        boolean bl = state.method_11654(FALLING);
        if (bl)
        {
            blockDrop(state, world, pos);
        }
        super.method_9588(state, world, pos, random);
    }

    public MapCodec<? extends class_2465> method_53969() {
        return field_46280;
    }

    @Override
    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return class_2465.method_36377(state, rotation);
    }

    protected int getFallDelay()
    {
        return 200;
    }

    @Override
    protected void method_19286(class_1937 world, class_2680 state, class_3965 hit, class_1676 projectile) {
        class_2338 blockPos = hit.method_17777();
        if (!world.field_9236 && state.method_27852(this) && !(projectile instanceof EarthChargeEntity)) {
            blockDrop(state, (class_3218) world, blockPos);
        }
    }

    @Override
    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (neighborState.method_27852(this) && neighborState.method_11654(FALLING)) {
            this.blockDrop(state, (class_3218) world, pos);
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        boolean bl = state.method_11654(FALLING);
        if (bl != FALLING.equals(Boolean.FALSE)) {
            if (bl) {
                world.method_39279(pos, this, 4);
            } else {
                world.method_8652(pos, (class_2680)state.method_28493(FALLING), class_2248.field_31028);
            }
        }
    }

    public class_1282 getDamageSource(class_1297 attacker) {
        return attacker.method_48923().method_48810(attacker);
    }

    public void blockDrop(class_2680 state, class_3218 world, class_2338 pos) {
        if (!TripslateBlock.canFallThrough(world.method_8320(pos.method_10074())) || pos.method_10264() < world.method_31607()) {
            return;
        }
        if (state.method_27852(this)) {
            world.method_8652(pos, class_2246.field_10124.method_9564(), class_2248.field_31036);
            class_1540 fallingBlockEntity = class_1540.method_40005(world, pos, state);
            fallingBlockEntity.method_5747(1f, 5f, getDamageSource(fallingBlockEntity));
            this.configureFallingBlockEntity(fallingBlockEntity);
            fallingBlockEntity.field_6037 = true;
            for (class_2350 direction : class_2350.values()) {
                class_2338 neighborPos = pos.method_10093(direction);
                class_2680 neighborState = world.method_8320(neighborPos);
                if (neighborState.method_27852(this)) {
                    blockDrop(neighborState, world, neighborPos);
                } else {
                    world.method_8408(neighborPos, this);
                }
            }
        }
    }

    protected void configureFallingBlockEntity(class_1540 entity) {
        entity.method_6965(1.5F, 40);
    }

    public static boolean canFallThrough(class_2680 state) {
        return state.method_26215() || state.method_26164(class_3481.field_21952) || state.method_51176() || state.method_45474();
    }

    public static class_2680 changeRotation(class_2680 state, class_2470 rotation) {
        switch (rotation) {
            case field_11465:
            case field_11463: {
                switch (state.method_11654(AXIS)) {
                    case field_11048: {
                        return (class_2680)state.method_11657(AXIS, class_2350.class_2351.field_11051);
                    }
                    case field_11051: {
                        return (class_2680)state.method_11657(AXIS, class_2350.class_2351.field_11048);
                    }
                }
                return state;
            }
        }
        return state;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(AXIS);
        builder.method_11667(FALLING);
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        this.method_9564().method_11657(FALLING, Boolean.FALSE);
        return this.method_9564().method_11657(AXIS, ctx.method_8038().method_10166());
    }
}
