package net.thefluffycart.litavis.block.entity;

import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.*;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PlushieBlockEntity extends class_2586 implements GeoBlockEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache(this);
    private boolean shouldPlayAnimation = false;

    public PlushieBlockEntity(class_2338 pos, class_2680 state) {
        super(LitavisBlockEntityType.PLUSHIE_BLOCK_ENTITY, pos, state);
    }

    public void triggerAnimation() {
        shouldPlayAnimation = true;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController<>(
                this,
                "controller",
                0,
                state -> {
                    if (shouldPlayAnimation) {
                        System.out.println("Playing animtion");
                        state.setAnimation(RawAnimation.begin().then("animation.plush.squeak", Animation.LoopType.PLAY_ONCE));
                        return PlayState.CONTINUE;
                    }
                    shouldPlayAnimation = false;
                    return PlayState.STOP;
                }
        ));
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return cache;
    }
}