package net.thefluffycart.litavis.datagen;

import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.data.client.*;
import net.thefluffycart.litavis.block.ModBlocks;
import net.thefluffycart.litavis.block.custom.TirimBerryBushBlock;
import net.thefluffycart.litavis.item.ModItems;

import java.util.Optional;

public class ModModelProvider extends FabricModelProvider {
    public ModModelProvider(FabricDataOutput output) {
        super(output);
    }

    @Override
    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        class_4910.class_4912 graniteBrickTexturePool = blockStateModelGenerator.method_25650(ModBlocks.GRANITE_BRICKS);
        class_4910.class_4912 crackedGraniteBrickTexturePool = blockStateModelGenerator.method_25650(ModBlocks.CRACKED_GRANITE_BRICKS);
        class_4910.class_4912 mossyGraniteBrickTexturePool = blockStateModelGenerator.method_25650(ModBlocks.MOSSY_GRANITE_BRICKS);
        class_4910.class_4912 tripslateBrickTexturePool = blockStateModelGenerator.method_25650(ModBlocks.TRIPSLATE_BRICKS);
        class_4910.class_4912 mossyTripslateBrickTexturePool = blockStateModelGenerator.method_25650(ModBlocks.MOSSY_TRIPSLATE_BRICKS);
        class_4910.class_4912 crackedTripslateBrickTexturePool = blockStateModelGenerator.method_25650(ModBlocks.CRACKED_TRIPSLATE_BRICKS);
        class_4910.class_4912 eucalyptusTexturePool = blockStateModelGenerator.method_25650(ModBlocks.EUCALYPTUS_PLANKS);

        graniteBrickTexturePool.method_25725(ModBlocks.GRANITE_BRICK_STAIRS);
        graniteBrickTexturePool.method_25724(ModBlocks.GRANITE_BRICK_SLAB);
        graniteBrickTexturePool.method_25720(ModBlocks.GRANITE_BRICK_WALL);

        crackedGraniteBrickTexturePool.method_25725(ModBlocks.CRACKED_GRANITE_BRICK_STAIRS);
        crackedGraniteBrickTexturePool.method_25724(ModBlocks.CRACKED_GRANITE_BRICK_SLAB);
        crackedGraniteBrickTexturePool.method_25720(ModBlocks.CRACKED_GRANITE_BRICK_WALL);

        mossyGraniteBrickTexturePool.method_25725(ModBlocks.MOSSY_GRANITE_BRICK_STAIRS);
        mossyGraniteBrickTexturePool.method_25724(ModBlocks.MOSSY_GRANITE_BRICK_SLAB);
        mossyGraniteBrickTexturePool.method_25720(ModBlocks.MOSSY_GRANITE_BRICK_WALL);


        tripslateBrickTexturePool.method_25725(ModBlocks.TRIPSLATE_BRICK_STAIRS);
        tripslateBrickTexturePool.method_25724(ModBlocks.TRIPSLATE_BRICK_SLAB);
        tripslateBrickTexturePool.method_25720(ModBlocks.TRIPSLATE_BRICK_WALL);

        crackedTripslateBrickTexturePool.method_25725(ModBlocks.CRACKED_TRIPSLATE_BRICK_STAIRS);
        crackedTripslateBrickTexturePool.method_25724(ModBlocks.CRACKED_TRIPSLATE_BRICK_SLAB);
        crackedTripslateBrickTexturePool.method_25720(ModBlocks.CRACKED_TRIPSLATE_BRICK_WALL);

        mossyTripslateBrickTexturePool.method_25725(ModBlocks.MOSSY_TRIPSLATE_BRICK_STAIRS);
        mossyTripslateBrickTexturePool.method_25724(ModBlocks.MOSSY_TRIPSLATE_BRICK_SLAB);
        mossyTripslateBrickTexturePool.method_25720(ModBlocks.MOSSY_TRIPSLATE_BRICK_WALL);

        blockStateModelGenerator.method_25676(ModBlocks.EUCALYPTUS_LOG).method_25730(ModBlocks.EUCALYPTUS_LOG).method_25728(ModBlocks.EUCALYPTUS_WOOD);
        blockStateModelGenerator.method_25676(ModBlocks.STRIPPED_EUCALYPTUS_LOG).method_25730(ModBlocks.STRIPPED_EUCALYPTUS_LOG).method_25728(ModBlocks.STRIPPED_EUCALYPTUS_WOOD);

        blockStateModelGenerator.method_25603(ModBlocks.EUCALYPTUS_SAPLING, class_4910.class_4913.field_22840);

        eucalyptusTexturePool.method_25725(ModBlocks.EUCALYPTUS_STAIRS);
        eucalyptusTexturePool.method_25724(ModBlocks.EUCALYPTUS_SLAB);
        eucalyptusTexturePool.method_25716(ModBlocks.EUCALYPTUS_BUTTON);
        eucalyptusTexturePool.method_25723(ModBlocks.EUCALYPTUS_PRESSURE_PLATE);
        eucalyptusTexturePool.method_25721(ModBlocks.EUCALYPTUS_FENCE);
        eucalyptusTexturePool.method_25722(ModBlocks.EUCALYPTUS_FENCE_GATE);

        blockStateModelGenerator.method_25658(ModBlocks.EUCALYPTUS_DOOR);
        blockStateModelGenerator.method_25665(ModBlocks.EUCALYPTUS_TRAPDOOR);

        blockStateModelGenerator.method_49374(ModBlocks.TIRIM_BERRY_BUSH, class_4910.class_4913.field_22840,
                TirimBerryBushBlock.AGE, 0, 1, 2, 3);
    }

    @Override
    public void generateItemModels(class_4915 itemModelGenerator) {
        itemModelGenerator.method_25733(ModItems.BURIED_DISC_FRAGMENT, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.RELIC_DISC_FRAGMENT, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.ECHOES_MUSIC_DISC, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.BURROW_ROD, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.TERRA_POTTERY_SHERD, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.TOMB_POTTERY_SHERD, class_4943.field_22938);
//        itemModelGenerator.register(ModItems.HANGING_EUCALYPTUS_SIGN, Models.GENERATED);
//        itemModelGenerator.register(ModItems.EUCALYPTUS_BOAT, Models.GENERATED);
//        itemModelGenerator.register(ModItems.EUCALYPTUS_CHEST_BOAT, Models.GENERATED);
        itemModelGenerator.method_25733(ModBlocks.EUCALYPTUS_SAPLING.method_8389(), class_4943.field_22938);
//        itemModelGenerator.register(ModItems.HANGING_CRISPEN_SIGN, Models.GENERATED);
//        itemModelGenerator.register(ModItems.CRISPEN_BOAT, Models.GENERATED);
//        itemModelGenerator.register(ModItems.CRISPEN_CHEST_BOAT, Models.GENERATED);
        itemModelGenerator.method_25733(ModItems.ARCHAIC_KEY, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.TUNING_FORK, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.EARTH_CHARGE, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.ENTOMBED_ARMOR_TRIM_SMITHING_TEMPLATE, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.DRIP_ARMOR_TRIM_SMITHING_TEMPLATE, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.EUCALYPTUS_OIL_VIAL, class_4943.field_22938);
        itemModelGenerator.method_25733(ModItems.BURROW_SPAWN_EGG,
                new class_4942(Optional.of(class_2960.method_60654("item/template_spawn_egg")), Optional.empty()));
    }
}
