package net.thefluffycart.litavis.entity.ai.goals;

import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.util.math.*;
import net.thefluffycart.litavis.entity.custom.BurrowEntity;

import java.util.EnumSet;
import java.util.EnumSet;
import java.util.List;

public class BurrowCharge extends class_1352 {
    private final BurrowEntity burrow;
    private class_1657 victim;


    private int chargeTimer = 0;
    private static final int CHARGE_DURATION = 40;
    private static final double CHARGE_SPEED = 1.05;
    private static final int PREPARE_DURATION = 40;
    private static final float DAMAGE_AMOUNT = 5f;
    private boolean lockRotation = false;
    private float lockedYaw;
    private float lockedPitch;

    public BurrowCharge(BurrowEntity burrow) {
        this.burrow = burrow;
        this.method_6265(EnumSet.of(class_4134.field_18405, class_4134.field_18406));
    }

    @Override
    public boolean method_6264() {
        victim = burrow.method_37908().method_18460(burrow, 20.0D);
        return victim != null
                && burrow.method_6057(victim)
                && !victim.method_7337()
                && (burrow.getState() == BurrowEntity.State.IDLE || burrow.getState() == BurrowEntity.State.CHARGE);
    }

    @Override
    public void method_6269() {
        chargeTimer = 0;
        burrow.setState(BurrowEntity.State.CHARGE);
    }

    @Override
    public void method_6270() {
        burrow.setState(BurrowEntity.State.IDLE);
        this.lockRotation = false;
        chargeTimer = 0;
        burrow.method_5942().method_6340();
        burrow.method_18799(class_243.field_1353);
    }

    @Override
    public void method_6268() {
        if (victim != null && !lockRotation) {
            class_243 targetPos = victim.method_19538();
            class_243 mobPos = burrow.method_19538();
            double dx = targetPos.field_1352 - mobPos.field_1352;
            double dz = targetPos.field_1350 - mobPos.field_1350;
            double dy = (targetPos.field_1351 + victim.method_5751()) - (mobPos.field_1351 + burrow.method_5751());

            float targetYaw = (float) (class_3532.method_15349(-dx, dz) * (180.0 / Math.PI));

            burrow.method_36456(class_3532.method_16439((float) 0.5, burrow.method_36454(), targetYaw));
            burrow.method_5636(burrow.method_36454());
            burrow.method_5847(burrow.method_36454());

            float targetPitch = (float) (class_3532.method_15349(dy, Math.sqrt(dx * dx + dz * dz)) * (180.0 / Math.PI));

            burrow.method_36457(class_3532.method_16439((float) 0.3, burrow.method_36455(), targetPitch));

        }

        else if (lockRotation) {
            burrow.method_36456(lockedYaw);
            burrow.method_36457(lockedPitch);
            burrow.method_5636(lockedYaw);
            burrow.method_5847(lockedYaw);
        }

        switch (burrow.getState()) {
            case CHARGE -> prepareToCharge();
            case DASH -> startCharge();
        }
    }

    @Override
    public boolean method_6266() {
        return burrow.getState() == BurrowEntity.State.CHARGE || burrow.getState() == BurrowEntity.State.DASH;
    }

    private void prepareToCharge() {
        lockRotation = false;
        burrow.method_5942().method_6340();
        if (++chargeTimer >= PREPARE_DURATION) {
            burrow.setState(BurrowEntity.State.DASH);
            chargeTimer = 0;
            class_243 direction = victim.method_19538().method_1020(burrow.method_19538()).method_1029().method_1021(CHARGE_SPEED);
            burrow.method_18799(direction);
            lockedYaw = burrow.method_36454();
            lockedPitch = burrow.method_36455();
        }
    }

    private void startCharge() {
        this.lockRotation = true;
        class_243 velocity = burrow.method_18798().method_1029().method_1021(CHARGE_SPEED);
        burrow.method_18799(velocity);
        class_238 boundingBox = burrow.method_5829();
        class_2338 min = new class_2338((int) boundingBox.field_1323, (int) boundingBox.field_1322, (int) boundingBox.field_1321);
        class_2338 max = new class_2338((int) boundingBox.field_1320, (int) boundingBox.field_1325, (int) boundingBox.field_1324);
        class_238 collisionBox = burrow.method_5829();
        List<class_1309> entities = burrow.method_37908().method_8390(
                class_1309.class,
                collisionBox,
                entity -> entity != burrow
        );

        for (class_1309 entity : entities) {
            entity.method_5643(burrow.method_48923().method_48812(burrow), DAMAGE_AMOUNT);
        }

        if (!burrow.method_37908().field_9236) {
            class_2338 frontPos = burrow.method_24515().method_10093(burrow.method_5735());
            class_2680 blockState = burrow.method_37908().method_8320(frontPos);
            for (class_2338 pos : class_2338.method_10097(min, max)) {
                if (burrow.method_37908().method_8320(pos).method_26212(burrow.method_37908(), pos)) {
                    method_6270();
                    return;
                }
            }
            for (class_1309 entity : entities) {
                entity.method_5643(burrow.method_48923().method_48812(burrow), DAMAGE_AMOUNT);
                method_6270();
                return;
            }
            if (++chargeTimer >= CHARGE_DURATION || burrow.method_30949(victim)) {
                burrow.setState(BurrowEntity.State.IDLE);
                method_6270();
            }
        }
    }
}