package net.thefluffycart.litavis.entity.ai.goals;

import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1540;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.thefluffycart.litavis.entity.custom.BurrowEntity;
import net.thefluffycart.litavis.util.ModTags;

import java.util.EnumSet;
import java.util.List;

public class GroundPound extends class_1352 {
    private final BurrowEntity burrow;
    private class_1657 victim;
    private int cooldown;
    private class_2338 BurrowBlockPos;



    @Override
    public boolean method_6264() {
        victim = burrow.method_37908().method_18460(burrow, 20.0D);
        return victim != null
                && burrow.method_6057(victim)
                && !victim.method_7337();
    }

    public GroundPound(BurrowEntity burrow) {
        this.burrow = burrow;
        this.cooldown = 0;
        this.method_6265(EnumSet.of(class_4134.field_18405, class_4134.field_18406));
    }

    @Override
    public void method_6270() {
        burrow.method_5942().method_6356();
        burrow.method_18799(class_243.field_1353);
    }

    @Override
    public void method_6268() {
        class_1937 BurrowWorld = burrow.method_37908();
        burrow.method_19538().method_10215();
        if (victim != null && cooldown <= 0) {
            burrow.method_5942().method_6340();
            BurrowBlockPos = burrow.method_24515();
            for (int x = -2; x <= 2; x++) {
                for (int z = -2; z <= 2; z++) {
                    if (Math.abs(x) == 2 && Math.abs(z) == 2) {
                        continue;
                    }
                    if (Math.abs(x) == 0 && Math.abs(z) == 0) {
                        continue;
                    }
                    class_2338 targetPos = BurrowBlockPos.method_10069(x, -1, z);
                    if (targetPos.equals(BurrowBlockPos.method_10074())) {
                        continue;
                    }
                    class_2680 blockState = BurrowWorld.method_8320(targetPos);
                    if (blockState.method_26164(ModTags.Blocks.EARTH_CHARGE_THROWABLE) || blockState.method_26164(class_3481.field_15503) || blockState.method_26164(class_3481.field_15475)) {
                        entityLaunch((class_3218) BurrowWorld, BurrowBlockPos);
                        spawnUpperFallingBlock((class_3218) BurrowWorld, targetPos, blockState);
                        BurrowWorld.method_8650(targetPos, false);
                        cooldown = 180;
                    }
                }
            }
        }
        else
            {
                cooldown--;
            }
    }

    private void entityLaunch(class_3218 serverWorld, class_2338 pos) {
        class_238 impactBox = new class_238(pos).method_1009(2.5, 2.5, 2.5);
        List<class_1309> nearbyEntities = serverWorld.method_8390(
                class_1309.class,
                impactBox,
                entity -> true
        );

        for (class_1309 entity : nearbyEntities) {
            if (entity != this.burrow)
            {
                class_243 currentMotion = entity.method_18798();
                entity.method_5762(currentMotion.field_1352, 0.5, currentMotion.field_1350);
                entity.field_6037 = true;
            }
        }
    }

    private void spawnUpperFallingBlock(class_3218 world, class_2338 pos, class_2680 blockState) {
        class_1540 fallingBlockEntity = class_1540.method_40005(world, pos, blockState);
            fallingBlockEntity.method_23327(pos.method_10263() + 0.5, pos.method_10264(), pos.method_10260() + 0.5);
            fallingBlockEntity.method_18799(new class_243(0, 1.02, 0));
            fallingBlockEntity.field_6037 = true;
            world.method_8649(fallingBlockEntity);
    }
}
