package net.thefluffycart.litavis.entity.client;

import com.google.common.collect.Maps;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_927;
import net.thefluffycart.litavis.Litavis;
import net.thefluffycart.litavis.entity.custom.BurrowEntity;
import net.thefluffycart.litavis.entity.variant.BurrowVariant;

import java.util.Map;

public class BurrowRenderer extends class_927<BurrowEntity, BurrowModel>
{
    private static final Map<BurrowVariant, class_2960> LOCATION_BY_VARIANT =
            class_156.method_654(Maps.newEnumMap(BurrowVariant.class), map -> {
                map.put(BurrowVariant.BURROW_BASE, class_2960.method_60655(Litavis.MOD_ID, "textures/entity/burrow/burrow.png"));
                map.put(BurrowVariant.BLACK, class_2960.method_60655(Litavis.MOD_ID, "textures/entity/burrow/black_burrow.png"));
                map.put(BurrowVariant.BLUE, class_2960.method_60655(Litavis.MOD_ID, "textures/entity/burrow/blue_burrow.png"));
                map.put(BurrowVariant.BROWN, class_2960.method_60655(Litavis.MOD_ID, "textures/entity/burrow/brown_burrow.png"));
                map.put(BurrowVariant.CYAN, class_2960.method_60655(Litavis.MOD_ID, "textures/entity/burrow/cyan_burrow.png"));
                map.put(BurrowVariant.GRAY, class_2960.method_60655(Litavis.MOD_ID, "textures/entity/burrow/gray_burrow.png"));
                map.put(BurrowVariant.GREEN, class_2960.method_60655(Litavis.MOD_ID, "textures/entity/burrow/green_burrow.png"));
                map.put(BurrowVariant.LIGHT_BLUE, class_2960.method_60655(Litavis.MOD_ID, "textures/entity/burrow/light_blue_burrow.png"));
                map.put(BurrowVariant.LIGHT_GRAY, class_2960.method_60655(Litavis.MOD_ID, "textures/entity/burrow/light_gray_burrow.png"));
                map.put(BurrowVariant.LIME, class_2960.method_60655(Litavis.MOD_ID, "textures/entity/burrow/lime_burrow.png"));
                map.put(BurrowVariant.MAGENTA, class_2960.method_60655(Litavis.MOD_ID, "textures/entity/burrow/magenta_burrow.png"));
                map.put(BurrowVariant.ORANGE, class_2960.method_60655(Litavis.MOD_ID, "textures/entity/burrow/orange_burrow.png"));
                map.put(BurrowVariant.PINK, class_2960.method_60655(Litavis.MOD_ID, "textures/entity/burrow/pink_burrow.png"));
                map.put(BurrowVariant.PURPLE, class_2960.method_60655(Litavis.MOD_ID, "textures/entity/burrow/purple_burrow.png"));
                map.put(BurrowVariant.RED, class_2960.method_60655(Litavis.MOD_ID, "textures/entity/burrow/red_burrow.png"));
                map.put(BurrowVariant.WHITE, class_2960.method_60655(Litavis.MOD_ID, "textures/entity/burrow/white_burrow.png"));
                map.put(BurrowVariant.YELLOW, class_2960.method_60655(Litavis.MOD_ID, "textures/entity/burrow/yellow_burrow.png"));
                map.put(BurrowVariant.LAYERED, class_2960.method_60655(Litavis.MOD_ID, "textures/entity/burrow/layered_burrow.png"));
            });
    public BurrowRenderer(class_5617.class_5618 context) {
        super(context, new BurrowModel(context.method_32167(ModEntityModelLayers.BURROW)), .2f);
    }

    @Override
    public class_2960 getTexture(BurrowEntity entity) {
        return LOCATION_BY_VARIANT.get(entity.getVariant());
    }

    @Override
    public void render(BurrowEntity livingEntity, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {

        super.method_4054(livingEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }
}
