package net.thefluffycart.litavis.entity.custom;

import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1315;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6053;
import net.minecraft.class_7094;
import net.minecraft.entity.ai.goal.*;
import net.thefluffycart.litavis.entity.ai.goals.BurrowCharge;
import net.thefluffycart.litavis.entity.ai.goals.GroundPound;
import net.thefluffycart.litavis.entity.variant.BurrowVariant;
import net.thefluffycart.litavis.sound.ModSounds;
import org.jetbrains.annotations.Nullable;

public class BurrowEntity extends class_1588 {
    private static final class_2940<Integer> DATA_ID_TYPE_VARIANT =
            class_2945.method_12791(BurrowEntity.class, class_2943.field_13327);

    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 chargeAnimationState = new class_7094();
    public final class_7094 dashAnimationState = new class_7094();

    private int idleAnimationTimeout = 0;
    private int chargeAnimationTimeout = 0;
    private int dashAnimationTimeout = 0;
    public static boolean doIdle = true;
    public static boolean doCharge = false;
    public static boolean doDash = false;
    private static final class_2940<Byte> BURROW_FLAGS = class_2945.method_12791(BurrowEntity.class, class_2943.field_13319);

    public BurrowEntity(class_1299<? extends BurrowEntity> entityType, class_1937 world) {
        super((class_1299<? extends class_1588>)entityType, world);
        this.field_6194 = 15;
    }
    private State state = State.IDLE;

    public enum State {
        IDLE,
        CHARGE,
        DASH,
        BURROWED
    }

    public void setState(State newState) {
        if (state != newState)
        {
            this.state = newState;
            switch (this.state) {
                case IDLE -> {
                    doIdle = true;
                    doCharge = false;
                    doDash = false;
                    idleAnimationTimeout = 0;
                    idleAnimationState.method_41322(this.field_6012);
                }
                case CHARGE -> {
                    doIdle = false;
                    doCharge = true;
                    doDash = false;
                    chargeAnimationTimeout = 0;
                    chargeAnimationState.method_41322(this.field_6012);
                }
                case DASH -> {
                    doIdle = false;
                    doCharge = false;
                    doDash = true;
                    dashAnimationTimeout = 0;
                    dashAnimationState.method_41322(this.field_6012);
                }
            }
        }
    }

    public State getState() {
        return this.state;
    }


    private void setupAnimationStates() {
            if(doIdle)
        {
            if(this.idleAnimationTimeout <= 0) {
                this.idleAnimationTimeout = 40;
                this.idleAnimationState.method_41322(this.field_6012);
            } else {
                --this.idleAnimationTimeout;
            }
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            setupAnimationStates();
        }
    }

        //BURROW GOALS
        protected void method_5959() {
        this.field_6201.method_6277(2, new class_1361(this, class_1657.class, 8.0f));
        this.field_6201.method_6277(3, new BurrowCharge(this));
        this.field_6201.method_6277(5, new class_1394(this, 0.65));
        this.field_6201.method_6277(6, new class_1376(this));
        this.field_6185.method_6277(1, new class_1399(this));
        this.field_6185.method_6277(2, new class_1400<>(this, class_1657.class, true).method_6330(300));
        this.field_6185.method_6277(3, new class_1400<>(this, class_6053.class, true).method_6330(300));
    }

    public static class_5132.class_5133 createburrowAttributes() {
        return class_1588.method_26918()
                .method_26868(class_5134.field_23721, 2f)
                .method_26868(class_5134.field_23719, (double)0.285F)
                .method_26868(class_5134.field_23716, 32f)
                .method_26868(class_5134.field_23718, 20f)
                .method_26868(class_5134.field_23717, 20f);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DATA_ID_TYPE_VARIANT, 0);
        super.method_5693(builder);
        builder.method_56912(BURROW_FLAGS, (byte)0);
    }

    @Override
    public boolean method_29503() {
        return true;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    @Override
    protected class_3414 method_5994() {
        return ModSounds.BURROW_IDLE;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.BURROW_GROAN;
    }

    @Override
    protected class_3414 method_6002() {
        return ModSounds.BURROW_GROAN;
    }

    //BURROW VARIANTS

    private int getTypeVariant() {
        return this.field_6011.method_12789(DATA_ID_TYPE_VARIANT);
    }

    public BurrowVariant getVariant() {
        return BurrowVariant.byId(this.getTypeVariant());
    }

    public void setVariant(BurrowVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, variant.getId());
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        BurrowVariant variant = getWeightedRandomVariant();
        setVariant(variant);
         return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, nbt.method_10550("Variant"));
    }

    private BurrowVariant getWeightedRandomVariant() {
        float[] weights = {75,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,5};
        BurrowVariant[] variants = BurrowVariant.values();
        int totalWeight = 0;

        for (float weight : weights) {
            totalWeight += weight;
        }
        int randomWeight = this.field_5974.method_43048(totalWeight);

        int cumulativeWeight = 0;
        for (int i = 0; i < variants.length; i++) {
            cumulativeWeight += (int) weights[i];
            if (randomWeight < cumulativeWeight) {
                return variants[i];
            }
        }
        return variants[0];
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getTypeVariant());
    }
}