package net.thefluffycart.litavis.entity.custom;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1540;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3857;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.thefluffycart.litavis.Litavis;
import net.thefluffycart.litavis.entity.ModEntities;
import net.thefluffycart.litavis.item.ModItems;
import net.thefluffycart.litavis.util.ModTags;

import java.util.List;

public class EarthChargeEntity extends class_3857 {
    public EarthChargeEntity(class_1299<? extends class_3857> entityType, class_1937 world) {
        super(entityType, world);
    }

    public EarthChargeEntity(class_1937 world, class_1309 owner) {
        super(ModEntities.EARTH_CHARGE, owner, world); // null will be changed later
    }

    @Environment(EnvType.CLIENT)
    private class_2394 getParticleParameters() {
        class_1799 itemStack = this.method_7495();
        return (class_2394)(itemStack.method_7960() ? class_2398.field_11251 : new class_2392(class_2398.field_11218, itemStack));
    }

    @Override
    public boolean method_5740() {
        return true;
    }

    @Environment(EnvType.CLIENT)
    public void method_5711(byte status) {
        if (status == 1) {
            class_2394 particleEffect = this.getParticleParameters();

            for(int i = 0; i < 8; ++i) {
                this.method_37908().method_8406(class_2398.field_11219, this.method_23322((double)0.5F), this.method_23319(), this.method_23325((double)0.5F), (double)0.0F, (double)0.0F, (double)0.0F);
                this.method_37908().method_8406(particleEffect, this.method_23317(), this.method_23318(), this.method_23321(), 0.0D, 0.0D, 0.0D);
            }
        }
    }

    @Override
    protected void method_24920(class_3965 blockHitResult) {
        class_1937 world = this.method_37908();

        if (!world.field_9236) {
            class_2338 hitPos = blockHitResult.method_17777();
            replaceBlocks((class_3218) world, hitPos);
            entityLaunch((class_3218) world, hitPos);
            this.method_31472();
        }
        super.method_24920(blockHitResult);
    }

    @Override
    protected void method_7454(class_3966 entityHitResult) {
        class_1937 world = this.method_37908();
        if (!world.field_9236)
        {
            class_2338 hitPos = entityHitResult.method_17782().method_24515();
            replaceBlocks((class_3218) world, hitPos);
            entityLaunch((class_3218) world, hitPos);
            this.method_31472();
        }
        super.method_7454(entityHitResult);
    }

    private void entityLaunch(class_3218 serverWorld, class_2338 pos) {
        class_238 impactBox = new class_238(pos).method_1009(2.5, 2.5, 2.5); // 5x5x5 radius
        List<class_1309> nearbyEntities = serverWorld.method_8390(
                class_1309.class,
                impactBox,
                entity -> true
        );

        for (class_1309 entity : nearbyEntities) {
            class_243 currentMotion = entity.method_18798();
            entity.method_5762(currentMotion.field_1352, 1.5, currentMotion.field_1350);
            entity.field_6037 = true;
        }
    }

    private void replaceBlocks(class_3218 world, class_2338 centerPos) {
        if (this.method_37908().method_8450().method_8355(Litavis.EARTH_CHARGE_GRIEFING)) {
            if (this.method_37908().method_8450().method_8355(Litavis.EARTH_CHARGE_RESTRICTED))
            {
                method_5783(class_3417.field_42605, 3, 1);
                for (int x = -2; x <= 2; x++) {
                    for (int z = -2; z <= 2; z++) {
                        if (Math.abs(x) == 2 && Math.abs(z) == 2) {
                            continue;
                        }
                        class_2338 targetPos = centerPos.method_10069(x, 0, z);
                        class_2680 blockState = world.method_8320(targetPos);

                        if (blockState.method_26164(ModTags.Blocks.EARTH_CHARGE_RESTRICTED)) {
                            spawnUpperFallingBlock(world, targetPos, blockState);
                            world.method_8650(targetPos, false);
                        }
                    }
                }
            }

            else
            {
                method_5783(class_3417.field_42605, 3, 1);
                for (int x = -2; x <= 2; x++) {
                    for (int z = -2; z <= 2; z++) {
                        if (Math.abs(x) == 2 && Math.abs(z) == 2) {
                            continue;
                        }
                        class_2338 targetPos = centerPos.method_10069(x, 0, z);
                        class_2680 blockState = world.method_8320(targetPos);
                        if (blockState.method_26164(ModTags.Blocks.EARTH_CHARGE_THROWABLE) || blockState.method_26164(class_3481.field_15503) || blockState.method_26164(class_3481.field_15475)) {
                            if (world.method_8320(centerPos.method_10084()).method_27852(class_2246.field_10124))
                            {
                                spawnUpperFallingBlock(world, targetPos, blockState);
                                world.method_8650(targetPos, false);
                            }
                        }
                    }
                }
            }

            for (int x = -1; x <= 1; x++) {
                for (int z = -1; z <= 1; z++) {
                    class_2338 targetPos = centerPos.method_10069(x, -1, z);
                    class_2680 blockState = world.method_8320(targetPos);

                    if (blockState.method_26164(ModTags.Blocks.EARTH_CHARGE_THROWABLE) || blockState.method_26164(class_3481.field_15503) || blockState.method_26164(class_3481.field_15475)) {
                        if (world.method_8320(centerPos.method_10084()).method_27852(class_2246.field_10124)) {
                            spawnLowerFallingBlock(world, targetPos, blockState);
                            world.method_8650(targetPos, false);
                        }
                    }
                }
            }
        }

    }

    //FALLING BLOCK HANDLER FOR 3X3 AREA
    private void spawnLowerFallingBlock(class_3218 world, class_2338 pos, class_2680 blockState) {
        class_1540 fallingBlockEntity = class_1540.method_40005(world, pos, blockState);
        if (fallingBlockEntity != null) {
            fallingBlockEntity.method_23327(pos.method_10263() + 0.5, pos.method_10264(), pos.method_10260() + 0.5);
            fallingBlockEntity.method_18799(new class_243(0, 1, 0));
            fallingBlockEntity.field_6037 = true;
            world.method_8649(fallingBlockEntity);

            world.method_8649(fallingBlockEntity);
        }
    }
    //FALLING BLOCK HANDLER FOR 5X5 AREA
    private void spawnUpperFallingBlock(class_3218 world, class_2338 pos, class_2680 blockState) {
        class_1540 fallingBlockEntity = class_1540.method_40005(world, pos, blockState);
        if (fallingBlockEntity != null) {
            fallingBlockEntity.method_23327(pos.method_10263() + 0.5, pos.method_10264(), pos.method_10260() + 0.5);
            fallingBlockEntity.method_18799(new class_243(0, 1.02, 0));
            fallingBlockEntity.field_6037 = true;
            world.method_8649(fallingBlockEntity);

            world.method_8649(fallingBlockEntity);
        }
    }

    protected class_1792 method_16942() {
        return ModItems.EARTH_CHARGE;
    }
}
