/*
 * Decompiled with CFR 0.152.
 */
package net.thefluffycart.litavis.entity.ai.goals;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.thefluffycart.litavis.entity.custom.BurrowEntity;

public class BurrowCharge
extends class_1352 {
    private final BurrowEntity burrow;
    private class_1657 victim;
    private int chargeTimer = 0;
    private static final int CHARGE_DURATION = 40;
    private static final double CHARGE_SPEED = 1.05;
    private static final int PREPARE_DURATION = 40;
    private static final float DAMAGE_AMOUNT = 10.0f;
    private boolean lockRotation = false;
    private float lockedYaw;
    private float lockedPitch;

    public BurrowCharge(BurrowEntity burrow) {
        this.burrow = burrow;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        this.victim = this.burrow.method_37908().method_18460((class_1297)this.burrow, 20.0);
        return this.victim != null && this.burrow.method_6057((class_1297)this.victim) && !this.victim.method_7337() && (this.burrow.getState() == BurrowEntity.State.IDLE || this.burrow.getState() == BurrowEntity.State.CHARGE);
    }

    public void method_6269() {
        this.chargeTimer = 0;
        this.burrow.setState(BurrowEntity.State.CHARGE);
    }

    public void method_6270() {
        this.burrow.setState(BurrowEntity.State.IDLE);
        this.lockRotation = false;
        this.chargeTimer = 0;
        this.burrow.method_5942().method_6340();
        this.burrow.method_18799(class_243.field_1353);
    }

    public void method_6268() {
        if (this.victim != null && !this.lockRotation) {
            class_243 targetPos = this.victim.method_19538();
            class_243 mobPos = this.burrow.method_19538();
            double dx = targetPos.field_1352 - mobPos.field_1352;
            double dz = targetPos.field_1350 - mobPos.field_1350;
            double dy = targetPos.field_1351 + (double)this.victim.method_5751() - (mobPos.field_1351 + (double)this.burrow.method_5751());
            float targetYaw = (float)(class_3532.method_15349((double)(-dx), (double)dz) * 57.29577951308232);
            this.burrow.method_36456(class_3532.method_16439((float)0.5f, (float)this.burrow.method_36454(), (float)targetYaw));
            this.burrow.method_5636(this.burrow.method_36454());
            this.burrow.method_5847(this.burrow.method_36454());
            float targetPitch = (float)(class_3532.method_15349((double)dy, (double)Math.sqrt(dx * dx + dz * dz)) * 57.29577951308232);
            this.burrow.method_36457(class_3532.method_16439((float)0.3f, (float)this.burrow.method_36455(), (float)targetPitch));
        } else if (this.lockRotation) {
            this.burrow.method_36456(this.lockedYaw);
            this.burrow.method_36457(this.lockedPitch);
            this.burrow.method_5636(this.lockedYaw);
            this.burrow.method_5847(this.lockedYaw);
        }
        switch (this.burrow.getState()) {
            case CHARGE: {
                this.prepareToCharge();
                break;
            }
            case DASH: {
                this.startCharge();
            }
        }
    }

    public boolean method_6266() {
        return this.burrow.getState() == BurrowEntity.State.CHARGE || this.burrow.getState() == BurrowEntity.State.DASH;
    }

    private void prepareToCharge() {
        this.lockRotation = false;
        this.burrow.method_5942().method_6340();
        if (++this.chargeTimer >= 40) {
            this.burrow.setState(BurrowEntity.State.DASH);
            this.chargeTimer = 0;
            class_243 direction = this.victim.method_19538().method_1020(this.burrow.method_19538()).method_1029().method_1021(1.05);
            this.burrow.method_18799(direction);
            this.lockedYaw = this.burrow.method_36454();
            this.lockedPitch = this.burrow.method_36455();
        }
    }

    private void startCharge() {
        this.lockRotation = true;
        class_243 velocity = this.burrow.method_18798().method_1029().method_1021(1.05);
        this.burrow.method_18799(velocity);
        class_238 boundingBox = this.burrow.method_5829();
        class_2338 min = new class_2338((int)boundingBox.field_1323, (int)boundingBox.field_1322, (int)boundingBox.field_1321);
        class_2338 max = new class_2338((int)boundingBox.field_1320, (int)boundingBox.field_1325, (int)boundingBox.field_1324);
        class_238 collisionBox = this.burrow.method_5829();
        List entities = this.burrow.method_37908().method_8390(class_1309.class, collisionBox, entity -> entity != this.burrow);
        for (class_1309 entity2 : entities) {
            entity2.method_5643(this.burrow.method_48923().method_48812((class_1309)this.burrow), 10.0f);
        }
        if (!this.burrow.method_37908().field_9236) {
            class_2338 frontPos = this.burrow.method_24515().method_10093(this.burrow.method_5735());
            class_2680 blockState = this.burrow.method_37908().method_8320(frontPos);
            for (class_2338 pos : class_2338.method_10097((class_2338)min, (class_2338)max)) {
                if (!this.burrow.method_37908().method_8320(pos).method_26212((class_1922)this.burrow.method_37908(), pos)) continue;
                this.method_6270();
                return;
            }
            Iterator<Object> iterator = entities.iterator();
            if (iterator.hasNext()) {
                class_1309 entity3 = (class_1309)iterator.next();
                entity3.method_5643(this.burrow.method_48923().method_48812((class_1309)this.burrow), 10.0f);
                this.method_6270();
                return;
            }
            if (++this.chargeTimer >= 40 || this.burrow.method_30949((class_1297)this.victim)) {
                this.burrow.setState(BurrowEntity.State.IDLE);
                this.method_6270();
            }
        }
    }
}

