/*
 * Decompiled with CFR 0.152.
 */
package net.thefluffycart.litavis.entity.custom;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1540;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3857;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.thefluffycart.litavis.Litavis;
import net.thefluffycart.litavis.entity.ModEntities;
import net.thefluffycart.litavis.item.ModItems;
import net.thefluffycart.litavis.util.ModTags;

public class EarthChargeEntity
extends class_3857 {
    public EarthChargeEntity(class_1299<? extends class_3857> entityType, class_1937 world) {
        super(entityType, world);
    }

    public EarthChargeEntity(class_1937 world, class_1309 owner) {
        super(ModEntities.EARTH_CHARGE, owner, world);
    }

    @Environment(value=EnvType.CLIENT)
    private class_2394 getParticleParameters() {
        class_1799 itemStack = this.method_7495();
        return itemStack.method_7960() ? class_2398.field_11219 : new class_2392(class_2398.field_11218, itemStack);
    }

    public boolean method_5740() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5711(byte status) {
        if (status == 1) {
            class_2394 particleEffect = this.getParticleParameters();
            for (int i = 0; i < 8; ++i) {
                this.method_37908().method_8406(particleEffect, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void method_24920(class_3965 blockHitResult) {
        class_1937 world = this.method_37908();
        if (!world.field_9236) {
            class_2338 hitPos = blockHitResult.method_17777();
            this.replaceBlocks((class_3218)world, hitPos);
            this.entityLaunch((class_3218)world, hitPos);
            this.method_31472();
        }
        super.method_24920(blockHitResult);
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1937 world = this.method_37908();
        if (!world.field_9236) {
            class_2338 hitPos = entityHitResult.method_17782().method_24515();
            this.replaceBlocks((class_3218)world, hitPos);
            this.entityLaunch((class_3218)world, hitPos);
            this.method_31472();
        }
        super.method_7454(entityHitResult);
    }

    private void entityLaunch(class_3218 serverWorld, class_2338 pos) {
        class_238 impactBox = new class_238(pos).method_1009(2.5, 2.5, 2.5);
        List nearbyEntities = serverWorld.method_8390(class_1309.class, impactBox, entity -> true);
        for (class_1309 entity2 : nearbyEntities) {
            class_243 currentMotion = entity2.method_18798();
            entity2.method_5762(currentMotion.field_1352, 1.5, currentMotion.field_1350);
            entity2.field_6037 = true;
        }
    }

    private void replaceBlocks(class_3218 world, class_2338 centerPos) {
        block8: {
            class_2338 targetPos;
            class_2680 blockState;
            int z;
            int x;
            if (!this.method_37908().method_8450().method_8355(Litavis.EARTH_CHARGE_GRIEFING)) break block8;
            if (this.method_37908().method_8450().method_8355(Litavis.EARTH_CHARGE_RESTRICTED)) {
                this.method_5783(class_3417.field_42605, 3.0f, 1.0f);
                for (x = -2; x <= 2; ++x) {
                    for (z = -2; z <= 2; ++z) {
                        if (Math.abs(x) == 2 && Math.abs(z) == 2 || !(blockState = world.method_8320(targetPos = centerPos.method_10069(x, 0, z))).method_26164(ModTags.Blocks.EARTH_CHARGE_RESTRICTED)) continue;
                        this.spawnUpperFallingBlock(world, targetPos, blockState);
                        world.method_8650(targetPos, false);
                    }
                }
            } else {
                this.method_5783(class_3417.field_42605, 3.0f, 1.0f);
                for (x = -2; x <= 2; ++x) {
                    for (z = -2; z <= 2; ++z) {
                        if (Math.abs(x) == 2 && Math.abs(z) == 2 || !(blockState = world.method_8320(targetPos = centerPos.method_10069(x, 0, z))).method_26164(ModTags.Blocks.EARTH_CHARGE_THROWABLE) && !blockState.method_26164(class_3481.field_15503) && !blockState.method_26164(class_3481.field_15475) || !world.method_8320(centerPos.method_10084()).method_27852(class_2246.field_10124)) continue;
                        this.spawnUpperFallingBlock(world, targetPos, blockState);
                        world.method_8650(targetPos, false);
                    }
                }
            }
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    targetPos = centerPos.method_10069(x, -1, z);
                    blockState = world.method_8320(targetPos);
                    if (!blockState.method_26164(ModTags.Blocks.EARTH_CHARGE_THROWABLE) && !blockState.method_26164(class_3481.field_15503) && !blockState.method_26164(class_3481.field_15475) || !world.method_8320(centerPos.method_10084()).method_27852(class_2246.field_10124)) continue;
                    this.spawnLowerFallingBlock(world, targetPos, blockState);
                    world.method_8650(targetPos, false);
                }
            }
        }
    }

    private void spawnLowerFallingBlock(class_3218 world, class_2338 pos, class_2680 blockState) {
        class_1540 fallingBlockEntity = class_1540.method_40005((class_1937)world, (class_2338)pos, (class_2680)blockState);
        if (fallingBlockEntity != null) {
            fallingBlockEntity.method_23327((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
            fallingBlockEntity.method_18799(new class_243(0.0, 1.0, 0.0));
            fallingBlockEntity.field_6037 = true;
            world.method_8649((class_1297)fallingBlockEntity);
            world.method_8649((class_1297)fallingBlockEntity);
        }
    }

    private void spawnUpperFallingBlock(class_3218 world, class_2338 pos, class_2680 blockState) {
        class_1540 fallingBlockEntity = class_1540.method_40005((class_1937)world, (class_2338)pos, (class_2680)blockState);
        if (fallingBlockEntity != null) {
            fallingBlockEntity.method_23327((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
            fallingBlockEntity.method_18799(new class_243(0.0, 1.02, 0.0));
            fallingBlockEntity.field_6037 = true;
            world.method_8649((class_1297)fallingBlockEntity);
            world.method_8649((class_1297)fallingBlockEntity);
        }
    }

    protected class_1792 method_16942() {
        return ModItems.EARTH_CHARGE;
    }
}

