/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.moreburners;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.dragonegg.moreburners.compat.pneumaticcraft.PneumaticCraftCompat;
import net.dragonegg.moreburners.config.ClientConfig;
import net.dragonegg.moreburners.config.CommonConfig;
import net.dragonegg.moreburners.event.Events;
import net.dragonegg.moreburners.registry.BlockRegistry;
import net.dragonegg.moreburners.registry.ItemRegistry;
import net.dragonegg.moreburners.registry.TabRegistry;
import net.dragonegg.moreburners.util.BoilerHeaterRegistry;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@Mod(value="moreburners")
public class MoreBurners {
    public static final String MODID = "moreburners";

    public MoreBurners(IEventBus eventBus, ModContainer container) {
        eventBus.addListener(this::commonSetup);
        BlockRegistry.BLOCKS.register(eventBus);
        BlockRegistry.BLOCK_ENTITY_TYPES.register(eventBus);
        ItemRegistry.ITEMS.register(eventBus);
        TabRegistry.CREATIVE_TABS.register(eventBus);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.COMMON_CONFIG);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CLIENT_CONFIG);
        Events.register(eventBus);
        if (MoreBurners.loadedPNE()) {
            PneumaticCraftCompat.init();
        }
    }

    public static ResourceLocation RL(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        BoilerHeaterRegistry.registerBoilerHeaters();
    }

    public static boolean loadedEmber() {
        return ModList.get().isLoaded("embers");
    }

    public static boolean loadedPNE() {
        return ModList.get().isLoaded("pneumaticcraft");
    }

    public static boolean loadedBotania() {
        return ModList.get().isLoaded("botania");
    }

    public static void loadConfig(ModConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.correct((CommentedConfig)configData);
    }
}

