/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.moreburners.content.block;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class BaseBurnerBlock
extends BaseEntityBlock
implements IWrenchable {
    public static final EnumProperty<BlazeBurnerBlock.HeatLevel> HEAT_LEVEL = BlazeBurnerBlock.HEAT_LEVEL;

    protected BaseBurnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.NONE));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HEAT_LEVEL});
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!world.isClientSide && (blockEntity = world.getBlockEntity(pos.above())) instanceof BasinBlockEntity) {
            BasinBlockEntity basin = (BasinBlockEntity)blockEntity;
            basin.notifyChangeOfContents();
        }
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        float damage = 0.0f;
        boolean giveFire = false;
        int time = 0;
        switch ((BlazeBurnerBlock.HeatLevel)state.getValue(HEAT_LEVEL)) {
            case SMOULDERING: {
                damage = 0.5f;
                break;
            }
            case FADING: {
                damage = 1.0f;
                giveFire = true;
                time = 6;
                break;
            }
            case KINDLED: {
                damage = 2.0f;
                giveFire = true;
                time = 8;
                break;
            }
            case SEETHING: {
                damage = 4.0f;
                giveFire = true;
                time = 300;
            }
        }
        if (!entity.isSteppingCarefully() && entity instanceof LivingEntity) {
            entity.hurt(level.damageSources().hotFloor(), damage);
        }
        if (giveFire && !entity.fireImmune()) {
            entity.igniteForSeconds((float)time);
        }
        super.stepOn(level, pos, state, entity);
    }

    public BlockState getState(BlazeBurnerBlock.HeatLevel level) {
        return (BlockState)this.defaultBlockState().setValue(HEAT_LEVEL, (Comparable)level);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return null;
    }
}

