/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.moreburners.content.block;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import net.dragonegg.moreburners.content.block.BaseBurnerBlock;
import net.dragonegg.moreburners.content.block.entity.ElectricBurnerBlockEntity;
import net.dragonegg.moreburners.content.item.HeatUpgradeItem;
import net.dragonegg.moreburners.registry.BlockRegistry;
import net.dragonegg.moreburners.registry.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ElectricBurnerBlock
extends BaseBurnerBlock {
    public static final MapCodec<ElectricBurnerBlock> CODEC = ElectricBurnerBlock.simpleCodec(ElectricBurnerBlock::new);
    public static final BooleanProperty UPGRADED = BooleanProperty.create((String)"upgraded");
    public static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0), Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.box((double)0.0, (double)12.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0), Block.box((double)15.0, (double)12.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), Block.box((double)0.0, (double)12.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)});

    public ElectricBurnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)UPGRADED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{UPGRADED});
    }

    public BlockState getState(BlazeBurnerBlock.HeatLevel level, Boolean upgraded) {
        return (BlockState)super.getState(level).setValue((Property)UPGRADED, (Comparable)upgraded);
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (!((Boolean)state.getValue((Property)UPGRADED)).booleanValue()) {
            return super.onSneakWrenched(state, context);
        }
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        level.levelEvent(2001, pos, Block.getId((BlockState)state));
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof ElectricBurnerBlockEntity) {
            ElectricBurnerBlockEntity ebbe = (ElectricBurnerBlockEntity)entity;
            ebbe.setUpgrade(false);
            IWrenchable.playRemoveSound((Level)level, (BlockPos)pos);
            if (player != null && !player.isCreative()) {
                ItemStack returned = ((HeatUpgradeItem)((Object)ItemRegistry.HEAT_UPGRADE.get())).getDefaultInstance();
                player.getInventory().placeItemBackInInventory(returned);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ElectricBurnerBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return ElectricBurnerBlock.createTickerHelper(type, BlockRegistry.ELECTRIC_BURNER_ENTITY.get(), (level1, pos, state1, entity) -> entity.tick(level1, pos, state1));
    }
}

