/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.moreburners.content.block.entity;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import java.util.List;
import joptsimple.internal.Strings;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.lang.LangBuilder;
import net.dragonegg.moreburners.config.ClientConfig;
import net.dragonegg.moreburners.config.CommonConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public abstract class BaseBurnerBlockEntity
extends BlockEntity
implements IHaveGoggleInformation {
    public static final double SEETHING_HEAT = (Double)CommonConfig.SEETHING_HEAT.get();
    public static final double KINDLED_HEAT = (Double)CommonConfig.KINDLED_HEAT.get();
    public static final double FADING_HEAT = (Double)CommonConfig.FADING_HEAT.get();
    public static final double SMOULDERING_HEAT = (Double)CommonConfig.SMOULDERING_HEAT.get();
    public double heat = 0.0;
    public double max_heat;
    protected int ticksExisted = 0;
    protected boolean canWork = true;
    protected int redstoneStrength = 0;

    public BaseBurnerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.heat = nbt.getDouble("heat");
        this.max_heat = nbt.getDouble("max_heat");
        this.redstoneStrength = nbt.getInt("redstone_strength");
    }

    public void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putDouble("heat", this.heat);
        nbt.putDouble("max_heat", this.max_heat);
        nbt.putInt("redstone_strength", this.redstoneStrength);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        nbt.putDouble("heat", this.heat);
        nbt.putDouble("max_heat", this.max_heat);
        nbt.putInt("redstone_strength", this.redstoneStrength);
        return nbt;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level instanceof ServerLevel) {
            ((ServerLevel)this.level).getChunkSource().blockChanged(this.worldPosition);
        }
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        this.updateRedstoneStrength(this.getPower(level, pos));
        if (this.redstoneStrength != 0) {
            this.max_heat *= (double)this.redstoneStrength / 16.0;
        }
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevelFromBlock() {
        return BlazeBurnerBlock.getHeatLevelOf((BlockState)this.getBlockState());
    }

    public void updateBlockState() {
        this.setBlockHeat(this.getHeatLevel());
    }

    protected void setBlockHeat(BlazeBurnerBlock.HeatLevel heat) {
        BlazeBurnerBlock.HeatLevel inBlockState = this.getHeatLevelFromBlock();
        if (inBlockState != heat) {
            assert (this.level != null);
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)heat));
            this.setChanged();
        }
    }

    protected BlazeBurnerBlock.HeatLevel getHeatLevel() {
        BlazeBurnerBlock.HeatLevel level = BlazeBurnerBlock.HeatLevel.NONE;
        if (this.heat >= SEETHING_HEAT) {
            level = BlazeBurnerBlock.HeatLevel.SEETHING;
        } else if (this.heat >= KINDLED_HEAT) {
            level = BlazeBurnerBlock.HeatLevel.KINDLED;
        } else if (this.heat >= FADING_HEAT) {
            level = BlazeBurnerBlock.HeatLevel.FADING;
        } else if (this.heat >= SMOULDERING_HEAT) {
            level = BlazeBurnerBlock.HeatLevel.SMOULDERING;
        }
        return level;
    }

    public void updateRedstoneStrength(int signalStrength) {
        this.redstoneStrength = signalStrength;
        this.setChanged();
    }

    public int getPower(Level worldIn, BlockPos pos) {
        int power = 0;
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.getSignal(pos.relative(direction), direction), power);
        }
        for (Direction direction : Iterate.directions) {
            power = Math.max(worldIn.getSignal(pos.relative(direction), Direction.UP), power);
        }
        return power;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ChatFormatting formatting = switch (this.getHeatLevel()) {
            default -> throw new MatchException(null, null);
            case BlazeBurnerBlock.HeatLevel.NONE, BlazeBurnerBlock.HeatLevel.SMOULDERING -> ChatFormatting.WHITE;
            case BlazeBurnerBlock.HeatLevel.FADING, BlazeBurnerBlock.HeatLevel.KINDLED -> ChatFormatting.GOLD;
            case BlazeBurnerBlock.HeatLevel.SEETHING -> ChatFormatting.BLUE;
        };
        this.forGoggles(tooltip, Lang.builder((String)"moreburners").translate("burner.status.title", new Object[]{Component.translatable((String)("moreburners.burner.status." + this.getHeatLevel().name().toLowerCase())).withStyle(formatting)}), 0);
        this.forGoggles(tooltip, Lang.builder((String)"moreburners").add(this.getHeatComponent(true)), 1);
        return true;
    }

    public void forGoggles(List<? super MutableComponent> tooltip, LangBuilder builder, int indents) {
        tooltip.add((MutableComponent)Lang.builder((String)"moreburners").text(Strings.repeat((char)' ', (int)BaseBurnerBlockEntity.getIndents(Minecraft.getInstance().font, 4 + indents))).add(builder).component());
    }

    static int getIndents(Font font, int defaultIndents) {
        int spaceWidth = font.width(" ");
        if (4.0f == (float)spaceWidth) {
            return defaultIndents;
        }
        return Mth.ceil((float)(4.0f * (float)defaultIndents / (float)spaceWidth));
    }

    public MutableComponent getHeatComponent(boolean forGoggles) {
        int level = (int)(this.heat * (double)((Integer)ClientConfig.HEAT_BAR_LENGTH.get()).intValue() / this.max_heat);
        return this.componentHelper(level, forGoggles);
    }

    private MutableComponent componentHelper(int level, boolean forGoggles) {
        MutableComponent base = Component.empty().append((Component)this.bars(level, ChatFormatting.DARK_GREEN)).append((Component)this.bars((Integer)ClientConfig.HEAT_BAR_LENGTH.get() - level, ChatFormatting.DARK_RED));
        if (!forGoggles) {
            return base;
        }
        return Component.translatable((String)"moreburners.burner.status.heat").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"moreburners.burner.status.dots").withStyle(ChatFormatting.DARK_GRAY)).append((Component)base);
    }

    private MutableComponent bars(int level, ChatFormatting format) {
        return Component.literal((String)Strings.repeat((char)'|', (int)level)).withStyle(format);
    }
}

