/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.moreburners.content.block.entity;

import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import java.util.List;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.lang.LangNumberFormat;
import net.dragonegg.moreburners.config.CommonConfig;
import net.dragonegg.moreburners.content.block.ElectricBurnerBlock;
import net.dragonegg.moreburners.content.block.entity.BaseBurnerBlockEntity;
import net.dragonegg.moreburners.registry.BlockRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.energy.EnergyStorage;
import org.jetbrains.annotations.NotNull;

public class ElectricBurnerBlockEntity
extends BaseBurnerBlockEntity {
    public static final int MAX_ENERGY_CAP = (Integer)CommonConfig.ELECTRIC_BURNER_MAX_CAPACITY.get();
    public static final int ENERGY_COST = (Integer)CommonConfig.ELECTRIC_BURNER_ENERGY_COST.get();
    public static final double ENERGY_MULTIPLIER_1 = (Double)CommonConfig.ELECTRIC_BURNER_ENERGY_MULTIPLIER_1.get();
    public static final double ENERGY_MULTIPLIER_2 = (Double)CommonConfig.ELECTRIC_BURNER_ENERGY_MULTIPLIER_2.get();
    public static final double MAX_HEAT = (Double)CommonConfig.ELECTRIC_BURNER_MAX_HEAT.get();
    public static final double UPGRADED_MAX_HEAT = (Double)CommonConfig.ELECTRIC_BURNER_UPGRADED_MAX_HEAT.get();
    public static final double HEATING_RATE = (Double)CommonConfig.ELECTRIC_BURNER_HEATING_RATE.get();
    public static final double COOLING_RATE = (Double)CommonConfig.ELECTRIC_BURNER_COOLING_RATE.get();
    public EnergyStorage energy;
    public double energy_cost;
    public boolean upgraded;

    public ElectricBurnerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockRegistry.ELECTRIC_BURNER_ENTITY.get(), pos, state);
        this.max_heat = MAX_HEAT;
        this.energy_cost = ENERGY_COST;
        this.upgraded = false;
        this.energy = new EnergyStorage(MAX_ENERGY_CAP);
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.energy.deserializeNBT(registries, (Tag)IntTag.valueOf((int)nbt.getInt("energy")));
        this.upgraded = nbt.getBoolean("upgraded");
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putInt("energy", this.energy.getEnergyStored());
        nbt.putBoolean("upgraded", this.upgraded);
    }

    @Override
    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        nbt.putInt("energy", this.energy.getEnergyStored());
        nbt.putBoolean("upgraded", this.upgraded);
        return nbt;
    }

    public void setUpgrade(boolean upgraded) {
        this.upgraded = upgraded;
        this.updateBlockState();
    }

    @Override
    public void updateBlockState() {
        super.updateBlockState();
        this.setBlockUpgraded(this.upgraded);
    }

    public void setBlockUpgraded(boolean upgraded) {
        boolean state = this.getUpgradedFromBlock();
        if (state != upgraded) {
            assert (this.level != null);
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)ElectricBurnerBlock.UPGRADED, (Comparable)Boolean.valueOf(upgraded)));
            this.setChanged();
        }
    }

    public boolean getUpgradedFromBlock() {
        BlockState state = this.getBlockState();
        return state.hasProperty((Property)ElectricBurnerBlock.UPGRADED) ? (Boolean)state.getValue((Property)ElectricBurnerBlock.UPGRADED) : false;
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        ++this.ticksExisted;
        this.max_heat = this.upgraded ? UPGRADED_MAX_HEAT : MAX_HEAT;
        super.tick(level, pos, state);
        double d = ENERGY_COST;
        this.energy_cost = d * (switch (this.getHeatLevelFromBlock()) {
            default -> throw new MatchException(null, null);
            case BlazeBurnerBlock.HeatLevel.NONE, BlazeBurnerBlock.HeatLevel.SMOULDERING -> 1.0;
            case BlazeBurnerBlock.HeatLevel.FADING, BlazeBurnerBlock.HeatLevel.KINDLED -> ENERGY_MULTIPLIER_1;
            case BlazeBurnerBlock.HeatLevel.SEETHING -> ENERGY_MULTIPLIER_2;
        });
        if (!level.isClientSide()) {
            double prevHeat = this.heat;
            if (this.energy.getEnergyStored() > (int)this.energy_cost) {
                this.energy.extractEnergy((int)this.energy_cost, false);
            } else {
                this.canWork = false;
            }
            if (this.ticksExisted % 20 == 0) {
                this.heat = this.canWork ? (this.heat += HEATING_RATE) : (this.heat -= COOLING_RATE);
                this.canWork = true;
            }
            this.heat = Mth.clamp((double)this.heat, (double)0.0, (double)this.max_heat);
            if (this.heat != prevHeat) {
                this.setChanged();
                this.updateBlockState();
            }
        }
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.getUpgradedFromBlock()) {
            this.forGoggles(tooltip, Lang.builder((String)"moreburners").translate("burner.status.upgraded", new Object[0]).style(ChatFormatting.BLUE), 1);
        }
        tooltip.add((Component)Component.empty());
        this.forGoggles(tooltip, Lang.builder((String)"moreburners").translate("burner.energy.title", new Object[0]).style(ChatFormatting.GRAY), 0);
        LangBuilder builder = Lang.builder((String)"moreburners").text(LangNumberFormat.format((double)((int)this.energy_cost))).translate("burner.energy.unit", new Object[0]).style(ChatFormatting.AQUA).space().add(Lang.builder((String)"moreburners").translate("burner.per_tick", new Object[0]).style(ChatFormatting.DARK_GRAY));
        this.forGoggles(tooltip, builder, 1);
        return added;
    }
}

