/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.moreburners.content.block.entity;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import java.util.List;
import joptsimple.internal.Strings;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.block.entity.IHeatTinted;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.SyncedTemperature;
import me.desht.pneumaticcraft.common.network.DescSynced;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.lang.LangBuilder;
import net.dragonegg.moreburners.compat.pneumaticcraft.PneumaticCraftCompat;
import net.dragonegg.moreburners.config.ClientConfig;
import net.dragonegg.moreburners.config.CommonConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HeatConverterBlockEntity
extends AbstractTickingBlockEntity
implements IComparatorSupport,
IHeatTinted,
IHeatExchangingTE,
IHaveGoggleInformation {
    public static final double SEETHING_TEMP = (Double)CommonConfig.PNE_SEETHING_TEMP.get();
    public static final double KINDLED_TEMP = (Double)CommonConfig.PNE_KINDLED_TEMP.get();
    public static final double FADING_TEMP = (Double)CommonConfig.PNE_FADING_TEMP.get();
    public static final double SMOULDERING_TEMP = (Double)CommonConfig.PNE_SMOULDERING_TEMP.get();
    public static final double TEMP_COST = (Double)CommonConfig.PNE_HEAT_CONVERTER_TEMP_COST.get();
    public static final double MAX_TEMP = 2273.0;
    protected final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private int comparatorOutput = 0;
    @DescSynced
    protected final SyncedTemperature syncedTemperature = new SyncedTemperature(this.heatExchanger);

    public HeatConverterBlockEntity(BlockPos pos, BlockState state) {
        this(PneumaticCraftCompat.HEAT_CONVERTER_ENTITY.get(), pos, state);
    }

    HeatConverterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.heatExchanger.setThermalCapacity(10.0);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.isClientSide()) {
            this.tickClient();
        } else {
            this.tickServer();
        }
    }

    public void tickServer() {
        super.tickServer();
        this.syncedTemperature.tick();
        int newComparatorOutput = HeatUtil.getComparatorOutput((int)((int)this.heatExchanger.getTemperature()));
        if (this.comparatorOutput != newComparatorOutput) {
            this.comparatorOutput = newComparatorOutput;
            this.nonNullLevel().updateNeighbourForOutputSignal(this.getBlockPos(), this.getBlockState().getBlock());
        }
        if (this.heatExchanger.getTemperature() >= this.heatExchanger.getAmbientTemperature() + TEMP_COST) {
            this.heatExchanger.addHeat(-TEMP_COST);
        }
        this.updateBlockState();
    }

    public void updateBlockState() {
        this.setBlockHeat(HeatConverterBlockEntity.getHeatLevel(this.heatExchanger.getTemperature()));
    }

    protected void setBlockHeat(BlazeBurnerBlock.HeatLevel heat) {
        BlazeBurnerBlock.HeatLevel inBlockState = this.getHeatLevelFromBlock();
        if (inBlockState != heat) {
            assert (this.level != null);
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)heat));
            this.setChanged();
        }
    }

    public BlazeBurnerBlock.HeatLevel getHeatLevelFromBlock() {
        return BlazeBurnerBlock.getHeatLevelOf((BlockState)this.getBlockState());
    }

    public static BlazeBurnerBlock.HeatLevel getHeatLevel(double temp) {
        temp -= 273.0;
        BlazeBurnerBlock.HeatLevel level = BlazeBurnerBlock.HeatLevel.NONE;
        if (temp >= SEETHING_TEMP) {
            level = BlazeBurnerBlock.HeatLevel.SEETHING;
        } else if (temp >= KINDLED_TEMP) {
            level = BlazeBurnerBlock.HeatLevel.KINDLED;
        } else if (temp >= FADING_TEMP) {
            level = BlazeBurnerBlock.HeatLevel.FADING;
        } else if (temp >= SMOULDERING_TEMP) {
            level = BlazeBurnerBlock.HeatLevel.SMOULDERING;
        }
        return level;
    }

    public int getComparatorValue() {
        return this.comparatorOutput;
    }

    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        return dir != Direction.UP ? this.heatExchanger : null;
    }

    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    public TintColor getColorForTintIndex(int i) {
        return HeatUtil.getColourForTemperature((int)this.syncedTemperature.getSyncedTemp());
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        BlazeBurnerBlock.HeatLevel level = this.getHeatLevelFromBlock();
        ChatFormatting formatting = switch (level) {
            default -> throw new MatchException(null, null);
            case BlazeBurnerBlock.HeatLevel.NONE, BlazeBurnerBlock.HeatLevel.SMOULDERING -> ChatFormatting.WHITE;
            case BlazeBurnerBlock.HeatLevel.FADING, BlazeBurnerBlock.HeatLevel.KINDLED -> ChatFormatting.GOLD;
            case BlazeBurnerBlock.HeatLevel.SEETHING -> ChatFormatting.BLUE;
        };
        this.forGoggles(tooltip, Lang.builder((String)"moreburners").translate("burner.status.title", new Object[]{Component.translatable((String)("moreburners.burner.status." + level.name().toLowerCase())).withStyle(formatting)}), 0);
        this.forGoggles(tooltip, Lang.builder((String)"moreburners").add(this.getHeatComponent(true)), 1);
        return true;
    }

    public void forGoggles(List<? super MutableComponent> tooltip, LangBuilder builder, int indents) {
        tooltip.add((MutableComponent)Lang.builder((String)"moreburners").text(Strings.repeat((char)' ', (int)HeatConverterBlockEntity.getIndents(Minecraft.getInstance().font, 4 + indents))).add(builder).component());
    }

    static int getIndents(Font font, int defaultIndents) {
        int spaceWidth = font.width(" ");
        if (4.0f == (float)spaceWidth) {
            return defaultIndents;
        }
        return Mth.ceil((float)(4.0f * (float)defaultIndents / (float)spaceWidth));
    }

    public MutableComponent getHeatComponent(boolean forGoggles) {
        int level = (int)((double)(this.syncedTemperature.getSyncedTemp() * (Integer)ClientConfig.HEAT_BAR_LENGTH.get()) / 2273.0);
        return this.componentHelper(level, forGoggles);
    }

    private MutableComponent componentHelper(int level, boolean forGoggles) {
        MutableComponent base = Component.empty().append((Component)this.bars(level, ChatFormatting.DARK_GREEN)).append((Component)this.bars((Integer)ClientConfig.HEAT_BAR_LENGTH.get() - level, ChatFormatting.DARK_RED));
        if (!forGoggles) {
            return base;
        }
        return Component.translatable((String)"moreburners.burner.status.heat").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"moreburners.burner.status.dots").withStyle(ChatFormatting.DARK_GRAY)).append((Component)base);
    }

    private MutableComponent bars(int level, ChatFormatting format) {
        return Component.literal((String)Strings.repeat((char)'|', (int)level)).withStyle(format);
    }
}

