/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.moreburners.content.item;

import net.dragonegg.moreburners.content.block.entity.ElectricBurnerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class HeatUpgradeItem
extends Item {
    public HeatUpgradeItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level;
        BlockEntity entity;
        Player player = context.getPlayer();
        if (player != null && context.getHand() == InteractionHand.MAIN_HAND && !player.isShiftKeyDown() && (entity = (level = context.getLevel()).getBlockEntity(pos = context.getClickedPos())) instanceof ElectricBurnerBlockEntity) {
            ElectricBurnerBlockEntity ebbe = (ElectricBurnerBlockEntity)entity;
            if (!ebbe.upgraded) {
                ebbe.setUpgrade(true);
                player.setItemInHand(InteractionHand.MAIN_HAND, Items.AIR.getDefaultInstance());
                level.playSound(null, pos, SoundEvents.SMITHING_TABLE_USE, SoundSource.BLOCKS);
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }
}

