/*
 * Decompiled with CFR 0.152.
 */
package net.dragonegg.moreburners.util;

import com.simibubi.create.api.boiler.BoilerHeater;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import net.dragonegg.moreburners.MoreBurners;
import net.dragonegg.moreburners.content.block.BaseBurnerBlock;
import net.dragonegg.moreburners.content.block.entity.HeatConverterBlockEntity;
import net.dragonegg.moreburners.util.BurnerUtil;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;

public class BoilerHeaterRegistry {
    public static void registerBoilerHeaters() {
        for (Block block : BurnerUtil.getBurners()) {
            BoilerHeaterRegistry.registerBurners(block);
        }
        if (MoreBurners.loadedPNE()) {
            BoilerHeaterRegistry.registerPNEBlocks();
        }
    }

    public static float fromHeatLevel(BlazeBurnerBlock.HeatLevel value) {
        return switch (value) {
            default -> throw new MatchException(null, null);
            case BlazeBurnerBlock.HeatLevel.NONE -> -1.0f;
            case BlazeBurnerBlock.HeatLevel.SMOULDERING -> 0.0f;
            case BlazeBurnerBlock.HeatLevel.FADING, BlazeBurnerBlock.HeatLevel.KINDLED -> 1.0f;
            case BlazeBurnerBlock.HeatLevel.SEETHING -> 2.0f;
        };
    }

    public static void registerBurners(Block block) {
        if (!(block instanceof BaseBurnerBlock)) {
            return;
        }
        BoilerHeater.REGISTRY.register((Object)block, (level, pos, state) -> BoilerHeaterRegistry.fromHeatLevel((BlazeBurnerBlock.HeatLevel)state.getValue((Property)BlazeBurnerBlock.HEAT_LEVEL)));
    }

    public static void registerPNEBlocks() {
        ModBlockEntityTypes.streamBlockEntities().forEach(be -> {
            if (be instanceof IHeatExchangingTE) {
                BoilerHeater.REGISTRY.register((Object)be.getBlockState().getBlock(), (level, pos, state) -> {
                    IHeatExchangingTE heatTE;
                    IHeatExchangerLogic logic;
                    BlockEntity patt0$temp = level.getBlockEntity(pos);
                    if (patt0$temp instanceof IHeatExchangingTE && (logic = (heatTE = (IHeatExchangingTE)patt0$temp).getHeatExchanger(Direction.UP)) != null) {
                        return BoilerHeaterRegistry.fromHeatLevel(HeatConverterBlockEntity.getHeatLevel(logic.getTemperature()));
                    }
                    return -1.0f;
                });
            }
        });
    }
}

