/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.cameraanim.client;

import cn.anecansaitin.cameraanim.InterpolationMath;
import cn.anecansaitin.cameraanim.client.ClientUtil;
import cn.anecansaitin.cameraanim.common.animation.CameraKeyframe;
import cn.anecansaitin.cameraanim.common.animation.GlobalCameraPath;
import cn.anecansaitin.cameraanim.common.animation.TimeInterpolator;
import java.util.Map;
import net.minecraft.util.Mth;
import org.joml.Matrix3f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Animator {
    public static final Animator INSTANCE = new Animator();
    private GlobalCameraPath path;
    private boolean playing;
    private int time;
    private final Vector3f center = new Vector3f();
    private final Vector3f rotation = new Vector3f();
    private final Matrix3f rotationMatrix = new Matrix3f();

    public void tick() {
        if (!this.playing || this.path == null) {
            return;
        }
        if (this.time >= this.path.getLength()) {
            this.reset();
        } else {
            ++this.time;
        }
    }

    public void play() {
        this.playing = true;
    }

    public void stop() {
        this.playing = false;
    }

    public void reset() {
        this.time = 0;
        this.playing = false;
        this.path = null;
        ClientUtil.resetCameraType();
    }

    public void resetAndPlay() {
        this.time = 0;
        this.playing = true;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setPathAndPlay(GlobalCameraPath path) {
        this.path = path;
        this.resetAndPlay();
    }

    public void setPathAndPlay(GlobalCameraPath path, Vector3f center, Vector3f rotation) {
        this.path = path;
        this.center.set((Vector3fc)center);
        this.rotation.set((Vector3fc)rotation);
        this.rotationMatrix.identity().rotateY((360.0f - rotation.y) * ((float)Math.PI / 180));
        this.resetAndPlay();
    }

    public boolean prepareCameraInfo(Vector3f posDest, Vector3f rotDest, float[] fov) {
        float tf;
        float tr;
        float tp;
        if (this.path == null) {
            return false;
        }
        float partialTicks = this.isPlaying() ? ClientUtil.partialTicks() : 0.0f;
        Map.Entry<Integer, CameraKeyframe> current = this.path.getEntry(this.time);
        Map.Entry<Integer, CameraKeyframe> preEntry = current == null ? this.path.getPreEntry(this.time) : current;
        Map.Entry<Integer, CameraKeyframe> nextEntry = this.path.getNextEntry(this.time);
        if (preEntry == null) {
            if (nextEntry == null) {
                return false;
            }
            posDest.set((Vector3fc)nextEntry.getValue().getPos());
            rotDest.set((Vector3fc)nextEntry.getValue().getRot());
            fov[0] = nextEntry.getValue().getFov();
            if (this.path.isNativeMode()) {
                this.rotationMatrix.transform(posDest).add((Vector3fc)this.center);
                rotDest.add((Vector3fc)this.rotation);
            }
            return true;
        }
        if (nextEntry == null) {
            posDest.set((Vector3fc)preEntry.getValue().getPos());
            rotDest.set((Vector3fc)preEntry.getValue().getRot());
            fov[0] = preEntry.getValue().getFov();
            if (this.path.isNativeMode()) {
                this.rotationMatrix.transform(posDest).add((Vector3fc)this.center);
                rotDest.add((Vector3fc)this.rotation);
            }
            return true;
        }
        float t = (partialTicks + (float)this.time - (float)preEntry.getKey().intValue()) / (float)(nextEntry.getKey() - preEntry.getKey());
        CameraKeyframe pre = preEntry.getValue();
        CameraKeyframe next = nextEntry.getValue();
        if (next.getPosTimeInterpolator() == TimeInterpolator.BEZIER) {
            tp = next.getPosBezier().interpolate(t);
            tr = next.getRotBezier().interpolate(t);
            tf = next.getFovBezier().interpolate(t);
        } else {
            tp = t;
            tr = t;
            tf = t;
        }
        switch (next.getPathInterpolator()) {
            case LINEAR: {
                InterpolationMath.line(tp, pre.getPos(), next.getPos(), posDest);
                InterpolationMath.line(tr, pre.getRot(), next.getRot(), rotDest);
                fov[0] = Mth.m_14179_((float)tf, (float)pre.getFov(), (float)next.getFov());
                break;
            }
            case SMOOTH: {
                Map.Entry<Integer, CameraKeyframe> prePre = this.path.getPreEntry(preEntry.getKey());
                Vector3f p0 = prePre == null ? pre.getPos() : prePre.getValue().getPos();
                Map.Entry<Integer, CameraKeyframe> nextNext = this.path.getNextEntry(nextEntry.getKey());
                Vector3f p3 = nextNext == null ? next.getPos() : nextNext.getValue().getPos();
                InterpolationMath.catmullRom(tp, p0, pre.getPos(), next.getPos(), p3, posDest);
                InterpolationMath.line(tr, pre.getRot(), next.getRot(), rotDest);
                fov[0] = Mth.m_14179_((float)tf, (float)pre.getFov(), (float)next.getFov());
                break;
            }
            case BEZIER: {
                next.getPathBezier().interpolate(tp, pre.getPos(), next.getPos(), posDest);
                InterpolationMath.line(tr, pre.getRot(), next.getRot(), rotDest);
                fov[0] = Mth.m_14179_((float)tf, (float)pre.getFov(), (float)next.getFov());
                break;
            }
            case STEP: {
                posDest.set((Vector3fc)pre.getPos());
                rotDest.set((Vector3fc)pre.getRot());
                fov[0] = pre.getFov();
            }
        }
        if (this.path.isNativeMode()) {
            this.rotationMatrix.transform(posDest).add((Vector3fc)this.center);
            rotDest.add((Vector3fc)this.rotation);
        }
        return true;
    }
}

