/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.cameraanim.client;

import cn.anecansaitin.cameraanim.client.ClientUtil;
import cn.anecansaitin.cameraanim.common.animation.CameraKeyframe;
import cn.anecansaitin.cameraanim.common.animation.GlobalCameraPath;
import cn.anecansaitin.cameraanim.common.animation.PathInterpolator;
import cn.anecansaitin.cameraanim.common.animation.Vec3BezierController;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.jetbrains.annotations.Nullable;
import org.joml.Intersectionf;
import org.joml.Math;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CameraAnimIdeCache {
    public static final float POINT_PICK_EXPAND = 0.2f;
    public static boolean EDIT;
    public static boolean VIEW;
    public static boolean PREVIEW;
    private static Mode MODE;
    private static final MoveModeData MOVE_DATA;
    private static GlobalCameraPath PATH;
    private static final SelectedPoint SELECTED_POINT;
    private static final float BEZIER_PICK_EXPAND = 0.1f;
    private static final Vector3f NATIVE_POS;
    private static final Vector3f NATIVE_ROT;

    public static void tick() {
        if (MODE == Mode.MOVE) {
            MOVE_DATA.move();
        }
    }

    public static void leftPick(Vector3f origin, Vector3f direction, float length) {
        if (MODE == Mode.MOVE && CameraAnimIdeCache.MOVE_DATA.moveType != MoveType.NONE) {
            return;
        }
        length += 0.1f;
        length *= length;
        if (MODE == Mode.MOVE && MOVE_DATA.pickMoveModule(origin, direction, true)) {
            return;
        }
        length = CameraAnimIdeCache.pickBezier(length, origin, direction);
        CameraAnimIdeCache.pickPoint(length, origin, direction);
    }

    public static void rightPick(Vector3f origin, Vector3f direction, float length) {
        if (MODE == Mode.MOVE && CameraAnimIdeCache.MOVE_DATA.moveType != MoveType.NONE) {
            return;
        }
        if (CameraAnimIdeCache.SELECTED_POINT.pointTime < 0) {
            return;
        }
        if (MODE != Mode.MOVE) {
            return;
        }
        MOVE_DATA.pickMoveModule(origin, direction, false);
    }

    private static float pickBezier(float length, Vector3f origin, Vector3f direction) {
        CameraKeyframe pre;
        int selectedTime = SELECTED_POINT.getPointTime();
        if (selectedTime <= 0) {
            return length;
        }
        CameraKeyframe point = PATH.getPoint(selectedTime);
        if (point == null || point.getPathInterpolator() != PathInterpolator.BEZIER) {
            return length;
        }
        Vec3BezierController controller = point.getPathBezier();
        Vector3f right = controller.getRight();
        float rightL = right.distanceSquared((Vector3fc)origin);
        if (rightL <= length && Intersectionf.testRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)new Vector3f((Vector3fc)right).sub(0.1f, 0.1f, 0.1f), (Vector3fc)new Vector3f((Vector3fc)right).add(0.1f, 0.1f, 0.1f))) {
            length = rightL;
            SELECTED_POINT.setControl(ControlType.RIGHT);
        }
        if ((pre = PATH.getPrePoint(selectedTime)) == null) {
            return length;
        }
        Vector3f left = controller.getLeft();
        float leftL = left.distanceSquared((Vector3fc)origin);
        if (leftL <= length && Intersectionf.testRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)new Vector3f((Vector3fc)left).sub(0.1f, 0.1f, 0.1f), (Vector3fc)new Vector3f((Vector3fc)left).add(0.1f, 0.1f, 0.1f))) {
            length = leftL;
            SELECTED_POINT.setControl(ControlType.LEFT);
        }
        return length;
    }

    private static void pickPoint(float length, Vector3f origin, Vector3f direction) {
        int time = -1;
        for (Int2ObjectMap.Entry entry : PATH.getEntries()) {
            Vector3f position = ((CameraKeyframe)entry.getValue()).getPos();
            float d = position.distanceSquared((Vector3fc)origin);
            if (d > length || !Intersectionf.testRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)new Vector3f((Vector3fc)position).sub(0.2f, 0.2f, 0.2f), (Vector3fc)new Vector3f((Vector3fc)position).add(0.2f, 0.2f, 0.2f)) || !(d < length)) continue;
            length = d;
            time = entry.getIntKey();
        }
        if (time >= 0) {
            SELECTED_POINT.setSelected(time);
        }
    }

    public static GlobalCameraPath getPath() {
        return PATH;
    }

    public static void setPath(GlobalCameraPath path) {
        PATH = path;
        SELECTED_POINT.reset();
    }

    public static SelectedPoint getSelectedPoint() {
        return SELECTED_POINT;
    }

    public static Mode getMode() {
        return MODE;
    }

    public static MoveModeData getMoveMode() {
        return MOVE_DATA;
    }

    public static void setNative(Vector3f pos, Vector3f rot) {
        NATIVE_POS.set((Vector3fc)pos);
        NATIVE_ROT.set((Vector3fc)rot);
        PATH.setNativeMode(true);
    }

    public static Vector3f getNativePos() {
        return NATIVE_POS;
    }

    public static Vector3f getNativeRot() {
        return NATIVE_ROT;
    }

    static {
        MODE = Mode.MOVE;
        MOVE_DATA = new MoveModeData();
        PATH = new GlobalCameraPath("new");
        SELECTED_POINT = new SelectedPoint();
        NATIVE_POS = new Vector3f();
        NATIVE_ROT = new Vector3f();
    }

    public static enum Mode {
        NONE,
        MOVE;

    }

    public static class MoveModeData {
        private MoveType moveType = MoveType.NONE;
        private final Vector3f delta = new Vector3f();

        private MoveModeData() {
        }

        public MoveType getMoveType() {
            return this.moveType;
        }

        public void reset() {
            this.moveType = MoveType.NONE;
        }

        private boolean pickMoveModule(Vector3f origin, Vector3f direction, boolean leftClick) {
            Vector3f max;
            Vector3f min;
            int selectedTime = SELECTED_POINT.getPointTime();
            if (selectedTime < 0) {
                return false;
            }
            if (leftClick) {
                Vector3f pos = SELECTED_POINT.getPosition();
                if (pos == null) {
                    return false;
                }
                float deadZone = 0.1f;
                float l = 1.25f;
                float w = 0.1f;
                if (!Intersectionf.testRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)new Vector3f((Vector3fc)pos).sub(w, w, 0.0f), (Vector3fc)new Vector3f((Vector3fc)pos).add(deadZone + l, deadZone + l, deadZone + l))) {
                    return false;
                }
                float min2 = Float.MAX_VALUE;
                Vector2f resultPos = new Vector2f();
                boolean result = false;
                if (Intersectionf.intersectRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)new Vector3f((Vector3fc)pos).add(deadZone, -w, -w), (Vector3fc)new Vector3f((Vector3fc)pos).add(deadZone + l, w, w), (Vector2f)resultPos)) {
                    min2 = resultPos.x;
                    result = true;
                    CameraAnimIdeCache.MOVE_DATA.moveType = MoveType.X;
                }
                if (Intersectionf.intersectRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)new Vector3f((Vector3fc)pos).add(-w, deadZone, -w), (Vector3fc)new Vector3f((Vector3fc)pos).add(w, deadZone + l, w), (Vector2f)resultPos) && min2 > resultPos.x) {
                    min2 = resultPos.x;
                    result = true;
                    CameraAnimIdeCache.MOVE_DATA.moveType = MoveType.Y;
                }
                if (Intersectionf.intersectRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)new Vector3f((Vector3fc)pos).add(-w, -w, deadZone), (Vector3fc)new Vector3f((Vector3fc)pos).add(w, w, deadZone + l), (Vector2f)resultPos) && min2 > resultPos.x) {
                    min2 = resultPos.x;
                    result = true;
                    CameraAnimIdeCache.MOVE_DATA.moveType = MoveType.Z;
                }
                float spacing = 0.2f;
                float size = 0.3f;
                if (Intersectionf.intersectRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)new Vector3f((Vector3fc)pos).add(spacing, spacing, -w), (Vector3fc)new Vector3f((Vector3fc)pos).add(size + spacing, size + spacing, w), (Vector2f)resultPos) && min2 > resultPos.x) {
                    min2 = resultPos.x;
                    result = true;
                    CameraAnimIdeCache.MOVE_DATA.moveType = MoveType.XY;
                }
                if (Intersectionf.intersectRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)new Vector3f((Vector3fc)pos).add(spacing, -w, spacing), (Vector3fc)new Vector3f((Vector3fc)pos).add(size + spacing, w, size + spacing), (Vector2f)resultPos) && min2 > resultPos.x) {
                    min2 = resultPos.x;
                    result = true;
                    CameraAnimIdeCache.MOVE_DATA.moveType = MoveType.XZ;
                }
                if (Intersectionf.intersectRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)new Vector3f((Vector3fc)pos).add(-w, spacing, spacing), (Vector3fc)new Vector3f((Vector3fc)pos).add(w, size + spacing, size + spacing), (Vector2f)resultPos) && min2 > resultPos.x) {
                    min2 = resultPos.x;
                    result = true;
                    CameraAnimIdeCache.MOVE_DATA.moveType = MoveType.YZ;
                }
                CameraAnimIdeCache.MOVE_DATA.delta.set((Vector3fc)direction).mul(min2).add((Vector3fc)origin).sub((Vector3fc)pos).mul(-1.0f);
                return result;
            }
            switch (CameraAnimIdeCache.SELECTED_POINT.control) {
                case LEFT: {
                    CameraKeyframe point = PATH.getPoint(CameraAnimIdeCache.SELECTED_POINT.pointTime);
                    if (point == null) {
                        return false;
                    }
                    Vector3f pos = point.getPathBezier().getLeft();
                    min = new Vector3f((Vector3fc)pos).sub(0.1f, 0.1f, 0.1f);
                    max = new Vector3f((Vector3fc)pos).add(0.1f, 0.1f, 0.1f);
                    break;
                }
                case RIGHT: {
                    CameraKeyframe point = PATH.getPoint(CameraAnimIdeCache.SELECTED_POINT.pointTime);
                    if (point == null) {
                        return false;
                    }
                    Vector3f pos = point.getPathBezier().getRight();
                    min = new Vector3f((Vector3fc)pos).sub(0.1f, 0.1f, 0.1f);
                    max = new Vector3f((Vector3fc)pos).add(0.1f, 0.1f, 0.1f);
                    break;
                }
                case NONE: {
                    CameraKeyframe point = PATH.getPoint(CameraAnimIdeCache.SELECTED_POINT.pointTime);
                    if (point == null) {
                        return false;
                    }
                    Vector3f pos = point.getPos();
                    min = new Vector3f((Vector3fc)pos).sub(0.2f, 0.2f, 0.2f);
                    max = new Vector3f((Vector3fc)pos).add(0.2f, 0.2f, 0.2f);
                    break;
                }
                default: {
                    return false;
                }
            }
            Vector2f resultPos = new Vector2f();
            if (Intersectionf.intersectRayAab((Vector3fc)origin, (Vector3fc)direction, (Vector3fc)min, (Vector3fc)max, (Vector2f)resultPos)) {
                CameraAnimIdeCache.MOVE_DATA.delta.set(resultPos.x);
                CameraAnimIdeCache.MOVE_DATA.moveType = MoveType.XYZ;
                return true;
            }
            return false;
        }

        private void move() {
            if (CameraAnimIdeCache.SELECTED_POINT.pointTime < 0 || this.moveType == MoveType.NONE) {
                return;
            }
            Vector3f pos = SELECTED_POINT.getPosition();
            if (pos == null) {
                return;
            }
            Vector3f view = ClientUtil.playerView();
            Vector3f origin = ClientUtil.playerEyePos();
            float yRot = ClientUtil.playerYHeadRot();
            float xRot = ClientUtil.playerXRot();
            switch (this.moveType) {
                case X: {
                    float t;
                    float a = Intersectionf.intersectRayPlane((float)origin.x, (float)origin.y, (float)origin.z, (float)view.x, (float)view.y, (float)view.z, (float)pos.x, (float)pos.y, (float)pos.z, (float)0.0f, (float)(xRot < 0.0f ? -1.0f : 1.0f), (float)0.0f, (float)1.0E-6f);
                    float b = Intersectionf.intersectRayPlane((float)origin.x, (float)origin.y, (float)origin.z, (float)view.x, (float)view.y, (float)view.z, (float)pos.x, (float)pos.y, (float)pos.z, (float)0.0f, (float)0.0f, (float)(Math.abs((float)yRot) >= 90.0f ? 1.0f : -1.0f), (float)1.0E-6f);
                    float f = a == 0.0f ? b : (t = b == 0.0f ? a : Math.min((float)a, (float)b));
                    if (t < 0.0f) {
                        return;
                    }
                    t = Math.clamp((float)0.0f, (float)100.0f, (float)t);
                    pos.x = view.x * t + origin.x + this.delta.x;
                    break;
                }
                case Y: {
                    float t = Intersectionf.intersectRayPlane((float)origin.x, (float)origin.y, (float)origin.z, (float)view.x, (float)view.y, (float)view.z, (float)pos.x, (float)pos.y, (float)pos.z, (float)(yRot < 0.0f ? -1.0f : 1.0f), (float)0.0f, (float)0.0f, (float)1.0E-6f);
                    if (t < 0.0f) {
                        return;
                    }
                    t = Math.clamp((float)0.0f, (float)100.0f, (float)t);
                    pos.y = view.y * t + origin.y + this.delta.y;
                    break;
                }
                case Z: {
                    float t;
                    float a = Intersectionf.intersectRayPlane((float)origin.x, (float)origin.y, (float)origin.z, (float)view.x, (float)view.y, (float)view.z, (float)pos.x, (float)pos.y, (float)pos.z, (float)0.0f, (float)(xRot < 0.0f ? -1.0f : 1.0f), (float)0.0f, (float)1.0E-6f);
                    float b = Intersectionf.intersectRayPlane((float)origin.x, (float)origin.y, (float)origin.z, (float)view.x, (float)view.y, (float)view.z, (float)pos.x, (float)pos.y, (float)pos.z, (float)(yRot >= 0.0f ? 1.0f : -1.0f), (float)0.0f, (float)0.0f, (float)1.0E-6f);
                    float f = a == 0.0f ? b : (t = b == 0.0f ? a : Math.min((float)a, (float)b));
                    if (t < 0.0f) {
                        return;
                    }
                    t = Math.clamp((float)0.0f, (float)100.0f, (float)t);
                    pos.z = view.z * t + origin.z + this.delta.z;
                    break;
                }
                case XY: {
                    float t = Intersectionf.intersectRayPlane((float)origin.x, (float)origin.y, (float)origin.z, (float)view.x, (float)view.y, (float)view.z, (float)pos.x, (float)pos.y, (float)pos.z, (float)0.0f, (float)0.0f, (float)(Math.abs((float)yRot) < 90.0f ? -1.0f : 1.0f), (float)1.0E-6f);
                    if (t < 0.0f) {
                        return;
                    }
                    t = Math.clamp((float)0.0f, (float)100.0f, (float)t);
                    pos.x = view.x * t + origin.x + this.delta.x;
                    pos.y = view.y * t + origin.y + this.delta.y;
                    break;
                }
                case XZ: {
                    float t = Intersectionf.intersectRayPlane((float)origin.x, (float)origin.y, (float)origin.z, (float)view.x, (float)view.y, (float)view.z, (float)pos.x, (float)pos.y, (float)pos.z, (float)0.0f, (float)(xRot < 0.0f ? -1.0f : 1.0f), (float)0.0f, (float)1.0E-6f);
                    if (t < 0.0f) {
                        return;
                    }
                    t = Math.clamp((float)0.0f, (float)100.0f, (float)t);
                    pos.x = view.x * t + origin.x + this.delta.x;
                    pos.z = view.z * t + origin.z + this.delta.z;
                    break;
                }
                case YZ: {
                    float t = Intersectionf.intersectRayPlane((float)origin.x, (float)origin.y, (float)origin.z, (float)view.x, (float)view.y, (float)view.z, (float)pos.x, (float)pos.y, (float)pos.z, (float)(yRot < 0.0f ? -1.0f : 1.0f), (float)0.0f, (float)0.0f, (float)1.0E-6f);
                    if (t < 0.0f) {
                        return;
                    }
                    t = Math.clamp((float)0.0f, (float)100.0f, (float)t);
                    pos.z = view.z * t + origin.z + this.delta.z;
                    pos.y = view.y * t + origin.y + this.delta.y;
                    break;
                }
                case XYZ: {
                    pos.set((Vector3fc)view).mul(this.delta.x).add((Vector3fc)origin);
                }
            }
        }
    }

    public static enum MoveType {
        X,
        Y,
        Z,
        XY,
        XZ,
        YZ,
        XYZ,
        NONE;

    }

    public static class SelectedPoint {
        private int pointTime = -1;
        private ControlType control = ControlType.NONE;

        public void setSelected(int time) {
            this.pointTime = time;
            this.control = ControlType.NONE;
        }

        private void setControl(ControlType control) {
            this.control = control;
        }

        public int getPointTime() {
            return this.pointTime;
        }

        public ControlType getControl() {
            return this.control;
        }

        @Nullable
        public Vector3f getPosition() {
            Vector3f pos = null;
            switch (this.control) {
                case LEFT: {
                    CameraKeyframe point = PATH.getPoint(this.pointTime);
                    if (point == null) break;
                    pos = point.getPathBezier().getLeft();
                    break;
                }
                case RIGHT: {
                    CameraKeyframe point = PATH.getPoint(this.pointTime);
                    if (point == null) break;
                    pos = point.getPathBezier().getRight();
                    break;
                }
                case NONE: {
                    CameraKeyframe point = PATH.getPoint(this.pointTime);
                    if (point == null) break;
                    pos = point.getPos();
                }
            }
            return pos;
        }

        public void reset() {
            this.pointTime = -1;
            this.control = ControlType.NONE;
        }
    }

    public static enum ControlType {
        LEFT,
        RIGHT,
        NONE;

    }
}

