/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.cameraanim.client;

import cn.anecansaitin.cameraanim.InterpolationMath;
import cn.anecansaitin.cameraanim.client.CameraAnimIdeCache;
import cn.anecansaitin.cameraanim.client.ClientUtil;
import cn.anecansaitin.cameraanim.common.animation.CameraKeyframe;
import cn.anecansaitin.cameraanim.common.animation.GlobalCameraPath;
import cn.anecansaitin.cameraanim.common.animation.TimeInterpolator;
import java.util.Map;
import net.minecraft.util.Mth;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PreviewAnimator {
    public static final PreviewAnimator INSTANCE = new PreviewAnimator();
    private boolean playing;
    private int time;

    public void tick() {
        if (!this.playing) {
            return;
        }
        if (this.time >= CameraAnimIdeCache.getPath().getLength()) {
            this.reset();
        } else {
            ++this.time;
        }
    }

    public void play() {
        this.playing = true;
    }

    public void stop() {
        this.playing = false;
    }

    public void reset() {
        this.time = 0;
        this.playing = false;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void back() {
        if (this.time <= 0) {
            return;
        }
        this.time = Math.max(0, this.time - 5);
    }

    public void forward() {
        if (this.time >= CameraAnimIdeCache.getPath().getLength()) {
            return;
        }
        this.time = Math.min(CameraAnimIdeCache.getPath().getLength(), this.time + 5);
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public boolean prepareCameraInfo(Vector3f posDest, Vector3f rotDest, float[] fov) {
        float tf;
        float tr;
        float tp;
        float partialTicks = this.isPlaying() ? ClientUtil.partialTicks() : 0.0f;
        GlobalCameraPath track = CameraAnimIdeCache.getPath();
        Map.Entry<Integer, CameraKeyframe> current = track.getEntry(this.time);
        Map.Entry<Integer, CameraKeyframe> preEntry = current == null ? track.getPreEntry(this.time) : current;
        Map.Entry<Integer, CameraKeyframe> nextEntry = track.getNextEntry(this.time);
        if (preEntry == null) {
            if (nextEntry == null) {
                return false;
            }
            posDest.set((Vector3fc)nextEntry.getValue().getPos());
            rotDest.set((Vector3fc)nextEntry.getValue().getRot());
            return true;
        }
        if (nextEntry == null) {
            posDest.set((Vector3fc)preEntry.getValue().getPos());
            rotDest.set((Vector3fc)preEntry.getValue().getRot());
            return true;
        }
        float t = (partialTicks + (float)this.time - (float)preEntry.getKey().intValue()) / (float)(nextEntry.getKey() - preEntry.getKey());
        CameraKeyframe pre = preEntry.getValue();
        CameraKeyframe next = nextEntry.getValue();
        if (next.getPosTimeInterpolator() == TimeInterpolator.BEZIER) {
            tp = next.getPosBezier().interpolate(t);
            tr = next.getRotBezier().interpolate(t);
            tf = next.getFovBezier().interpolate(t);
        } else {
            tp = t;
            tr = t;
            tf = t;
        }
        switch (next.getPathInterpolator()) {
            case LINEAR: {
                InterpolationMath.line(tp, pre.getPos(), next.getPos(), posDest);
                InterpolationMath.line(tr, pre.getRot(), next.getRot(), rotDest);
                fov[0] = Mth.m_14179_((float)tf, (float)pre.getFov(), (float)next.getFov());
                break;
            }
            case SMOOTH: {
                Map.Entry<Integer, CameraKeyframe> prePre = track.getPreEntry(preEntry.getKey());
                Vector3f p0 = prePre == null ? pre.getPos() : prePre.getValue().getPos();
                Map.Entry<Integer, CameraKeyframe> nextNext = track.getNextEntry(nextEntry.getKey());
                Vector3f p3 = nextNext == null ? next.getPos() : nextNext.getValue().getPos();
                InterpolationMath.catmullRom(tp, p0, pre.getPos(), next.getPos(), p3, posDest);
                InterpolationMath.line(tr, pre.getRot(), next.getRot(), rotDest);
                fov[0] = Mth.m_14179_((float)tf, (float)pre.getFov(), (float)next.getFov());
                break;
            }
            case BEZIER: {
                next.getPathBezier().interpolate(tp, pre.getPos(), next.getPos(), posDest);
                InterpolationMath.line(tr, pre.getRot(), next.getRot(), rotDest);
                fov[0] = Mth.m_14179_((float)tf, (float)pre.getFov(), (float)next.getFov());
                break;
            }
            case STEP: {
                posDest.set((Vector3fc)pre.getPos());
                rotDest.set((Vector3fc)pre.getRot());
                fov[0] = pre.getFov();
            }
        }
        return true;
    }
}

