/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.cameraanim.client.gui.screen;

import cn.anecansaitin.cameraanim.InterpolationMath;
import cn.anecansaitin.cameraanim.client.CameraAnimIdeCache;
import cn.anecansaitin.cameraanim.common.animation.CameraKeyframe;
import cn.anecansaitin.cameraanim.common.animation.TimeBezierController;
import cn.anecansaitin.cameraanim.common.animation.TimeInterpolator;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class InterpolationSettingScreen
extends Screen {
    private static final Component INTERPOLATION = Component.m_237115_((String)"gui.camera_anim.interpolation_setting.interpolation");
    private static final Component TYPE = Component.m_237115_((String)"gui.camera_anim.interpolation_setting.type");
    private static final Component EASY = Component.m_237115_((String)"gui.camera_anim.interpolation_setting.easy");
    private static final Component EASY_IN = Component.m_237115_((String)"gui.camera_anim.interpolation_setting.easy_in");
    private static final Component EASY_OUT = Component.m_237115_((String)"gui.camera_anim.interpolation_setting.easy_out");
    private static final Component EASY_IN_OUT = Component.m_237115_((String)"gui.camera_anim.interpolation_setting.easy_in_out");
    private static final Component SAVE = Component.m_237115_((String)"gui.camera_anim.interpolation_setting.save");
    private static final Component TIME = Component.m_237115_((String)"gui.camera_anim.interpolation_setting.time");
    private static final Component DISTANCE = Component.m_237115_((String)"gui.camera_anim.interpolation_setting.distance");
    private final int valueType;
    private Vector2f zero = new Vector2f(21.0f, 161.0f);
    private Vector2f one = new Vector2f(101.0f, 81.0f);
    private Vector2f left = new Vector2f();
    private Vector2f right = new Vector2f();
    private final Vector2f vCache1 = new Vector2f();
    private final Vector2f vCache2 = new Vector2f();
    private final Vector2f vCache3 = new Vector2f();
    private final Vector2f vCache4 = new Vector2f();
    private final Vector2f vCache5 = new Vector2f();
    private CycleButton<TimeInterpolator> typeSwitch;

    public InterpolationSettingScreen(int valueType) {
        super(INTERPOLATION);
        this.valueType = valueType;
    }

    protected void m_7856_() {
        TimeBezierController bezier;
        CameraAnimIdeCache.SelectedPoint selectedPoint = CameraAnimIdeCache.getSelectedPoint();
        CameraKeyframe point = CameraAnimIdeCache.getPath().getPoint(selectedPoint.getPointTime());
        if (point == null) {
            this.m_7379_();
            return;
        }
        int x = 20;
        int y = 20;
        this.typeSwitch = CycleButton.m_168894_(TimeInterpolator::getDisplayName).m_168961_((Object[])TimeInterpolator.values()).m_168948_((Object)TimeInterpolator.LINEAR).m_168936_(x + 200, y + 60, 70, 20, TYPE, (b, t) -> {});
        this.m_142416_((GuiEventListener)this.typeSwitch);
        switch (this.valueType) {
            case 1: {
                this.typeSwitch.m_168892_((Object)point.getPosTimeInterpolator());
                TimeBezierController timeBezierController = point.getPosBezier();
                break;
            }
            case 2: {
                this.typeSwitch.m_168892_((Object)point.getRotTimeInterpolator());
                TimeBezierController timeBezierController = point.getRotBezier();
                break;
            }
            case 3: {
                this.typeSwitch.m_168892_((Object)point.getFovTimeInterpolator());
                TimeBezierController timeBezierController = point.getFovBezier();
                break;
            }
            default: {
                TimeBezierController timeBezierController = bezier = null;
            }
        }
        if (bezier == null) {
            this.m_7379_();
            return;
        }
        this.left.set((Vector2fc)bezier.getLeft());
        this.right.set((Vector2fc)bezier.getRight());
        Bezier bezier1 = new Bezier(this.left, this.zero.x, this.zero.y);
        Bezier bezier2 = new Bezier(this.right, this.zero.x, this.zero.y);
        this.m_142416_((GuiEventListener)bezier1);
        this.m_142416_((GuiEventListener)bezier2);
        this.m_142416_((GuiEventListener)new ExtendedButton(x + 100, y + 60, 80, 20, EASY_IN, b -> {
            this.left.set(0.42f, 0.0f);
            this.right.set(1.0f, 1.0f);
            bezier1.update();
            bezier2.update();
        }));
        this.m_142416_((GuiEventListener)new ExtendedButton(x + 100, y + 80, 80, 20, EASY_OUT, b -> {
            this.left.set(0.0f, 0.0f);
            this.right.set(0.58f, 1.0f);
            bezier1.update();
            bezier2.update();
        }));
        this.m_142416_((GuiEventListener)new ExtendedButton(x + 100, y + 100, 80, 20, EASY_IN_OUT, b -> {
            this.left.set(0.42f, 0.0f);
            this.right.set(0.58f, 1.0f);
            bezier1.update();
            bezier2.update();
        }));
        this.m_142416_((GuiEventListener)new ExtendedButton(x + 100, y + 120, 80, 20, EASY, b -> {
            this.left.set(0.25f, 0.1f);
            this.right.set(0.25f, 1.0f);
            bezier1.update();
            bezier2.update();
        }));
        this.m_142416_((GuiEventListener)new ExtendedButton(x + 100, y + 160, 50, 20, SAVE, b -> {
            TimeBezierController controller;
            switch (this.valueType) {
                case 1: {
                    point.setPosTimeInterpolator((TimeInterpolator)((Object)((Object)this.typeSwitch.m_168883_())));
                    controller = point.getPosBezier();
                    break;
                }
                case 2: {
                    point.setRotTimeInterpolator((TimeInterpolator)((Object)((Object)this.typeSwitch.m_168883_())));
                    controller = point.getRotBezier();
                    break;
                }
                case 3: {
                    point.setFovTimeInterpolator((TimeInterpolator)((Object)((Object)this.typeSwitch.m_168883_())));
                    controller = point.getFovBezier();
                    break;
                }
                default: {
                    return;
                }
            }
            controller.setLeft(this.left.x, this.left.y);
            controller.setRight(this.right.x, this.right.y);
            this.m_7379_();
        }));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        int x = 20;
        int y = 20;
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280315_(x, y + 60, y + 60 + 80, -40192);
        guiGraphics.m_280315_(x + 80, y + 60, y + 60 + 80, -40192);
        guiGraphics.m_280656_(x, x + 80, y + 60, -40192);
        guiGraphics.m_280656_(x, x + 80, y + 60 + 80, -40192);
        guiGraphics.m_280430_(this.f_96547_, TIME, x, y + 145, -1);
        guiGraphics.m_280488_(this.f_96547_, "\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014>", x, y + 139, -1);
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_252781_(new Quaternionf().rotateZ(-1.5707964f));
        this.f_96547_.m_272077_(DISTANCE, -161.0f, 8.0f, -1, false, pose.m_85850_().m_252922_(), (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.f_96547_.m_271703_("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014>", -161.0f, 15.0f, -1, false, pose.m_85850_().m_252922_(), (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        pose.m_85849_();
        MultiBufferSource.BufferSource bufferSource = guiGraphics.m_280091_();
        PoseStack.Pose last = guiGraphics.m_280168_().m_85850_();
        VertexConsumer buffer = bufferSource.m_6299_((RenderType)RenderType.f_110371_);
        if (this.typeSwitch.m_168883_() == TimeInterpolator.BEZIER) {
            Vector2f pre = this.vCache2.set((Vector2fc)this.zero);
            this.vCache4.set((Vector2fc)this.left).mul(80.0f, -80.0f).add((Vector2fc)this.zero);
            this.vCache5.set((Vector2fc)this.right).mul(80.0f, -80.0f).add((Vector2fc)this.zero);
            for (int i = 0; i < 20; ++i) {
                float t = (float)i * 0.05f;
                Vector2f next = InterpolationMath.bezier(t, this.zero, this.vCache4, this.vCache5, this.one, this.vCache3);
                this.addLine(buffer, last, pre, next, -1);
                pre.set((Vector2fc)next);
            }
            this.addLine(buffer, last, pre, this.one, -1);
        } else {
            this.addLine(buffer, last, this.zero, this.one, -1);
        }
        guiGraphics.m_280262_();
    }

    private void addLine(VertexConsumer buffer, PoseStack.Pose pose, Vector2f pos1, Vector2f pos2, int color) {
        Vector2f normalize = this.vCache1.set((Vector2fc)pos2).sub((Vector2fc)pos1).normalize();
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f normal = pose.m_252943_();
        buffer.m_252986_(matrix4f, pos1.x, pos1.y, 0.0f).m_193479_(color).m_252939_(normal, normalize.x, normalize.y, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, pos2.x, pos2.y, 0.0f).m_193479_(color).m_252939_(normal, normalize.x, normalize.y, 0.0f).m_5752_();
    }

    private static final class Bezier
    extends AbstractWidget {
        private final Vector2f point;
        private final float zeroX;
        private final float zeroY;

        private Bezier(Vector2f point, float x, float y) {
            super((int)(point.x * 80.0f + x - 2.0f), (int)(point.y * -80.0f + y - 2.0f), 5, 5, (Component)Component.m_237113_((String)"\u8d1d\u585e\u5c14\u70b9"));
            this.point = point;
            this.zeroX = x;
            this.zeroY = y;
        }

        protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            MultiBufferSource.BufferSource bufferSource = guiGraphics.m_280091_();
            PoseStack.Pose last = guiGraphics.m_280168_().m_85850_();
            Matrix4f matrix4f = last.m_252922_();
            VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_285907_());
            buffer.m_252986_(matrix4f, this.point.x * 80.0f + this.zeroX + 2.0f, this.point.y * -80.0f + this.zeroY + 2.0f, 0.0f).m_193479_(-3881788).m_5752_();
            buffer.m_252986_(matrix4f, this.point.x * 80.0f + this.zeroX + 2.0f, this.point.y * -80.0f + this.zeroY - 2.0f, 0.0f).m_193479_(-3881788).m_5752_();
            buffer.m_252986_(matrix4f, this.point.x * 80.0f + this.zeroX - 2.0f, this.point.y * -80.0f + this.zeroY - 2.0f, 0.0f).m_193479_(-3881788).m_5752_();
            buffer.m_252986_(matrix4f, this.point.x * 80.0f + this.zeroX - 2.0f, this.point.y * -80.0f + this.zeroY + 2.0f, 0.0f).m_193479_(-3881788).m_5752_();
        }

        protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
            this.point.add((float)dragX / 100.0f, (float)(-dragY) / 100.0f);
            this.point.x = Math.clamp((float)0.0f, (float)1.0f, (float)this.point.x);
            this.update();
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        }

        public void update() {
            this.m_252865_((int)(this.point.x * 80.0f + this.zeroX - 2.0f));
            this.m_253211_((int)(this.point.y * -80.0f + this.zeroY - 2.0f));
        }
    }
}

