/*
 * Decompiled with CFR 0.152.
 */
package cn.anecansaitin.cameraanim.client.gui.screen;

import cn.anecansaitin.cameraanim.client.CameraAnimIdeCache;
import cn.anecansaitin.cameraanim.client.ClientUtil;
import cn.anecansaitin.cameraanim.client.gui.screen.InfoScreen;
import cn.anecansaitin.cameraanim.client.gui.screen.RemotePathSearchScreen;
import cn.anecansaitin.cameraanim.client.gui.widget.NumberEditBox;
import cn.anecansaitin.cameraanim.common.animation.CameraKeyframe;
import cn.anecansaitin.cameraanim.common.animation.GlobalCameraPath;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.fml.loading.FMLPaths;
import org.joml.Vector3f;
import oshi.util.tuples.Triplet;

public class LocalPathSearchScreen
extends Screen {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
    private static final ZoneId ZONE_ID = ZoneId.systemDefault();
    private final List<Triplet<Component, Component, Component>> list = new ArrayList<Triplet<Component, Component, Component>>();
    private static final Gson GSON = new Gson();
    private static final String SERIALIZER_VERSION = "1.0.0";
    private static final Component PAGE = Component.m_237115_((String)"gui.camera_anim.local_path_search.page");
    private static final Component SEARCH = Component.m_237115_((String)"gui.camera_anim.local_path_search.search");
    private static final Component LOAD = Component.m_237115_((String)"gui.camera_anim.local_path_search.load");
    private static final Component LOAD_ID = Component.m_237115_((String)"gui.camera_anim.local_path_search.load_id");
    private static final Component SAVE = Component.m_237115_((String)"gui.camera_anim.local_path_search.save");
    private static final Component SAVE_ID = Component.m_237115_((String)"gui.camera_anim.local_path_search.save_id");
    private static final Component REMOTE_MODE = Component.m_237115_((String)"gui.camera_anim.local_path_search.remote_mode");
    private static final Component PATH_ID = Component.m_237115_((String)"gui.camera_anim.local_path_search.path_id");
    private static final Component MODIFIER = Component.m_237115_((String)"gui.camera_anim.local_path_search.modifier");
    private static final Component TIME = Component.m_237115_((String)"gui.camera_anim.local_path_search.time");
    private static final Component TIP = Component.m_237115_((String)"gui.camera_anim.local_path_search.tip");
    private static final Component LOCAL_FILE = Component.m_237115_((String)"gui.camera_anim.local_path_search.local_file");
    private static final Component LOAD_ERROR = Component.m_237115_((String)"gui.camera_anim.local_path_search.load_error");
    private static final Component VERSION_ERROR = Component.m_237115_((String)"gui.camera_anim.local_path_search.version_error");
    private static final Component FILE_LOAD_ERROR = Component.m_237115_((String)"gui.camera_anim.local_path_search.file_load_error");
    private static final Component FILE_FORMAT_ERROR = Component.m_237115_((String)"gui.camera_anim.local_path_search.file_format_error");
    private static final Component FILE_EXIST_ERROR = Component.m_237115_((String)"gui.camera_anim.local_path_search.file_exist_error");
    private static final Component FILE_SAVE_ERROR = Component.m_237115_((String)"gui.camera_anim.local_path_search.file_save_error");
    private static final Component FILE_LOAD_SUCCESS = Component.m_237115_((String)"gui.camera_anim.local_path_search.file_load_success");

    public LocalPathSearchScreen() {
        super((Component)Component.m_237113_((String)"local path search"));
    }

    protected void m_7856_() {
        NumberEditBox page = (NumberEditBox)this.m_142416_((GuiEventListener)new NumberEditBox(this.f_96547_, 20, 20, 20, 20, 1, (Component)Component.m_237113_((String)"page")));
        EditBox path = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, 205, 20, 50, 20, (Component)Component.m_237113_((String)"path id")));
        EditBox newId = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, 315, 20, 50, 20, (Component)Component.m_237113_((String)"new id")));
        newId.m_94144_(CameraAnimIdeCache.getPath().getId());
        this.m_142416_((GuiEventListener)new ExtendedButton(45, 20, 100, 20, SEARCH, b -> this.searchFromFile(Integer.parseInt(page.m_94155_()), 16)));
        this.m_142416_((GuiEventListener)new ExtendedButton(150, 20, 50, 20, LOAD, b -> this.getFromFile(path.m_94155_())));
        this.m_142416_((GuiEventListener)new ExtendedButton(260, 20, 50, 20, SAVE, b -> this.saveToFile(newId.m_94155_())));
        this.m_142416_((GuiEventListener)new ExtendedButton(260, 80, 70, 20, REMOTE_MODE, b -> Minecraft.m_91087_().m_91152_((Screen)new RemotePathSearchScreen())));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280430_(this.f_96547_, PAGE, 25, 10, -1);
        guiGraphics.m_280430_(this.f_96547_, LOAD_ID, 215, 10, -1);
        guiGraphics.m_280430_(this.f_96547_, SAVE_ID, 325, 10, -1);
        guiGraphics.m_280430_(this.f_96547_, PATH_ID, 20, 49, -1);
        guiGraphics.m_280430_(this.f_96547_, MODIFIER, 60, 49, -1);
        guiGraphics.m_280430_(this.f_96547_, TIME, 100, 49, -1);
        if (!this.list.isEmpty()) {
            int listSize = this.list.size();
            for (int i = 0; i < listSize; ++i) {
                Triplet<Component, Component, Component> info = this.list.get(i);
                guiGraphics.m_280430_(this.f_96547_, (Component)info.getA(), 20, 60 + i * 11, -1);
                guiGraphics.m_280430_(this.f_96547_, (Component)info.getB(), 60, 60 + i * 11, -1);
                guiGraphics.m_280430_(this.f_96547_, (Component)info.getC(), 100, 60 + i * 11, -1);
            }
        } else {
            guiGraphics.m_280653_(this.f_96547_, TIP, 180, 200, -1);
        }
    }

    private void searchFromFile(int page, final int size) {
        Path path = FMLPaths.GAMEDIR.get().resolve("camera-anim");
        this.list.clear();
        final int start = (page - 1) * size;
        if (path.toFile().exists()) {
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                    private int count = 0;

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String name = file.getFileName().toString();
                        if (name.endsWith(".json") && this.count++ >= start) {
                            LocalPathSearchScreen.this.list.add((Triplet<Component, Component, Component>)new Triplet((Object)Component.m_237113_((String)name.substring(0, name.length() - 5)), (Object)LOCAL_FILE, (Object)Component.m_237113_((String)FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(attrs.lastModifiedTime().toMillis()), ZONE_ID)))));
                        }
                        if (LocalPathSearchScreen.this.list.size() >= size) {
                            return FileVisitResult.TERMINATE;
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                ClientUtil.pushGuiLayer(new InfoScreen(LOAD_ERROR));
            }
        }
    }

    private void getFromFile(String id) {
        block7: {
            Path path = FMLPaths.GAMEDIR.get().resolve("camera-anim").resolve(id + ".json");
            File file = path.toFile();
            if (file.exists()) {
                try {
                    String json = Files.readString(path);
                    JsonObject jsonObject = (JsonObject)GSON.fromJson(json, JsonObject.class);
                    if (jsonObject.has("version") && jsonObject.get("version").getAsString().equals(SERIALIZER_VERSION)) {
                        TypeToken<TreeMap<Integer, CameraKeyframe>> type = new TypeToken<TreeMap<Integer, CameraKeyframe>>(){};
                        TreeMap map = (TreeMap)GSON.fromJson(jsonObject.get("anim"), type.getType());
                        GlobalCameraPath animPath = new GlobalCameraPath(map, id);
                        if (jsonObject.has("native") && jsonObject.get("native").getAsBoolean()) {
                            Vector3f center = ClientUtil.player().m_20182_().m_252839_();
                            animPath = animPath.fromNative(center, ClientUtil.playerYHeadRot());
                            CameraAnimIdeCache.setNative(center, new Vector3f(0.0f, ClientUtil.playerYHeadRot(), 0.0f));
                        }
                        CameraAnimIdeCache.setPath(animPath);
                        ClientUtil.pushGuiLayer(new InfoScreen(FILE_LOAD_SUCCESS));
                        break block7;
                    }
                    ClientUtil.pushGuiLayer(new InfoScreen(VERSION_ERROR));
                }
                catch (IOException e) {
                    ClientUtil.pushGuiLayer(new InfoScreen(FILE_LOAD_ERROR));
                }
                catch (JsonSyntaxException | NullPointerException e) {
                    ClientUtil.pushGuiLayer(new InfoScreen(FILE_FORMAT_ERROR));
                }
            } else {
                ClientUtil.pushGuiLayer(new InfoScreen(FILE_EXIST_ERROR));
            }
        }
    }

    private void saveToFile(String id) {
        Path animDirectory = FMLPaths.GAMEDIR.get().resolve("camera-anim");
        Path path = animDirectory.resolve(id + ".json");
        try {
            GlobalCameraPath animPath = CameraAnimIdeCache.getPath();
            JsonObject jsonObject = new JsonObject();
            if (animPath.isNativeMode()) {
                animPath = animPath.toNative(CameraAnimIdeCache.getNativePos(), CameraAnimIdeCache.getNativeRot().y);
                jsonObject.addProperty("native", Boolean.valueOf(true));
            }
            JsonObject json = (JsonObject)GSON.fromJson(animPath.toJsonString(GSON), JsonObject.class);
            jsonObject.addProperty("version", SERIALIZER_VERSION);
            jsonObject.add("anim", (JsonElement)json);
            if (!Files.isDirectory(animDirectory, new LinkOption[0])) {
                Files.createDirectories(animDirectory, new FileAttribute[0]);
            }
            Files.writeString(path, (CharSequence)jsonObject.toString(), new OpenOption[0]);
            ClientUtil.pushGuiLayer(new InfoScreen("Save successes!"));
        }
        catch (IOException e) {
            ClientUtil.pushGuiLayer(new InfoScreen(FILE_SAVE_ERROR));
        }
    }
}

